/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.util;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.client.resource.ExperimentalResourcePack;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtil
extends Enum<ResourceUtil> {
    private static RuntimeResourcePack PACK;
    private static ExperimentalResourcePack EXPERIMENTAL_PACK;
    public static final String CHEST_ITEM_MODEL_RESOURCE = "{\"parent\":\"block/chest_center\",\"overrides\":[{\"predicate\":{\"is_christmas\":1},\"model\": \"item/christmas_chest\"}]}";
    private static final /* synthetic */ ResourceUtil[] $VALUES;

    public static ResourceUtil[] values() {
        return (ResourceUtil[])$VALUES.clone();
    }

    public static ResourceUtil valueOf(String name) {
        return Enum.valueOf(ResourceUtil.class, name);
    }

    public static void addSingleChestModels(String texture, String chestName, RuntimeResourcePack pack) {
        pack.addModel(JModel.model().parent("block/template_chest_center").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center"));
        pack.addModel(JModel.model().parent("block/template_chest_center_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_center_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center_trunk"));
    }

    public static void addDoubleChestModels(String leftTex, String rightTex, String chestName, RuntimeResourcePack pack) {
        pack.addModel(JModel.model().parent("block/template_chest_left").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left"));
        pack.addModel(JModel.model().parent("block/template_chest_left_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_left_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left_trunk"));
        pack.addModel(JModel.model().parent("block/template_chest_right").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right"));
        pack.addModel(JModel.model().parent("block/template_chest_right_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_right_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right_trunk"));
    }

    private static JTextures withChestParticle(JTextures textures, String chestName) {
        if (EnhancedBlockEntities.CONFIG.experimentalChests) {
            textures.var("particle", "block/" + chestName + "_particle");
        }
        return textures;
    }

    private static JTextures withBedParticle(JTextures textures, String bedColor) {
        if (EnhancedBlockEntities.CONFIG.experimentalBeds) {
            textures.var("particle", "block/" + bedColor + "_bed_particle");
        }
        return textures;
    }

    private static JTextures withSignParticle(JTextures textures, String signName) {
        if (EnhancedBlockEntities.CONFIG.experimentalSigns) {
            textures.var("particle", "block/" + signName + "_particle");
        }
        return textures;
    }

    public static void addChestBlockStates(String chestName, RuntimeResourcePack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("facing=east,type=single", JState.model((String)("builtin:" + chestName + "_center")).y(90)).put("facing=north,type=single", JState.model((String)("builtin:" + chestName + "_center"))).put("facing=south,type=single", JState.model((String)("builtin:" + chestName + "_center")).y(180)).put("facing=west,type=single", JState.model((String)("builtin:" + chestName + "_center")).y(270)).put("facing=east,type=left", JState.model((String)("builtin:" + chestName + "_left")).y(90)).put("facing=north,type=left", JState.model((String)("builtin:" + chestName + "_left"))).put("facing=south,type=left", JState.model((String)("builtin:" + chestName + "_left")).y(180)).put("facing=west,type=left", JState.model((String)("builtin:" + chestName + "_left")).y(270)).put("facing=east,type=right", JState.model((String)("builtin:" + chestName + "_right")).y(90)).put("facing=north,type=right", JState.model((String)("builtin:" + chestName + "_right"))).put("facing=south,type=right", JState.model((String)("builtin:" + chestName + "_right")).y(180)).put("facing=west,type=right", JState.model((String)("builtin:" + chestName + "_right")).y(270))}), new ResourceLocation(chestName));
    }

    public static void addSingleChestOnlyBlockStates(String chestName, RuntimeResourcePack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("facing=east", JState.model((String)("builtin:" + chestName + "_center")).y(90)).put("facing=north", JState.model((String)("builtin:" + chestName + "_center"))).put("facing=south", JState.model((String)("builtin:" + chestName + "_center")).y(180)).put("facing=west", JState.model((String)("builtin:" + chestName + "_center")).y(270))}), new ResourceLocation(chestName));
    }

    public static void addSignModels(String texture, String signName, String wallSignName, RuntimeResourcePack pack) {
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_sign_0")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", texture), signName)), new ResourceLocation("block/" + signName + "_0"));
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_sign_22_5")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", texture), signName)), new ResourceLocation("block/" + signName + "_22_5"));
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_sign_45")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", texture), signName)), new ResourceLocation("block/" + signName + "_45"));
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_sign_67_5")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", texture), signName)), new ResourceLocation("block/" + signName + "_67_5"));
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_wall_sign")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", texture), signName)), new ResourceLocation("block/" + wallSignName));
    }

    private static String signAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.signAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addSignBlockStates(String signName, String wallSignName, RuntimeResourcePack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("rotation=0", JState.model((String)("block/" + signName + "_0")).y(180)).put("rotation=1", JState.model((String)("block/" + signName + "_67_5")).y(270)).put("rotation=2", JState.model((String)("block/" + signName + "_45")).y(270)).put("rotation=3", JState.model((String)("block/" + signName + "_22_5")).y(270)).put("rotation=4", JState.model((String)("block/" + signName + "_0")).y(270)).put("rotation=5", JState.model((String)("block/" + signName + "_67_5"))).put("rotation=6", JState.model((String)("block/" + signName + "_45"))).put("rotation=7", JState.model((String)("block/" + signName + "_22_5"))).put("rotation=8", JState.model((String)("block/" + signName + "_0"))).put("rotation=9", JState.model((String)("block/" + signName + "_67_5")).y(90)).put("rotation=10", JState.model((String)("block/" + signName + "_45")).y(90)).put("rotation=11", JState.model((String)("block/" + signName + "_22_5")).y(90)).put("rotation=12", JState.model((String)("block/" + signName + "_0")).y(90)).put("rotation=13", JState.model((String)("block/" + signName + "_67_5")).y(180)).put("rotation=14", JState.model((String)("block/" + signName + "_45")).y(180)).put("rotation=15", JState.model((String)("block/" + signName + "_22_5")).y(180))}), new ResourceLocation(signName));
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("facing=north", JState.model((String)("block/" + wallSignName))).put("facing=west", JState.model((String)("block/" + wallSignName)).y(270)).put("facing=south", JState.model((String)("block/" + wallSignName)).y(180)).put("facing=east", JState.model((String)("block/" + wallSignName)).y(90))}), new ResourceLocation(wallSignName));
    }

    public static void addBellBlockState(RuntimeResourcePack pack) {
        JVariant variant = JState.variant();
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            int rot = (int)dir.m_122435_() + 90;
            variant.put("attachment=double_wall,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_between_walls").y(rot)).put("attachment=ceiling,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_ceiling").y(rot + 90)).put("attachment=floor,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_floor").y(rot + 90)).put("attachment=single_wall,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_wall").y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation("bell"));
    }

    public static void addBedModels(DyeColor bedColor, RuntimeResourcePack pack) {
        String color = bedColor.m_41065_();
        pack.addModel(JModel.model().parent(ResourceUtil.bedAOSuffix("block/template_bed_head")).textures(ResourceUtil.withBedParticle(JModel.textures().var("bed", "entity/bed/" + color), color)), new ResourceLocation("block/" + color + "_bed_head"));
        pack.addModel(JModel.model().parent(ResourceUtil.bedAOSuffix("block/template_bed_foot")).textures(ResourceUtil.withBedParticle(JModel.textures().var("bed", "entity/bed/" + color), color)), new ResourceLocation("block/" + color + "_bed_foot"));
    }

    public static void addBedBlockState(DyeColor bedColor, RuntimeResourcePack pack) {
        String color = bedColor.m_41065_();
        JVariant variant = JState.variant();
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            int rot = (int)dir.m_122435_() + 180;
            variant.put("part=head,facing=" + dir.m_122433_(), JState.model((String)("block/" + bedColor + "_bed_head")).y(rot)).put("part=foot,facing=" + dir.m_122433_(), JState.model((String)("block/" + bedColor + "_bed_foot")).y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(color + "_bed"));
    }

    private static String bedAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.bedAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addShulkerBoxModels(@Nullable DyeColor color, RuntimeResourcePack pack) {
        String texture = color != null ? "entity/shulker/shulker_" + color.m_41065_() : "entity/shulker/shulker";
        String shulkerBoxStr = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
        String particle = "block/" + shulkerBoxStr;
        pack.addModel(JModel.model().parent("block/template_shulker_box").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr));
        pack.addModel(JModel.model().parent("block/template_shulker_box_bottom").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr + "_bottom"));
        pack.addModel(JModel.model().parent("block/template_shulker_box_lid").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr + "_lid"));
    }

    public static void addShulkerBoxBlockStates(@Nullable DyeColor color, RuntimeResourcePack pack) {
        String shulkerBoxStr = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
        JVariant variant = JState.variant().put("facing=up", JState.model((String)("builtin:" + shulkerBoxStr))).put("facing=down", JState.model((String)("builtin:" + shulkerBoxStr)).x(180));
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            int rot = (int)dir.m_122435_() + 180;
            variant.put("facing=" + dir.m_122433_(), JState.model((String)("builtin:" + shulkerBoxStr)).x(90).y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(shulkerBoxStr));
    }

    public static void resetPack() {
        PACK = RuntimeResourcePack.create((String)"ebe:pack");
    }

    public static void resetExperimentalPack() {
        EXPERIMENTAL_PACK = new ExperimentalResourcePack();
    }

    public static RuntimeResourcePack getPack() {
        return PACK;
    }

    public static ExperimentalResourcePack getExperimentalPack() {
        return EXPERIMENTAL_PACK;
    }

    private static /* synthetic */ ResourceUtil[] $values() {
        return new ResourceUtil[0];
    }

    static {
        $VALUES = ResourceUtil.$values();
        ResourceUtil.resetPack();
        ResourceUtil.resetExperimentalPack();
    }
}

