/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.api.world.level.block.DiagonalBlock;
import fuzs.diagonalfences.client.core.ClientAbstractions;
import fuzs.diagonalfences.client.model.QuadUtils;
import fuzs.diagonalfences.client.model.RotatedVariant;
import fuzs.diagonalfences.core.EightWayDirection;
import fuzs.diagonalfences.mixin.client.accessor.KeyValueConditionAccessor;
import fuzs.diagonalfences.mixin.client.accessor.ModelBakeryAccessor;
import fuzs.diagonalfences.mixin.client.accessor.SelectorAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.client.renderer.block.model.multipart.KeyValueCondition;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MultipartAppender {
    public static void onPrepareModelBaking(ModelBakery modelBakery) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Registry.f_122824_.m_123024_().filter(block -> {
            DiagonalBlock diagonalBlock;
            return block instanceof FenceBlock && block instanceof DiagonalBlock && (diagonalBlock = (DiagonalBlock)block).hasProperties();
        }).map(block -> (BlockState)block.m_49965_().m_61090_()).forEach(state -> {
            UnbakedModel patt2085$temp = modelBakery.m_119341_((ResourceLocation)BlockModelShaper.m_110895_((BlockState)state));
            if (patt2085$temp instanceof MultiPart) {
                MultiPart multiPart = (MultiPart)patt2085$temp;
                MultipartAppender.appendDiagonalSelectors(modelBakery, multiPart);
            } else {
                DiagonalFences.LOGGER.warn("Fence block '{}' is not using multipart models, diagonal fence connections will not be visible!", (Object)state.m_60734_());
            }
        });
        DiagonalFences.LOGGER.info("Constructing diagonal fence block models took {}ms", (Object)stopwatch.stop().elapsed().toMillis());
    }

    public static void appendDiagonalSelectors(ModelBakery modelBakery, MultiPart multiPart) {
        List selectors = multiPart.m_111967_();
        ArrayList newSelectors = Lists.newArrayList();
        for (Selector selector : selectors) {
            EightWayDirection direction;
            KeyValueCondition condition;
            Condition condition2 = ((SelectorAccessor)selector).diagonalfences$getCondition();
            if (!(condition2 instanceof KeyValueCondition) || !Objects.equals(((KeyValueConditionAccessor)(condition = (KeyValueCondition)condition2)).diagonalfences$getValue(), "true") || (direction = EightWayDirection.byName(((KeyValueConditionAccessor)condition).diagonalfences$getKey())) == null) continue;
            EightWayDirection interDirection = direction.rotateClockwise();
            KeyValueCondition newCondition = new KeyValueCondition(interDirection.m_7912_(), "true");
            List variants = selector.m_112020_().m_111848_();
            ArrayList newVariants = Lists.newArrayList();
            for (Variant variant : variants) {
                ModelResourceLocation location = new ModelResourceLocation(variant.m_111883_(), interDirection.m_7912_());
                ((ModelBakeryAccessor)modelBakery).diagonalfences$callCacheAndQueueDependencies((ResourceLocation)location, new RotatedVariant(variant, direction.toDirection()));
                newVariants.add(new Variant((ResourceLocation)location, variant.m_6189_(), variant.m_7538_(), variant.m_111886_()));
            }
            newSelectors.add(new Selector((Condition)newCondition, new MultiVariant((List)newVariants)));
        }
        selectors.addAll(newSelectors);
    }

    public static BakedModel rotateMultipartSegment(@Nullable BlockState state, BakedModel segmentModel, Direction armDir) {
        HashMap<Direction, List<BakedQuad>> quadMap = new HashMap<Direction, List<BakedQuad>>();
        MultipartAppender.rotateQuads(quadMap, state, segmentModel, null, armDir);
        for (Direction cullFace : Direction.values()) {
            MultipartAppender.rotateQuads(quadMap, state, segmentModel, cullFace, armDir);
        }
        return ClientAbstractions.INSTANCE.createWrappedBakedModel(segmentModel, quadMap);
    }

    private static void rotateQuads(Map<Direction, List<BakedQuad>> quadMap, @Nullable BlockState state, BakedModel segmentModel, Direction cullFace, Direction segmentDir) {
        List quads = segmentModel.m_213637_(state, cullFace, RandomSource.m_216327_());
        ArrayList newQuads = Lists.newArrayList();
        for (BakedQuad quad : quads) {
            BakedQuad copy = QuadUtils.duplicateQuad(quad);
            QuadUtils.rotateQuad(copy, segmentDir);
            newQuads.add(copy);
        }
        quadMap.put(cullFace, newQuads);
    }
}

