/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.mixin;

import fuzs.diagonalfences.core.EightWayDirection;
import fuzs.diagonalfences.init.ModRegistry;
import fuzs.diagonalfences.world.level.block.EightWayBlock;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public abstract class FenceBlockMixin
extends CrossCollisionBlock
implements EightWayBlock {
    private boolean hasProperties;
    private Object2IntMap<BlockState> statePaletteMap;

    public FenceBlockMixin(float nodeWidth, float extensionWidth, float nodeHeight, float extensionHeight, float collisionY, BlockBehaviour.Properties properties) {
        super(nodeWidth, extensionWidth, nodeHeight, extensionHeight, collisionY, properties);
    }

    protected VoxelShape[] m_52326_(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        if (this.hasProperties()) {
            return this.getShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
        }
        return super.m_52326_(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
    }

    protected int m_52363_(BlockState state) {
        if (this.hasProperties()) {
            if (this.statePaletteMap == null) {
                this.statePaletteMap = new Object2IntOpenHashMap();
            }
            return this.statePaletteMap.computeIfAbsent((Object)state, this::makeIndex);
        }
        return super.m_52363_(state);
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        if (this.supportsDiagonalConnections()) {
            this.updateIndirectNeighbourShapes2(state, world, pos, flags, recursionLeft);
        }
    }

    @Shadow
    public abstract boolean m_53329_(BlockState var1, boolean var2, Direction var3);

    @Shadow
    private boolean m_153254_(BlockState state) {
        throw new IllegalStateException();
    }

    @Override
    public boolean hasProperties() {
        return this.hasProperties;
    }

    @Override
    public boolean canConnect(BlockGetter blockGetter, BlockPos position, BlockState state, Direction direction) {
        return this.m_53329_(state, state.m_60783_(blockGetter, position, direction), direction);
    }

    @Override
    public boolean supportsDiagonalConnections() {
        return this.hasProperties() && !this.m_204297_().m_203656_(ModRegistry.NON_DIAGONAL_FENCES_TAG);
    }

    @Override
    public boolean canConnectToMe(BlockState neighborState, EightWayDirection neighborDirectionToMe) {
        if (neighborState.m_60734_() instanceof FenceBlock && ((EightWayBlock)neighborState.m_60734_()).supportsDiagonalConnections() && this.m_153254_(neighborState)) {
            if (neighborDirectionToMe == null) {
                return true;
            }
            for (EightWayDirection neighbor : neighborDirectionToMe.getCardinalNeighbors()) {
                if (!((Boolean)neighborState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)neighbor))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(BlockBehaviour.Properties properties, CallbackInfo callback) {
        if (this.hasProperties()) {
            this.m_49959_(this.addDefaultStates(this.m_49966_()));
        }
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="TAIL")})
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callback) {
        this.hasProperties = true;
        this.createBlockStateDefinition2(builder);
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    public void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callback) {
        if (this.supportsDiagonalConnections()) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
            BlockState placementState = super.m_5573_(context);
            placementState = this.makeStateForPlacement(placementState, (BlockGetter)level, pos, fluidState);
            callback.setReturnValue((Object)placementState);
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="TAIL")}, cancellable=true)
    public void updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> callback) {
        BlockState returnState;
        if (this.supportsDiagonalConnections() && (returnState = this.updateShape2(state, facing, facingState, level, currentPos, facingPos, (BlockState)callback.getReturnValue())) != null) {
            callback.setReturnValue((Object)returnState);
        }
    }
}

