/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.common;

import java.util.StringJoiner;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class OriacsServerConfig {
    public static final OriacsServerConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.BooleanValue STRICT_DIET;
    public final ForgeConfigSpec.IntValue DIVING_HELMET_TRANSFORM_TIME;
    public final ForgeConfigSpec.DoubleValue DIVING_HELMET_RESPIRATION_MULTIPLIER;
    public final ForgeConfigSpec.IntValue LANDWALKING_HELMET_TRANSFORM_TIME;
    public final ForgeConfigSpec.DoubleValue LANDWALKING_HELMET_RESPIRATION_MULTIPLIER;
    public final ForgeConfigSpec.IntValue UMBRELLA_MAX_DAMAGE;
    public final ForgeConfigSpec.BooleanValue UMBRELLA_CAN_KEEP_OUT_RAIN;
    public final ForgeConfigSpec.BooleanValue UMBRELLA_CAN_KEEP_OUT_SUNLIGHT;
    public final ForgeConfigSpec.IntValue UMBRELLA_MAX_KEEP_OUT_SUNLIGHT_COLOR;
    public final ForgeConfigSpec.DoubleValue UMBRELLA_SPAWN_WITH_ZOMBIE_CHANCE;

    public OriacsServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("diet");
        this.STRICT_DIET = builder.translation(OriacsServerConfig.translationKey("diet.strict_diet")).comment(new String[]{"If enabled: Carnivore may only eat meat, Vegetarian may only eat vegetables", "If disabled: Carnivore may eat anything besides vegetables, Vegetarian may eat anything besides meat", "Only vanilla foods are pre-defined, you could made mod foods compatible through tags", "It's recommended to leave this with the value of false if no compat has been made"}).define("strictDiet", false);
        builder.pop();
        builder.push("helmet");
        builder.push("diving");
        this.DIVING_HELMET_TRANSFORM_TIME = builder.translation(OriacsServerConfig.translationKey("helmet.diving.transform_time")).comment("How long in seconds for the Diving Helmet to transform into Landwalking Helmet in Water").defineInRange("transformTime", 600, 0, Integer.MAX_VALUE);
        this.DIVING_HELMET_RESPIRATION_MULTIPLIER = builder.translation(OriacsServerConfig.translationKey("helmet.diving.respiration_multiplier")).comment("How much will Respiration enchantment increase the transform time for Diving Helmet").defineInRange("respirationMultiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("landwalking");
        this.LANDWALKING_HELMET_TRANSFORM_TIME = builder.translation(OriacsServerConfig.translationKey("helmet.landwalking.transform_time")).comment("How long in seconds for the Landwalking Helmet to transform into Diving Helmet in Water").defineInRange("transformTime", 600, 0, Integer.MAX_VALUE);
        this.LANDWALKING_HELMET_RESPIRATION_MULTIPLIER = builder.translation(OriacsServerConfig.translationKey("helmet.landwalking.respiration_multiplier")).comment("How much will Respiration enchantment increase the transform time for Landwalking Helmet").defineInRange("respirationMultiplier", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("umbrella");
        this.UMBRELLA_MAX_DAMAGE = builder.translation(OriacsServerConfig.translationKey("umbrella.max_damage")).comment("Max damage of the Umbrella, aka. seconds available in rain").defineInRange("maxDamage", 600, 1, Integer.MAX_VALUE);
        this.UMBRELLA_CAN_KEEP_OUT_RAIN = builder.translation(OriacsServerConfig.translationKey("umbrella.can_keep_out_rain")).comment("If the Umbrella can be used to keep its holder from rain").define("canKeepOutRain", true);
        this.UMBRELLA_CAN_KEEP_OUT_SUNLIGHT = builder.translation(OriacsServerConfig.translationKey("umbrella.can_keep_out_sunlight")).comment("If the Umbrealla can be used to keep its holder from sunlight").define("canKeepOutSunlight", true);
        this.UMBRELLA_MAX_KEEP_OUT_SUNLIGHT_COLOR = builder.translation(OriacsServerConfig.translationKey("umbrella.max_keep_out_sunlight_color")).comment(new String[]{"The maximum R/G/B value of the Umbrella's color to keep out sunlight", "If set to 255, umbrella of all colors can keep out sunlight"}).defineInRange("maxKeepOutSunlightColor", 127, 0, 255);
        this.UMBRELLA_SPAWN_WITH_ZOMBIE_CHANCE = builder.translation(OriacsServerConfig.translationKey("umbrella.spawn_with_zombie_chance")).comment("The chance for a zombie is spawned with an umbrella in hard difficulty").defineInRange("spawnWithZombieChance", 0.05, 0.0, 1.0);
        builder.pop();
    }

    private static String translationKey(String field) {
        return new StringJoiner(".").add("config").add("oriacs").add("server").add(field).toString();
    }

    static {
        Pair entry = new ForgeConfigSpec.Builder().configure(OriacsServerConfig::new);
        CONFIG = (OriacsServerConfig)entry.getKey();
        SPEC = (ForgeConfigSpec)entry.getValue();
    }
}

