/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

@Mod(value="immediatelyfast")
public class ImmediatelyFast {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ImmediatelyFast");
    public static final Unsafe UNSAFE = ImmediatelyFast.getUnsafe();
    public static ImmediatelyFastConfig config;
    public static final String MOD_ID = "immediatelyfast";

    public ImmediatelyFast() {
        LOGGER.info("Loading ImmediatelyFast");
        if (ModList.get().isLoaded("oculus")) {
            LOGGER.info("Found Oculus. Enabling compatibility.");
            IrisCompat.init();
        }
    }

    public static void loadConfig() {
        File configFile = FMLPaths.CONFIGDIR.get().resolve("immediatelyfast.json").toFile();
        if (configFile.exists()) {
            try {
                config = (ImmediatelyFastConfig)new Gson().fromJson((Reader)new FileReader(configFile), ImmediatelyFastConfig.class);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load ImmediatelyFast config. Resetting it.", e);
            }
        }
        if (config == null) {
            config = new ImmediatelyFastConfig();
        }
        try {
            Files.writeString(configFile.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)config), new OpenOption[0]);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save ImmediatelyFast config.", e);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (!field.getType().equals(Unsafe.class)) continue;
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Unable to get Unsafe instance");
    }
}

