/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.batching.ItemModelBatchableImmediate;
import net.raphimc.immediatelyfast.feature.core.BatchableImmediate;

public class BatchingBuffers {
    public static MultiBufferSource FILL_CONSUMER = null;
    public static MultiBufferSource TEXTURE_CONSUMER = null;
    public static MultiBufferSource TEXT_CONSUMER = null;
    public static MultiBufferSource LIT_ITEM_MODEL_CONSUMER = null;
    public static MultiBufferSource UNLIT_ITEM_MODEL_CONSUMER = null;
    public static MultiBufferSource ITEM_OVERLAY_CONSUMER = null;
    private static final BatchableImmediate FILL_BATCH = new BatchableImmediate();
    private static final BatchableImmediate TEXTURE_BATCH = new BatchableImmediate();
    private static final BatchableImmediate TEXT_BATCH = new BatchableImmediate();
    private static final BatchableImmediate LIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(true);
    private static final BatchableImmediate UNLIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(false);
    private static final BatchableImmediate ITEM_OVERLAY_BATCH = new BatchableImmediate();

    public static void beginHudBatching() {
        BatchingBuffers.beginFillBatching();
        BatchingBuffers.beginTextureBatching();
        BatchingBuffers.beginTextBatching();
    }

    public static void endHudBatching() {
        BatchingBuffers.endFillBatching();
        BatchingBuffers.endTextureBatching();
        BatchingBuffers.endTextBatching();
    }

    public static void beginItemBatching() {
        BatchingBuffers.beginItemModelBatching();
        BatchingBuffers.beginItemOverlayBatching();
    }

    public static void endItemBatching() {
        BatchingBuffers.endItemModelBatching();
        BatchingBuffers.endItemOverlayBatching();
    }

    public static void beginTextureBatching() {
        if (TEXTURE_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Texture batching was already active! endTextureBatching() was not called before beginTextureBatching(). This will cause rendering issues.");
            TEXTURE_BATCH.close();
        }
        TEXTURE_CONSUMER = TEXTURE_BATCH;
    }

    public static void endTextureBatching() {
        TEXTURE_CONSUMER = null;
        TEXTURE_BATCH.m_109911_();
    }

    public static boolean isTextureBatching() {
        return TEXTURE_CONSUMER != null;
    }

    public static void beginFillBatching() {
        if (FILL_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Fill batching was already active! endFillBatching() was not called before beginFillBatching(). This will cause rendering issues.");
            FILL_BATCH.close();
        }
        FILL_CONSUMER = FILL_BATCH;
    }

    public static void endFillBatching() {
        FILL_CONSUMER = null;
        FILL_BATCH.m_109911_();
    }

    public static boolean isFillBatching() {
        return FILL_CONSUMER != null;
    }

    public static void beginTextBatching() {
        if (TEXT_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Text batching was already active! endTextBatching() was not called before beginTextBatching(). This will cause rendering issues.");
            TEXT_BATCH.close();
        }
        TEXT_CONSUMER = TEXT_BATCH;
    }

    public static void endTextBatching() {
        TEXT_CONSUMER = null;
        TEXT_BATCH.m_109911_();
    }

    public static boolean isTextBatching() {
        return TEXT_CONSUMER != null;
    }

    public static void beginItemModelBatching() {
        if (LIT_ITEM_MODEL_BATCH.hasActiveLayers() || UNLIT_ITEM_MODEL_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item model batching was already active! endItemModelBatching() was not called before beginItemModelBatching(). This will cause rendering issues.");
            LIT_ITEM_MODEL_BATCH.close();
            UNLIT_ITEM_MODEL_BATCH.close();
        }
        LIT_ITEM_MODEL_CONSUMER = LIT_ITEM_MODEL_BATCH;
        UNLIT_ITEM_MODEL_CONSUMER = UNLIT_ITEM_MODEL_BATCH;
    }

    public static void endItemModelBatching() {
        LIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_BATCH.m_109911_();
        LIT_ITEM_MODEL_BATCH.m_109911_();
    }

    public static boolean isItemModelBatching() {
        return LIT_ITEM_MODEL_CONSUMER != null || UNLIT_ITEM_MODEL_CONSUMER != null;
    }

    public static void beginItemOverlayBatching() {
        if (ITEM_OVERLAY_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item overlay batching was already active! endItemOverlayBatching() was not called before beginItemOverlayBatching(). This will cause rendering issues.");
            ITEM_OVERLAY_BATCH.close();
        }
        ITEM_OVERLAY_CONSUMER = ITEM_OVERLAY_BATCH;
    }

    public static void endItemOverlayBatching() {
        ITEM_OVERLAY_CONSUMER = null;
        ITEM_OVERLAY_BATCH.m_109911_();
    }

    public static boolean isItemOverlayBatching() {
        return ITEM_OVERLAY_CONSUMER != null;
    }

    public static Map<RenderType, BufferBuilder> createLayerBuffers(RenderType ... layers) {
        Object2ObjectLinkedOpenHashMap layerBuffers = new Object2ObjectLinkedOpenHashMap(layers.length);
        for (RenderType layer : layers) {
            layerBuffers.put((Object)layer, (Object)new BufferBuilder(layer.m_110507_()));
        }
        return layerBuffers;
    }
}

