/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.map_atlas_generation;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.map_atlas_generation.MapAtlasTexture;
import net.raphimc.immediatelyfast.injection.interfaces.IMapRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapRenderer.MapInstance.class}, priority=1100)
public abstract class MixinMapRenderer_MapTexture {
    @Shadow
    private MapItemSavedData f_93280_;
    @Mutable
    @Shadow
    @Final
    private DynamicTexture f_93281_;
    @Mutable
    @Shadow
    @Final
    private RenderType f_93282_;
    @Unique
    private static final DynamicTexture DUMMY_TEXTURE;
    @Unique
    private int atlasX;
    @Unique
    private int atlasY;
    @Unique
    private MapAtlasTexture atlasTexture;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAtlasParameters(MapRenderer this$0, int p_168783_, MapItemSavedData p_168784_, CallbackInfo ci) {
        int packedLocation = ((IMapRenderer)this$0).getAtlasMapping(p_168783_);
        if (packedLocation == -1) {
            this.f_93281_ = new DynamicTexture(128, 128, true);
            ResourceLocation resourcelocation = ((IMapRenderer)this$0).getTextureManager().m_118490_("map/" + p_168783_, this.f_93281_);
            this.f_93282_ = RenderType.m_110497_((ResourceLocation)resourcelocation);
            ImmediatelyFast.LOGGER.warn("Map " + p_168783_ + " is not in an atlas");
            return;
        }
        this.atlasX = (packedLocation >> 8 & 0xFF) * 128;
        this.atlasY = (packedLocation & 0xFF) * 128;
        this.atlasTexture = ((IMapRenderer)this$0).getMapAtlasTexture(packedLocation >> 16);
        this.f_93281_ = null;
        ResourceLocation resourcelocation = this.atlasTexture.getIdentifier();
        this.f_93282_ = RenderType.m_110497_((ResourceLocation)resourcelocation);
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="net/minecraft/client/renderer/texture/DynamicTexture"))
    private DynamicTexture dontAllocateTexture(int width, int height, boolean useMipmaps) {
        return DUMMY_TEXTURE;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureManager;register(Ljava/lang/String;Lnet/minecraft/client/renderer/texture/DynamicTexture;)Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation getAtlasTextureIdentifier(TextureManager textureManager, String id, DynamicTexture texture) {
        return null;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;text(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"))
    private RenderType getAtlasTextureIdentifier(ResourceLocation p_110498_) {
        return null;
    }

    @Inject(method={"updateTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateAtlasTexture(CallbackInfo ci) {
        if (this.atlasTexture != null) {
            ci.cancel();
            DynamicTexture atlasTexture = this.atlasTexture.getTexture();
            NativeImage atlasImage = atlasTexture.m_117991_();
            if (atlasImage == null) {
                throw new IllegalStateException("Atlas texture has already been closed");
            }
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int i = x + y * 128;
                    atlasImage.m_84988_(this.atlasX + x, this.atlasY + y, MaterialColor.m_192923_((int)this.f_93280_.f_77891_[i]));
                }
            }
            atlasTexture.m_117966_();
            atlasImage.m_85003_(0, this.atlasX, this.atlasY, this.atlasX, this.atlasY, 128, 128, false, false);
        }
    }

    @Redirect(method={"draw"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;uv(FF)Lcom/mojang/blaze3d/vertex/VertexConsumer;"), slice=@Slice(from=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;vertex(Lcom/mojang/math/Matrix4f;FFF)Lcom/mojang/blaze3d/vertex/VertexConsumer;", ordinal=0), to=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;endVertex()V", ordinal=3)))
    private VertexConsumer drawAtlasTexture(VertexConsumer instance, float u, float v) {
        if (this.atlasTexture != null) {
            if (u == 0.0f && v == 1.0f) {
                u = (float)this.atlasX / 4096.0f;
                v = (float)(this.atlasY + 128) / 4096.0f;
            } else if (u == 1.0f && v == 1.0f) {
                u = (float)(this.atlasX + 128) / 4096.0f;
                v = (float)(this.atlasY + 128) / 4096.0f;
            } else if (u == 1.0f && v == 0.0f) {
                u = (float)(this.atlasX + 128) / 4096.0f;
                v = (float)this.atlasY / 4096.0f;
            } else if (u == 0.0f && v == 0.0f) {
                u = (float)this.atlasX / 4096.0f;
                v = (float)this.atlasY / 4096.0f;
            }
        }
        return instance.m_7421_(u, v);
    }

    @Inject(method={"close"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontCloseDummyTexture(CallbackInfo ci) {
        if (this.atlasTexture != null) {
            ci.cancel();
        }
    }

    static {
        try {
            DUMMY_TEXTURE = (DynamicTexture)ImmediatelyFast.UNSAFE.allocateInstance(DynamicTexture.class);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

