/*
 * Decompiled with CFR 0.152.
 */
package wearblackallday.dimthread;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fml.common.Mod;
import wearblackallday.dimthread.init.ModGameRules;
import wearblackallday.dimthread.thread.IMutableMainThread;
import wearblackallday.dimthread.util.ServerManager;
import wearblackallday.util.ThreadPool;

@Mod(value="dimthread")
public class DimThread {
    public static final String MOD_ID = "dimthread";
    public static final ServerManager MANAGER = new ServerManager();

    public DimThread() {
        ModGameRules.registerGameRules();
    }

    public static ThreadPool getThreadPool(MinecraftServer server) {
        return MANAGER.getThreadPool(server);
    }

    public static synchronized void swapThreadsAndRun(Runnable task, Object ... threadedObjects) {
        int i;
        Thread currentThread = Thread.currentThread();
        Thread[] oldThreads = new Thread[threadedObjects.length];
        for (i = 0; i < oldThreads.length; ++i) {
            oldThreads[i] = ((IMutableMainThread)threadedObjects[i]).getMainThread();
            ((IMutableMainThread)threadedObjects[i]).setMainThread(currentThread);
        }
        task.run();
        for (i = 0; i < oldThreads.length; ++i) {
            ((IMutableMainThread)threadedObjects[i]).setMainThread(oldThreads[i]);
        }
    }

    public static void attach(Thread thread, String name) {
        thread.setName("dimthread_" + name);
    }

    public static void attach(Thread thread, ServerLevel world) {
        DimThread.attach(thread, world.m_46472_().m_135782_().m_135815_());
    }

    public static boolean owns(Thread thread) {
        return thread.getName().startsWith(MOD_ID);
    }
}

