/*
 * Decompiled with CFR 0.152.
 */
package wearblackallday.dimthread.mixin;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wearblackallday.dimthread.DimThread;
import wearblackallday.dimthread.util.CrashInfo;
import wearblackallday.util.ThreadPool;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    private int f_129766_;
    @Shadow
    private PlayerList f_129763_;

    @Shadow
    public abstract Iterable<ServerLevel> m_129785_();

    @Shadow(remap=false)
    protected abstract ServerLevel[] getWorldArray();

    @Redirect(method={"tickChildren"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorldArray()[Lnet/minecraft/server/level/ServerLevel;"))
    public ServerLevel[] tickWorlds(MinecraftServer instance) {
        return DimThread.MANAGER.isActive((MinecraftServer)this) ? new ServerLevel[]{} : this.getWorldArray();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorldArray()[Lnet/minecraft/server/level/ServerLevel;")})
    public void tickWorlds(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (!DimThread.MANAGER.isActive((MinecraftServer)this)) {
            return;
        }
        AtomicReference crash = new AtomicReference();
        ThreadPool pool = DimThread.getThreadPool((MinecraftServer)this);
        pool.execute(this.m_129785_().iterator(), serverWorld -> {
            DimThread.attach(Thread.currentThread(), serverWorld);
            if (this.f_129766_ % 20 == 0) {
                ClientboundSetTimePacket timeUpdatePacket = new ClientboundSetTimePacket(serverWorld.m_46467_(), serverWorld.m_46468_(), serverWorld.m_46469_().m_46207_(GameRules.f_46140_));
                this.f_129763_.m_11270_((Packet)timeUpdatePacket, serverWorld.m_46472_());
            }
            DimThread.swapThreadsAndRun(() -> {
                ForgeEventFactory.onPreLevelTick((Level)serverWorld, (BooleanSupplier)shouldKeepTicking);
                try {
                    serverWorld.m_8793_(shouldKeepTicking);
                }
                catch (Throwable throwable) {
                    crash.set(new CrashInfo((ServerLevel)serverWorld, throwable));
                }
                ForgeEventFactory.onPostLevelTick((Level)serverWorld, (BooleanSupplier)shouldKeepTicking);
            }, serverWorld, serverWorld.m_7726_());
        });
        pool.awaitCompletion();
        if (crash.get() != null) {
            ((CrashInfo)crash.get()).crash("Exception ticking world");
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    public void shutdownThreadpool(CallbackInfo ci) {
        DimThread.MANAGER.threadPools.forEach((server, pool) -> pool.shutdown());
    }
}

