/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.function;

import java.util.Arrays;
import java.util.stream.Collectors;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;

public interface TypedFunction {
    public Type getReturnType();

    public Parameter[] getParameters();

    public void evaluateTo(Expression[] var1, FunctionContext var2, FunctionReturn var3);

    default public boolean isPure() {
        return true;
    }

    default public int priority() {
        return 0;
    }

    public static String format(TypedFunction typedFunction, String string) {
        return String.format("%s %s(%s) (priority: %d, pure:%s)", typedFunction.getReturnType().toString(), string, Arrays.stream(typedFunction.getParameters()).map(parameter -> parameter.constant() ? "const " + parameter.type() : parameter.type().toString()).collect(Collectors.joining(", ")), typedFunction.priority(), typedFunction.isPure() ? "yes" : "no");
    }

    public static class Parameter {
        private final Type type;
        private final boolean isConstant;

        public Parameter(Type type, boolean bl) {
            this.type = type;
            this.isConstant = bl;
        }

        public Parameter(Type type) {
            this(type, false);
        }

        public Type type() {
            return this.type;
        }

        public boolean constant() {
            return this.isConstant;
        }
    }
}

