/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.parameter;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class SodiumParameters
extends Parameters {
    public final ShaderAttributeInputs inputs;
    public final float positionScale;
    public final float positionOffset;
    public final float textureScale;
    public AlphaTest alpha;

    public SodiumParameters(Patch patch, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap, AlphaTest alphaTest, ShaderAttributeInputs shaderAttributeInputs, float f, float f2, float f3) {
        super(patch, object2ObjectMap);
        this.inputs = shaderAttributeInputs;
        this.positionScale = f;
        this.positionOffset = f2;
        this.textureScale = f3;
        this.alpha = alphaTest;
    }

    @Override
    public AlphaTest getAlphaTest() {
        return this.alpha;
    }

    @Override
    public TextureStage getTextureStage() {
        return TextureStage.GBUFFERS_AND_SHADOW;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.inputs == null ? 0 : this.inputs.hashCode());
        n = 31 * n + Float.floatToIntBits(this.positionScale);
        n = 31 * n + Float.floatToIntBits(this.positionOffset);
        n = 31 * n + Float.floatToIntBits(this.textureScale);
        n = 31 * n + (this.alpha == null ? 0 : this.alpha.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SodiumParameters sodiumParameters = (SodiumParameters)object;
        if (this.inputs == null ? sodiumParameters.inputs != null : !this.inputs.equals(sodiumParameters.inputs)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionScale) != Float.floatToIntBits(sodiumParameters.positionScale)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionOffset) != Float.floatToIntBits(sodiumParameters.positionOffset)) {
            return false;
        }
        if (Float.floatToIntBits(this.textureScale) != Float.floatToIntBits(sodiumParameters.textureScale)) {
            return false;
        }
        return !(this.alpha == null ? sodiumParameters.alpha != null : !this.alpha.equals(sodiumParameters.alpha));
    }
}

