/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.classpath;

import java.nio.file.Path;
import java.util.List;
import me.jellysquid.mods.sodium.client.util.workarounds.classpath.LibraryClasspaths;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModOrigin;

public class ModClasspaths {
    public static List<Path> getClasspathEntriesForMod(Class<?> clazz, String modId) {
        if (ModClasspaths.shouldUseModContainerApi()) {
            return ModClasspaths.queryModContainerForFilePaths(modId);
        }
        return List.of(LibraryClasspaths.getClasspathEntry(clazz));
    }

    private static List<Path> queryModContainerForFilePaths(String modId) {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new NullPointerException("Could not find container for mod '%s'".formatted(modId)));
        ModOrigin origin = mod.getOrigin();
        if (origin.getKind() != ModOrigin.Kind.PATH) {
            throw new RuntimeException("Mod '%s' comes from unexpected origin kind: %s".formatted(modId, origin.getKind()));
        }
        List paths = origin.getPaths();
        if (paths.isEmpty()) {
            throw new RuntimeException("Couldn't find any paths providing mod '%s'".formatted(modId));
        }
        return paths;
    }

    private static boolean shouldUseModContainerApi() {
        return FabricLoader.getInstance().getModContainer("quilt_loader").map(container -> {
            Version version = container.getMetadata().getVersion();
            try {
                if (version.compareTo((Object)Version.parse((String)"0.18.0")) < 0) {
                    return false;
                }
            }
            catch (VersionParsingException versionParsingException) {
                // empty catch block
            }
            return true;
        }).orElse(true);
    }
}

