/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.formats.screen_quad.BasicScreenQuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp.ExtendedBasicScreenQuadVertexType;
import net.coderbot.iris.compat.sodium.impl.vertex_format.clouds_xhfp.QuadViewClouds;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class CloudsVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements BasicScreenQuadVertexSink {
    private static final int STRIDE = IrisVertexFormats.CLOUDS.method_1362();
    private final QuadViewClouds.QuadViewCloudsUnsafe quad = new QuadViewClouds.QuadViewCloudsUnsafe();
    private final Vector3f saveNormal = new Vector3f();
    private int vertexCount;

    public CloudsVertexBufferWriterUnsafe(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)ExtendedBasicScreenQuadVertexType.INSTANCE);
    }

    public void writeQuad(float f, float f2, float f3, int n) {
        long l = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutFloat((long)l, (float)f);
        MemoryUtil.memPutFloat((long)(l + 4L), (float)f2);
        MemoryUtil.memPutFloat((long)(l + 8L), (float)f3);
        MemoryUtil.memPutInt((long)(l + 12L), (int)n);
        if (this.vertexCount == 4) {
            this.endQuad();
        }
        this.advance();
    }

    private void endQuad() {
        this.vertexCount = 0;
        long l = this.writePointer;
        this.quad.setup(this.writePointer, STRIDE);
        NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
        int n = NormalHelper.packNormal(this.saveNormal, 0.0f);
        for (long i = 0L; i < 4L; ++i) {
            MemoryUtil.memPutInt((long)(l + 16L - (long)STRIDE * i), (int)n);
        }
    }
}

