/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.coderbot.batchedentityrendering.impl.BatchingDebugMessageHelper;
import net.coderbot.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.RenderBuffersExt;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowMatrices;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.FrustumHolder;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ShadowRenderer {
    public static boolean ACTIVE = false;
    public static List<class_2586> visibleBlockEntities;
    private final float halfPlaneLength;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    public static Matrix4f MODELVIEW;
    private final ShadowRenderTargets targets;
    private final OptionalBoolean packCullingState;
    private final ShadowCompositeRenderer compositeRenderer;
    private boolean packHasVoxelization;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final float sunPathRotation;
    private final class_4599 buffers;
    private final RenderBuffersExt renderBuffersExt;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowBlockEntities = 0;
    private final CustomUniforms customUniforms;

    public ShadowRenderer(ProgramSource programSource, PackDirectives packDirectives, ShadowRenderTargets shadowRenderTargets, ShadowCompositeRenderer shadowCompositeRenderer, CustomUniforms customUniforms) {
        this.customUniforms = customUniforms;
        PackShadowDirectives packShadowDirectives = packDirectives.getShadowDirectives();
        this.halfPlaneLength = packShadowDirectives.getDistance();
        this.renderDistanceMultiplier = packShadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = packShadowDirectives.getEntityShadowDistanceMul();
        this.resolution = packShadowDirectives.getResolution();
        this.intervalSize = packShadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = packShadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = packShadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = packShadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = packShadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = packShadowDirectives.shouldRenderBlockEntities();
        this.compositeRenderer = shadowCompositeRenderer;
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = packShadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (programSource != null) {
            this.packHasVoxelization = programSource.getGeometrySource().isPresent();
            this.packCullingState = packShadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = OptionalBoolean.DEFAULT;
        }
        this.sunPathRotation = packDirectives.getSunPathRotation();
        this.buffers = new class_4599();
        this.renderBuffersExt = this.buffers instanceof RenderBuffersExt ? (RenderBuffersExt)this.buffers : null;
        this.configureSamplingSettings(packShadowDirectives);
    }

    public void setUsesImages(boolean bl) {
        this.packHasVoxelization = this.packHasVoxelization || bl;
    }

    public static class_4587 createShadowModelView(float f, float f2) {
        Vector3d vector3d = CameraUniforms.getUnshiftedCameraPosition();
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        class_4587 class_45872 = new class_4587();
        ShadowMatrices.createModelViewMatrix(class_45872, ShadowRenderer.getShadowAngle(), f2, f, d, d2, d3);
        return class_45872;
    }

    private static class_638 getLevel() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    private static float getSkyAngle() {
        return ShadowRenderer.getLevel().method_30274(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float f = ShadowRenderer.getSkyAngle();
        if (f < 0.75f) {
            return f + 0.25f;
        }
        return f - 0.75f;
    }

    private static float getShadowAngle() {
        float f = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            f -= 0.5f;
        }
        return f;
    }

    private void configureSamplingSettings(PackShadowDirectives packShadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> immutableList = packShadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> immutableList2 = packShadowDirectives.getColorSamplingSettings();
        RenderSystem.activeTexture((int)33988);
        this.configureDepthSampler(this.targets.getDepthTexture().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)immutableList.get(0));
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)immutableList.get(1));
        for (int i = 0; i < immutableList2.size(); ++i) {
            int n = this.targets.get(i).getMainTexture();
            this.configureSampler(n, (PackShadowDirectives.SamplingSettings)immutableList2.get(i));
        }
        RenderSystem.activeTexture((int)33984);
    }

    private void configureDepthSampler(int n, PackShadowDirectives.DepthSamplingSettings depthSamplingSettings) {
        if (depthSamplingSettings.getHardwareFiltering()) {
            IrisRenderSystem.texParameteri(n, 3553, 34892, 34894);
        }
        IrisRenderSystem.texParameteriv(n, 3553, 36422, new int[]{6403, 6403, 6403, 1});
        this.configureSampler(n, depthSamplingSettings);
    }

    private void configureSampler(int n, PackShadowDirectives.SamplingSettings samplingSettings) {
        if (samplingSettings.getMipmap()) {
            int n2 = samplingSettings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(n, n2));
        }
        if (!samplingSettings.getNearest()) {
            IrisRenderSystem.texParameteri(n, 3553, 10241, 9729);
            IrisRenderSystem.texParameteri(n, 3553, 10240, 9729);
        } else {
            IrisRenderSystem.texParameteri(n, 3553, 10241, 9728);
            IrisRenderSystem.texParameteri(n, 3553, 10240, 9728);
        }
    }

    private void generateMipmaps() {
        RenderSystem.activeTexture((int)33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            this.setupMipmappingForTexture(mipmapPass.getTexture(), mipmapPass.getTargetFilteringMode());
        }
        RenderSystem.activeTexture((int)33984);
    }

    private void setupMipmappingForTexture(int n, int n2) {
        IrisRenderSystem.generateMipmaps(n, 3553);
        IrisRenderSystem.texParameteri(n, 3553, 10241, n2);
    }

    private FrustumHolder createShadowFrustum(float f, FrustumHolder frustumHolder) {
        String string;
        double d;
        if ((this.packCullingState == OptionalBoolean.FALSE || this.packHasVoxelization) && this.packCullingState != OptionalBoolean.TRUE) {
            d = this.halfPlaneLength * f;
            string = this.packCullingState == OptionalBoolean.FALSE ? "(set by shader pack)" : "(voxelization detected)";
            if (d <= 0.0 || d > (double)(class_310.method_1551().field_1690.method_38521() * 16)) {
                String string2 = "render distance = " + class_310.method_1551().field_1690.method_38521() * 16 + " blocks ";
                string2 = string2 + (class_310.method_1551().method_1542() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                String string3 = "disabled " + string;
                return frustumHolder.setInfo(new NonCullingFrustum(), string2, string3);
            }
        } else {
            String string4;
            BoxCuller boxCuller;
            String string5;
            double d2 = this.halfPlaneLength * f;
            String string6 = "(set by shader pack)";
            if (f < 0.0f) {
                d2 = IrisVideoSettings.shadowDistance * 16;
                string6 = "(set by user)";
            }
            if (d2 >= (double)(class_310.method_1551().field_1690.method_38521() * 16)) {
                string5 = "render distance = " + class_310.method_1551().field_1690.method_38521() * 16 + " blocks ";
                string5 = (String)string5 + (class_310.method_1551().method_1542() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                boxCuller = null;
            } else {
                string5 = d2 + " blocks " + string6;
                if (d2 == 0.0) {
                    string4 = "no shadows rendered";
                    frustumHolder.setInfo(new CullEverythingFrustum(), string5, string4);
                }
                boxCuller = new BoxCuller(d2);
            }
            string4 = "Advanced Frustum Culling enabled";
            Vector4f vector4f = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
            Vector3f vector3f = new Vector3f(vector4f.x(), vector4f.y(), vector4f.z());
            vector3f.normalize();
            return frustumHolder.setInfo(new AdvancedShadowCullingFrustum(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), vector3f, boxCuller), string5, string4);
        }
        String string7 = d + " blocks (set by shader pack)";
        String string8 = "distance only " + string;
        BoxCuller boxCuller = new BoxCuller(d);
        frustumHolder.setInfo(new BoxCullingFrustum(boxCuller), string7, string8);
        return frustumHolder;
    }

    public void setupShadowViewport() {
        RenderSystem.viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
    }

    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        class_310 class_3102 = class_310.method_1551();
        levelRendererAccessor.getLevel().method_16107().method_15405("shadows");
        ACTIVE = true;
        visibleBlockEntities = new ArrayList<class_2586>();
        class_4599 class_45992 = levelRendererAccessor.getRenderBuffers();
        levelRendererAccessor.setRenderBuffers(this.buffers);
        visibleBlockEntities = new ArrayList<class_2586>();
        class_4587 class_45872 = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize);
        MODELVIEW = new Matrix4f((Matrix4fc)class_45872.method_23760().method_23761());
        levelRendererAccessor.getLevel().method_16107().method_15396("terrain_setup");
        if (levelRendererAccessor instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRendererAccessor)).saveState();
        }
        levelRendererAccessor.getLevel().method_16107().method_15396("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        Vector3d vector3d = CameraUniforms.getUnshiftedCameraPosition();
        double d = vector3d.x();
        double d2 = vector3d.y();
        double d3 = vector3d.z();
        this.terrainFrustumHolder.getFrustum().method_23088(d, d2, d3);
        levelRendererAccessor.getLevel().method_16107().method_15407();
        boolean bl = class_3102.field_1730;
        class_3102.field_1730 = false;
        boolean bl2 = levelRendererAccessor.shouldRegenerateClouds();
        ((class_761)levelRendererAccessor).method_3292();
        levelRendererAccessor.setShouldRegenerateClouds(bl2);
        levelRendererAccessor.invokeSetupRender(class_41842, this.terrainFrustumHolder.getFrustum(), false, false);
        class_3102.field_1730 = bl;
        levelRendererAccessor.getLevel().method_16107().method_15405("terrain");
        this.setupShadowViewport();
        Matrix4f matrix4f = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        IrisRenderSystem.setShadowProjection(matrix4f);
        RenderSystem.disableCull();
        if (this.shouldRenderTerrain) {
            levelRendererAccessor.invokeRenderChunkLayer(class_1921.method_23577(), class_45872, d, d2, d3, matrix4f);
            levelRendererAccessor.invokeRenderChunkLayer(class_1921.method_23581(), class_45872, d, d2, d3, matrix4f);
            levelRendererAccessor.invokeRenderChunkLayer(class_1921.method_23579(), class_45872, d, d2, d3, matrix4f);
        }
        RenderSystem.viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
        levelRendererAccessor.getLevel().method_16107().method_15405("entities");
        float f = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean bl3 = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            bl3 = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        class_4604 class_46042 = this.entityFrustumHolder.getFrustum();
        class_46042.method_23088(d, d2, d3);
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.beginLevelRendering();
        }
        if (this.buffers instanceof DrawCallTrackingRenderBuffers) {
            ((DrawCallTrackingRenderBuffers)this.buffers).resetDrawCounts();
        }
        class_4597.class_4598 class_45982 = this.buffers.method_23000();
        class_898 class_8982 = levelRendererAccessor.getEntityRenderDispatcher();
        if (this.shouldRenderEntities) {
            this.renderedShadowEntities = this.renderEntities(levelRendererAccessor, class_8982, class_45982, class_45872, f, class_46042, d, d2, d3);
        } else if (this.shouldRenderPlayer) {
            this.renderedShadowEntities = this.renderPlayerEntity(levelRendererAccessor, class_8982, class_45982, class_45872, f, class_46042, d, d2, d3);
        }
        levelRendererAccessor.getLevel().method_16107().method_15405("build blockentities");
        if (this.shouldRenderBlockEntities) {
            this.renderedShadowBlockEntities = this.renderBlockEntities(class_45982, class_45872, d, d2, d3, f, bl3);
        }
        levelRendererAccessor.getLevel().method_16107().method_15405("draw entities");
        class_45982.method_22993();
        this.copyPreTranslucentDepth(levelRendererAccessor);
        levelRendererAccessor.getLevel().method_16107().method_15405("translucent terrain");
        if (this.shouldRenderTranslucent) {
            levelRendererAccessor.invokeRenderChunkLayer(class_1921.method_23583(), class_45872, d, d2, d3, matrix4f);
        }
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.endLevelRendering();
        }
        IrisRenderSystem.restorePlayerProjection();
        this.debugStringTerrain = ((class_761)levelRendererAccessor).method_3289();
        levelRendererAccessor.getLevel().method_16107().method_15405("generate mipmaps");
        this.generateMipmaps();
        levelRendererAccessor.getLevel().method_16107().method_15405("restore gl state");
        RenderSystem.enableCull();
        class_310.method_1551().method_1522().method_1235(false);
        RenderSystem.viewport((int)0, (int)0, (int)class_3102.method_1522().field_1482, (int)class_3102.method_1522().field_1481);
        if (levelRendererAccessor instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRendererAccessor)).restoreState();
        }
        this.compositeRenderer.renderAll();
        levelRendererAccessor.setRenderBuffers(class_45992);
        visibleBlockEntities = null;
        ACTIVE = false;
        levelRendererAccessor.getLevel().method_16107().method_15407();
        levelRendererAccessor.getLevel().method_16107().method_15405("updatechunks");
    }

    private int renderBlockEntities(class_4597.class_4598 class_45982, class_4587 class_45872, double d, double d2, double d3, float f, boolean bl) {
        ShadowRenderer.getLevel().method_16107().method_15396("build blockentities");
        int n = 0;
        BoxCuller boxCuller = null;
        if (bl) {
            boxCuller = new BoxCuller(this.halfPlaneLength * (this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier));
            boxCuller.setPosition(d, d2, d3);
        }
        for (class_2586 class_25862 : visibleBlockEntities) {
            class_2338 class_23382 = class_25862.method_11016();
            if (bl && boxCuller.isCulled(class_23382.method_10263() - 1, class_23382.method_10264() - 1, class_23382.method_10260() - 1, class_23382.method_10263() + 1, class_23382.method_10264() + 1, class_23382.method_10260() + 1)) continue;
            class_45872.method_22903();
            class_45872.method_22904((double)class_23382.method_10263() - d, (double)class_23382.method_10264() - d2, (double)class_23382.method_10260() - d3);
            class_310.method_1551().method_31975().method_3555(class_25862, f, class_45872, (class_4597)class_45982);
            class_45872.method_22909();
            ++n;
        }
        ShadowRenderer.getLevel().method_16107().method_15407();
        return n;
    }

    private int renderEntities(LevelRendererAccessor levelRendererAccessor, class_898 class_8982, class_4597.class_4598 class_45982, class_4587 class_45872, float f, class_4604 class_46042, double d, double d2, double d3) {
        levelRendererAccessor.getLevel().method_16107().method_15396("cull");
        ArrayList<class_1297> arrayList = new ArrayList<class_1297>(32);
        for (class_1297 class_12973 : ShadowRenderer.getLevel().method_18112()) {
            if (!class_8982.method_3950(class_12973, class_46042, d, d2, d3) || class_12973.method_7325()) continue;
            arrayList.add(class_12973);
        }
        levelRendererAccessor.getLevel().method_16107().method_15405("sort");
        arrayList.sort(Comparator.comparingInt(class_12972 -> class_12972.method_5864().hashCode()));
        levelRendererAccessor.getLevel().method_16107().method_15405("build entity geometry");
        for (class_1297 class_12973 : arrayList) {
            levelRendererAccessor.invokeRenderEntity(class_12973, d, d2, d3, f, class_45872, (class_4597)class_45982);
        }
        levelRendererAccessor.getLevel().method_16107().method_15407();
        return arrayList.size();
    }

    private int renderPlayerEntity(LevelRendererAccessor levelRendererAccessor, class_898 class_8982, class_4597.class_4598 class_45982, class_4587 class_45872, float f, class_4604 class_46042, double d, double d2, double d3) {
        levelRendererAccessor.getLevel().method_16107().method_15396("cull");
        class_746 class_7462 = class_310.method_1551().field_1724;
        int n = 0;
        if (!class_8982.method_3950((class_1297)class_7462, class_46042, d, d2, d3) || class_7462.method_7325()) {
            return 0;
        }
        levelRendererAccessor.getLevel().method_16107().method_15405("build geometry");
        if (!class_7462.method_5685().isEmpty()) {
            for (int i = 0; i < class_7462.method_5685().size(); ++i) {
                levelRendererAccessor.invokeRenderEntity((class_1297)class_7462.method_5685().get(i), d, d2, d3, f, class_45872, (class_4597)class_45982);
                ++n;
            }
        }
        if (class_7462.method_5854() != null) {
            levelRendererAccessor.invokeRenderEntity(class_7462.method_5854(), d, d2, d3, f, class_45872, (class_4597)class_45982);
            ++n;
        }
        levelRendererAccessor.invokeRenderEntity((class_1297)class_7462, d, d2, d3, f, class_45872, (class_4597)class_45982);
        levelRendererAccessor.getLevel().method_16107().method_15407();
        return ++n;
    }

    private void copyPreTranslucentDepth(LevelRendererAccessor levelRendererAccessor) {
        levelRendererAccessor.getLevel().method_16107().method_15405("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    public void addDebugText(List<String> list) {
        list.add("[Iris] Shadow Maps: " + this.debugStringOverall);
        list.add("[Iris] Shadow Distance Terrain: " + this.terrainFrustumHolder.getDistanceInfo() + " Entity: " + this.entityFrustumHolder.getDistanceInfo());
        list.add("[Iris] Shadow Culling Terrain: " + this.terrainFrustumHolder.getCullingInfo() + " Entity: " + this.entityFrustumHolder.getCullingInfo());
        list.add("[Iris] Shadow Terrain: " + this.debugStringTerrain + (this.shouldRenderTerrain ? "" : " (no terrain) ") + (this.shouldRenderTranslucent ? "" : "(no translucent)"));
        list.add("[Iris] Shadow Entities: " + this.getEntitiesDebugString());
        list.add("[Iris] Shadow Block Entities: " + this.getBlockEntitiesDebugString());
        if (this.buffers instanceof DrawCallTrackingRenderBuffers && (this.shouldRenderEntities || this.shouldRenderPlayer)) {
            DrawCallTrackingRenderBuffers drawCallTrackingRenderBuffers = (DrawCallTrackingRenderBuffers)this.buffers;
            list.add("[Iris] Shadow Entity Batching: " + BatchingDebugMessageHelper.getDebugMessage(drawCallTrackingRenderBuffers));
        }
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? this.renderedShadowEntities + "/" + class_310.method_1551().field_1687.method_18120() : "disabled by pack";
    }

    private String getBlockEntitiesDebugString() {
        return this.shouldRenderBlockEntities ? "" + this.renderedShadowBlockEntities : "disabled by pack";
    }

    public void destroy() {
        this.targets.destroy();
        ((MemoryTrackingRenderBuffers)this.buffers).freeAndDeleteBuffers();
    }

    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int n, int n2) {
            this.texture = n;
            this.targetFilteringMode = n2;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

