/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.parsing;

import org.jetbrains.annotations.Nullable;

public class ParsedString {
    private String text;

    public ParsedString(String string) {
        this.text = string;
    }

    public boolean takeLiteral(String string) {
        if (!this.text.startsWith(string)) {
            return false;
        }
        this.text = this.text.substring(string.length());
        return true;
    }

    public boolean takeSomeWhitespace() {
        if (this.text.isEmpty() || !Character.isWhitespace(this.text.charAt(0))) {
            return false;
        }
        this.text = this.text.trim();
        return true;
    }

    public boolean takeComments() {
        if (!this.text.startsWith("//")) {
            return false;
        }
        this.text = this.text.substring(2);
        while (this.text.startsWith("/")) {
            this.text = this.text.substring(1);
        }
        return true;
    }

    public boolean currentlyContains(String string) {
        return this.text.contains(string);
    }

    public boolean isEnd() {
        return this.text.isEmpty();
    }

    public String takeRest() {
        return this.text;
    }

    private String takeCharacters(int n) {
        String string = this.text.substring(0, n);
        this.text = this.text.substring(n);
        return string;
    }

    @Nullable
    public String takeWord() {
        if (this.isEnd()) {
            return null;
        }
        int n = 0;
        for (char c : this.text.toCharArray()) {
            if (!Character.isDigit(c) && !Character.isAlphabetic(c) && c != '_') break;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return this.takeCharacters(n);
    }

    @Nullable
    public String takeNumber() {
        if (this.isEnd()) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        if (this.text.charAt(0) == '-') {
            ++n;
        }
        while (n < this.text.length() && Character.isDigit(this.text.charAt(n))) {
            ++n;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        if (n < this.text.length()) {
            char c = this.text.charAt(n);
            if (c == '.') {
                ++n;
                int n3 = 0;
                while (n < this.text.length() && Character.isDigit(this.text.charAt(n))) {
                    ++n;
                    ++n3;
                }
                if (n3 == 0) {
                    return null;
                }
                if (n < this.text.length() && ((c = this.text.charAt(n)) == 'f' || c == 'F')) {
                    ++n;
                }
            } else if (c == 'f' || c == 'F') {
                ++n;
            }
        }
        return this.takeCharacters(n);
    }

    @Nullable
    public String takeWordOrNumber() {
        String string = this.takeNumber();
        if (string == null) {
            return this.takeWord();
        }
        return string;
    }
}

