/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.format;

import java.util.Objects;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.DiscreteBlendFunction;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRType;
import org.jetbrains.annotations.Nullable;

public class LabPBRTextureFormat
implements TextureFormat {
    public static final ChannelMipmapGenerator SPECULAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, new DiscreteBlendFunction(n -> n < 230 ? 0 : n - 229), new DiscreteBlendFunction(n -> n < 65 ? 0 : 1), new DiscreteBlendFunction(n -> n < 255 ? 0 : 1));
    private final String name;
    @Nullable
    private final String version;

    public LabPBRTextureFormat(String string, @Nullable String string2) {
        this.name = string;
        this.version = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean canInterpolateValues(PBRType pBRType) {
        return pBRType != PBRType.SPECULAR;
    }

    @Override
    @Nullable
    public CustomMipmapGenerator getMipmapGenerator(PBRType pBRType) {
        if (pBRType == PBRType.SPECULAR) {
            return SPECULAR_MIPMAP_GENERATOR;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LabPBRTextureFormat labPBRTextureFormat = (LabPBRTextureFormat)object;
        return Objects.equals(this.name, labPBRTextureFormat.name) && Objects.equals(this.version, labPBRTextureFormat.version);
    }
}

