/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderUtils {
    public static final class_2960 TEXTURE_MAP_BACKGROUND = new class_2960("textures/map/map_background.png");
    public static final class_2960 TEXTURE_MAP_BACKGROUND_CHECKERBOARD = new class_2960("textures/map/map_background_checkerboard.png");
    private static final class_6575 RAND = new class_6575(0L);

    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }

    public static void setupBlendSimple() {
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableDiffuseLighting() {
        class_308.method_24210();
    }

    public static void enableDiffuseLightingForLevel(class_4587 matrixStack) {
        class_308.method_1452((Matrix4f)matrixStack.method_23760().method_23761());
    }

    public static void enableDiffuseLightingGui3D() {
        class_308.method_24211();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderUtils.setupBlend();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912((double)x, (double)y, (double)zLevel).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)x, (double)(y + height), (double)zLevel).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), (double)zLevel).method_22915(r, g, b, a).method_1344();
        buffer.method_22912((double)(x + width), (double)y, (double)zLevel).method_22915(r, g, b, a).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderUtils.setupBlend();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912((double)x, (double)(y + height), (double)zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), (double)zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).method_1344();
        buffer.method_22912((double)(x + width), (double)y, (double)zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth).method_1344();
        buffer.method_22912((double)x, (double)y, (double)zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth).method_1344();
        tessellator.method_1350();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, class_287 buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, class_287 buffer) {
        float pixelWidth = 0.00390625f;
        buffer.method_22912((double)x, (double)(y + height), (double)zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), (double)zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).method_1344();
        buffer.method_22912((double)(x + width), (double)y, (double)zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth).method_1344();
        buffer.method_22912((double)x, (double)y, (double)zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth).method_1344();
    }

    public static void drawHoverText(int x, int y, List<String> textLines, class_4587 matrixStack) {
        class_310 mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            class_327 font = mc.field_1772;
            RenderUtils.disableDiffuseLighting();
            RenderSystem.disableDepthTest();
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().field_22789;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.method_1727(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 300.0f);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                font.method_1720(matrixStack, str, (float)textStartX, (float)textStartY, -1);
                textStartY += lineHeight;
            }
            matrixStack.method_22909();
            RenderSystem.enableDepthTest();
            RenderUtils.enableDiffuseLightingGui3D();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderSystem.disableTexture();
        RenderUtils.setupBlend();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912((double)right, (double)top, zLevel).method_1336(sr, sg, sb, sa).method_1344();
        buffer.method_22912((double)left, (double)top, zLevel).method_1336(sr, sg, sb, sa).method_1344();
        buffer.method_22912((double)left, (double)bottom, zLevel).method_1336(er, eg, eb, ea).method_1344();
        buffer.method_22912((double)right, (double)bottom, zLevel).method_1336(er, eg, eb, ea).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    public static void drawCenteredString(int x, int y, int color, String text, class_4587 matrixStack) {
        class_327 textRenderer = RenderUtils.mc().field_1772;
        textRenderer.method_1720(matrixStack, text, (float)(x - textRenderer.method_1727(text) / 2), (float)y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, class_2960 atlas, class_2960 texture, class_4587 matrixStack) {
        if (texture != null) {
            class_1058 sprite = (class_1058)RenderUtils.mc().method_1549(atlas).apply(texture);
            class_332.method_25298((class_4587)matrixStack, (int)x, (int)y, (int)0, (int)width, (int)height, (class_1058)sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text, class_4587 matrixStack) {
        String[] parts = text.split("\\\\n");
        class_327 textRenderer = RenderUtils.mc().field_1772;
        for (String line : parts) {
            textRenderer.method_1720(matrixStack, line, (float)x, (float)y, color);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines, class_4587 matrixStack) {
        if (!lines.isEmpty()) {
            class_327 textRenderer = RenderUtils.mc().field_1772;
            for (String line : lines) {
                textRenderer.method_1729(matrixStack, line, (float)x, (float)y, color);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines, class_4587 matrixStack) {
        boolean scaled;
        class_327 fontRenderer = RenderUtils.mc().field_1772;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        class_4587 globalStack = RenderSystem.getModelViewStack();
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            globalStack.method_22903();
            globalStack.method_22905((float)scale, (float)scale, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (class_1657)RenderUtils.mc().field_1724);
        for (String line : lines) {
            int width = fontRenderer.method_1727(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            if (useShadow) {
                fontRenderer.method_1720(matrixStack, line, (float)x, (float)y, textColor);
                continue;
            }
            fontRenderer.method_1729(matrixStack, line, (float)x, (float)y, textColor);
        }
        if (scaled) {
            globalStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, class_1657 player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.method_6026();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (class_1293 effectInstance : effects) {
                    class_1291 effect = effectInstance.method_5579();
                    if (!effectInstance.method_5581() || !effectInstance.method_5592()) continue;
                    if (effect.method_5573()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        double minX = (double)pos.method_10263() - expand;
        double minY = (double)pos.method_10264() - expand;
        double minZ = (double)pos.method_10260() - expand;
        double maxX = (double)pos.method_10263() + expand + 1.0;
        double maxY = (double)pos.method_10264() + expand + 1.0;
        double maxZ = (double)pos.method_10260() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, class_243.field_1353, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        double minX = (double)pos.method_10263() - expand - cameraPos.field_1352;
        double minY = (double)pos.method_10264() - expand - cameraPos.field_1351;
        double minZ = (double)pos.method_10260() - expand - cameraPos.field_1350;
        double maxX = (double)pos.method_10263() + expand - cameraPos.field_1352 + 1.0;
        double maxY = (double)pos.method_10264() + expand - cameraPos.field_1351 + 1.0;
        double maxZ = (double)pos.method_10260() + expand - cameraPos.field_1350 + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, class_243.field_1353, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, class_243 cameraPos, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        double x1 = (double)posMin.method_10263() - cameraPos.field_1352;
        double y1 = (double)posMin.method_10264() - cameraPos.field_1351;
        double z1 = (double)posMin.method_10260() - cameraPos.field_1350;
        double x2 = (double)(posMax.method_10263() + 1) - cameraPos.field_1352;
        double y2 = (double)(posMax.method_10264() + 1) - cameraPos.field_1351;
        double z2 = (double)(posMax.method_10260() + 1) - cameraPos.field_1350;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBox(IntBoundingBox bb, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double minX = (double)bb.minX - cameraPos.field_1352;
        double minY = (double)bb.minY - cameraPos.field_1351;
        double minZ = (double)bb.minZ - cameraPos.field_1350;
        double maxX = (double)(bb.maxX + 1) - cameraPos.field_1352;
        double maxY = (double)(bb.maxY + 1) - cameraPos.field_1351;
        double maxZ = (double)(bb.maxZ + 1) - cameraPos.field_1350;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        class_1297 entity = RenderUtils.mc().method_1560();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.method_36454(), entity.method_36455(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        class_243 cameraPos = RenderUtils.mc().field_1773.method_19418().method_19326();
        double cx = cameraPos.field_1352;
        double cy = cameraPos.field_1351;
        double cz = cameraPos.field_1350;
        class_327 textRenderer = RenderUtils.mc().field_1772;
        class_4587 globalStack = RenderSystem.getModelViewStack();
        globalStack.method_22903();
        globalStack.method_22904(x - cx, y - cy, z - cz);
        Quaternionf rot = new Quaternionf().rotationYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        globalStack.method_22907(rot);
        globalStack.method_22905(-scale, -scale, scale);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableCull();
        RenderUtils.setupBlend();
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.method_1727(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912((double)(-strLenHalf - 1), -1.0, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_22912((double)(-strLenHalf - 1), (double)textHeight, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_22912((double)strLenHalf, (double)textHeight, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_22912((double)strLenHalf, -1.0, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        int textY = 0;
        if (!disableDepth) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        for (String line : text) {
            class_4597.class_4598 immediate;
            if (disableDepth) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableDepthTest();
                immediate = class_4597.method_22991((class_287)buffer);
                textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (class_4597)immediate, true, 0, 0xF000F0);
                immediate.method_22993();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
            }
            immediate = class_4597.method_22991((class_287)buffer);
            textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (class_4597)immediate, true, 0, 0xF000F0);
            immediate.method_22993();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        if (!disableDepth) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        globalStack.method_22909();
    }

    public static void renderBlockTargetingOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, Color4f color, class_4587 matrixStack, class_310 mc) {
        class_2350 playerFacing = entity.method_5735();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        class_4587 globalStack = RenderSystem.getModelViewStack();
        globalStack.method_22903();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableTexture();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(c, c, c, quadAlpha).method_1344();
        buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(c, c, c, quadAlpha).method_1344();
        buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(c, c, c, quadAlpha).method_1344();
        buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(c, c, c, quadAlpha).method_1344();
        switch (part) {
            case CENTER: {
                buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case LEFT: {
                buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case RIGHT: {
                buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case TOP: {
                buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case BOTTOM: {
                buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
        }
        tessellator.method_1350();
        RenderSystem.lineWidth((float)1.6f);
        buffer.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.25, y - 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.25, y + 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.25, y + 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(c, c, c, c).method_1344();
        tessellator.method_1350();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.25, y - 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.25, y + 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.25, y - 0.25, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.25, y + 0.25, z).method_1336(c, c, c, c).method_1344();
        tessellator.method_1350();
        globalStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(class_1297 entity, class_2338 pos, class_2350 side, Color4f color, class_4587 matrixStack, class_310 mc) {
        class_2350 playerFacing = entity.method_5735();
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        class_4587 globalStack = RenderSystem.getModelViewStack();
        globalStack.method_22903();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(r, g, b, a).method_1344();
        tessellator.method_1350();
        RenderSystem.lineWidth((float)1.6f);
        buffer.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        buffer.method_22912(x - 0.375, y - 0.375, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.375, y - 0.375, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x + 0.375, y + 0.375, z).method_1336(c, c, c, c).method_1344();
        buffer.method_22912(x - 0.375, y + 0.375, z).method_1336(c, c, c, c).method_1344();
        tessellator.method_1350();
        globalStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, class_2350 side, class_2350 playerFacing, class_4587 matrixStack) {
        matrixStack.method_22904(x, y, z);
        switch (side) {
            case field_11033: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - playerFacing.method_10144()));
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11036: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - playerFacing.method_10144()));
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11043: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                break;
            }
            case field_11034: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            }
        }
        matrixStack.method_22904(-x, -y, -z + 0.51);
    }

    public static void renderMapPreview(class_1799 stack, int x, int y, int dimensions) {
        if (stack.method_7909() instanceof class_1806 && GuiBase.isShiftDown()) {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            Integer mapId = class_1806.method_8003((class_1799)stack);
            class_22 mapState = class_1806.method_7997((Integer)mapId, (class_1937)RenderUtils.mc().field_1687);
            class_2960 bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            RenderUtils.bindTexture(bgTexture);
            RenderUtils.setupBlend();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.applyModelViewMatrix();
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            buffer.method_22912((double)x1, (double)y2, (double)z).method_22913(0.0f, 1.0f).method_1344();
            buffer.method_22912((double)x2, (double)y2, (double)z).method_22913(1.0f, 1.0f).method_1344();
            buffer.method_22912((double)x2, (double)y1, (double)z).method_22913(1.0f, 0.0f).method_1344();
            buffer.method_22912((double)x1, (double)y1, (double)z).method_22913(0.0f, 0.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.disableBlend();
            if (mapState != null) {
                x1 += 8;
                y1 += 8;
                z = 310;
                class_4597.class_4598 consumer = class_4597.method_22991((class_287)buffer);
                double scale = (double)(dimensions - 16) / 128.0;
                class_4587 matrixStack = new class_4587();
                matrixStack.method_22903();
                matrixStack.method_46416((float)x1, (float)y1, (float)z);
                matrixStack.method_22905((float)scale, (float)scale, 0.0f);
                RenderUtils.mc().field_1773.method_3194().method_1773(matrixStack, (class_4597)consumer, mapId.intValue(), mapState, false, 0xF000F0);
                consumer.method_22993();
                matrixStack.method_22909();
            }
        }
    }

    public static void renderShulkerBoxPreview(class_1799 stack, int baseX, int baseY, boolean useBgColors) {
        if (stack.method_7985()) {
            class_2371<class_1799> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480) {
                RenderUtils.setShulkerboxBackgroundTintColor((class_2480)((class_1747)stack.method_7909()).method_7711(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            RenderUtils.disableDiffuseLighting();
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableDiffuseLightingGui3D();
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable class_2480 block, boolean useBgColors) {
        if (block != null && useBgColors) {
            class_1767 dye = block.method_10528() != null ? block.method_10528() : class_1767.field_7945;
            float[] colors = dye.method_7787();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, class_1087 model, class_2680 state, float zLevel) {
        if (state.method_26204() == class_2246.field_10124) {
            return;
        }
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        RenderUtils.bindTexture(class_1723.field_21668);
        RenderUtils.mc().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.enableBlend();
        RenderUtils.setupBlendSimple();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.method_4712(), zLevel);
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(30.0f));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(225.0f));
        matrixStack.method_22905(0.625f, 0.625f, 0.625f);
        RenderUtils.renderModel(model, state);
        matrixStack.method_22909();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        RenderUtils.setupGuiTransform(RenderSystem.getModelViewStack(), xPosition, yPosition, zLevel);
    }

    public static void setupGuiTransform(class_4587 matrixStack, int xPosition, int yPosition, float zLevel) {
        matrixStack.method_22904((double)xPosition + 8.0, (double)yPosition + 8.0, (double)zLevel + 100.0);
        matrixStack.method_22905(16.0f, -16.0f, 16.0f);
    }

    private static void renderModel(class_1087 model, class_2680 state) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904(-0.5, -0.5, -0.5);
        int color = -1;
        if (!model.method_4713()) {
            RenderSystem.setShader(class_757::method_34495);
            RenderSystem.applyModelViewMatrix();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
            for (class_2350 face : class_2350.values()) {
                RAND.method_43052(0L);
                RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, face, (class_5819)RAND), state, color);
            }
            RAND.method_43052(0L);
            RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, null, (class_5819)RAND), state, color);
            tessellator.method_1350();
        }
        matrixStack.method_22909();
    }

    private static void renderQuads(class_287 renderer, List<class_777> quads, class_2680 state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            class_777 quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(class_287 buffer, class_777 quad, class_2680 state, int color) {
    }

    private static class_310 mc() {
        return class_310.method_1551();
    }
}

