/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_287;
import net.minecraft.class_4585;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585 {
    @Shadow
    private boolean field_21594;

    public void method_22920(class_4587.class_4665 matrices, class_777 quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.field_21594) {
            super.method_22920(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.field_20889) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f positionMatrix = matrices.method_23761();
        Matrix3f normalMatrix = matrices.method_23762();
        int norm = this.computeNormal(normalMatrix, quad.method_3358());
        QuadVertexSink drain = VertexDrain.of((class_4588)this).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            positionMatrix.transform(pos);
            drain.writeQuad(pos.x(), pos.y(), pos.z(), color, u, v, light[i], overlay, norm);
        }
        drain.flush();
    }

    private int computeNormal(Matrix3f normalMatrix, class_2350 face) {
        class_2382 faceNorm = face.method_10163();
        float x = faceNorm.method_10263();
        float y = faceNorm.method_10264();
        float z = faceNorm.method_10260();
        float x2 = normalMatrix.m00 * x + normalMatrix.m01 * y + normalMatrix.m02 * z;
        float y2 = normalMatrix.m10 * x + normalMatrix.m11 * y + normalMatrix.m12 * z;
        float z2 = normalMatrix.m20 * x + normalMatrix.m21 * y + normalMatrix.m22 * z;
        return Norm3b.pack(x2, y2, z2);
    }
}

