/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-InGameChecks");
    private static final List<String> VSH_FSH_BLACKLIST = Arrays.asList("rendertype_solid.vsh", "rendertype_solid.fsh", "rendertype_cutout_mipped.vsh", "rendertype_cutout_mipped.fsh", "rendertype_cutout.vsh", "rendertype_cutout.fsh", "rendertype_translucent.vsh", "rendertype_translucent.fsh", "rendertype_tripwire.vsh", "rendertype_tripwire.fsh");
    private static final List<String> GLSL_BLACKLIST = Arrays.asList("light.glsl", "fog.glsl");

    public static void checkIfCoreShaderLoaded(class_3300 manager) {
        String message;
        HashMap detectedResourcePacks = new HashMap();
        Stream customResourcePacks = manager.method_29213();
        customResourcePacks.forEach(resourcePack -> {
            if (!resourcePack.method_14409().equals("vanilla") && !resourcePack.method_14409().equals("fabric")) {
                String resourcePackName = resourcePack.method_14409();
                resourcePack.method_14408(class_3264.field_14188, "minecraft", "shaders", (path, ignored) -> {
                    String shaderName = path.method_12832().substring(path.method_12832().lastIndexOf(47) + 1);
                    if (VSH_FSH_BLACKLIST.contains(shaderName)) {
                        if (!detectedResourcePacks.containsKey(resourcePackName)) {
                            detectedResourcePacks.put(resourcePackName, MessageLevel.SEVERE);
                        } else if (detectedResourcePacks.get(resourcePackName) == MessageLevel.WARN) {
                            detectedResourcePacks.replace(resourcePackName, MessageLevel.SEVERE);
                        }
                        LOGGER.error("Resource pack '" + resourcePackName + "' replaces core shader '" + shaderName + "'");
                    }
                    if (GLSL_BLACKLIST.contains(shaderName)) {
                        if (!detectedResourcePacks.containsKey(resourcePackName)) {
                            detectedResourcePacks.put(resourcePackName, MessageLevel.WARN);
                        }
                        LOGGER.warn("Resource pack '" + resourcePackName + "' replaces shader '" + shaderName + "'");
                    }
                });
            }
        });
        if (detectedResourcePacks.containsValue((Object)MessageLevel.SEVERE)) {
            ResourcePackScanner.showConsoleMessage(class_2561.method_43471((String)"sodium.console.core_shaders_error"), MessageLevel.SEVERE);
            for (Map.Entry entry : detectedResourcePacks.entrySet()) {
                if (entry.getValue() != MessageLevel.SEVERE) continue;
                message = ((String)entry.getKey()).startsWith("file/") ? ((String)entry.getKey()).substring(5) : (String)entry.getKey();
                ResourcePackScanner.showConsoleMessage(class_2561.method_43470((String)message), MessageLevel.SEVERE);
            }
        }
        if (detectedResourcePacks.containsValue((Object)MessageLevel.WARN)) {
            ResourcePackScanner.showConsoleMessage(class_2561.method_43471((String)"sodium.console.core_shaders_warn"), MessageLevel.WARN);
            for (Map.Entry entry : detectedResourcePacks.entrySet()) {
                if (entry.getValue() != MessageLevel.WARN) continue;
                message = ((String)entry.getKey()).startsWith("file/") ? ((String)entry.getKey()).substring(5) : (String)entry.getKey();
                ResourcePackScanner.showConsoleMessage(class_2561.method_43470((String)message), MessageLevel.WARN);
            }
        }
        if (!detectedResourcePacks.isEmpty()) {
            ResourcePackScanner.showConsoleMessage(class_2561.method_43471((String)"sodium.console.core_shaders_info"), MessageLevel.INFO);
        }
    }

    private static void showConsoleMessage(class_5250 message, MessageLevel messageLevel) {
        Console.instance().logMessage(messageLevel, (class_2561)message, 20.0);
    }
}

