/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.occlusion;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.function.Consumer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.GraphDirectionSet;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.VisibilityEncoding;
import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.collections.DoubleBufferedQueue;
import me.jellysquid.mods.sodium.client.util.collections.ReadQueue;
import me.jellysquid.mods.sodium.client.util.collections.WriteQueue;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;

public class OcclusionCuller {
    private final Long2ReferenceMap<RenderSection> sections;
    private final class_1937 world;
    private final DoubleBufferedQueue<RenderSection> queue = new DoubleBufferedQueue();
    private static final float CHUNK_SECTION_SIZE = 9.125f;

    public OcclusionCuller(Long2ReferenceMap<RenderSection> sections, class_1937 world) {
        this.sections = sections;
        this.world = world;
    }

    public void findVisible(Consumer<RenderSection> visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        DoubleBufferedQueue<RenderSection> queues = this.queue;
        queues.reset();
        this.init(visitor, queues.write(), viewport, searchDistance, useOcclusionCulling, frame);
        while (queues.flip()) {
            OcclusionCuller.processQueue(visitor, viewport, searchDistance, useOcclusionCulling, frame, queues.read(), queues.write());
        }
    }

    private static void processQueue(Consumer<RenderSection> visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame, ReadQueue<RenderSection> readQueue, WriteQueue<RenderSection> writeQueue) {
        RenderSection section;
        while ((section = readQueue.dequeue()) != null) {
            if (OcclusionCuller.isOutsideRenderDistance(viewport.getTransform(), section, searchDistance) || OcclusionCuller.isOutsideFrustum(viewport, section)) continue;
            visitor.accept(section);
            int connections = useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData(), section.getIncomingDirections()) : 63;
            OcclusionCuller.visitNeighbors(writeQueue, section, connections &= OcclusionCuller.getOutwardDirections(viewport.getChunkCoord(), section), frame);
        }
    }

    private static void visitNeighbors(WriteQueue<RenderSection> queue, RenderSection section, int outgoing, int frame) {
        if ((outgoing &= section.getAdjacentMask()) == 0) {
            return;
        }
        queue.ensureCapacity(6);
        if (GraphDirectionSet.contains(outgoing, 0)) {
            OcclusionCuller.visitNode(queue, section.adjacentDown, GraphDirectionSet.of(1), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 1)) {
            OcclusionCuller.visitNode(queue, section.adjacentUp, GraphDirectionSet.of(0), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 2)) {
            OcclusionCuller.visitNode(queue, section.adjacentNorth, GraphDirectionSet.of(3), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 3)) {
            OcclusionCuller.visitNode(queue, section.adjacentSouth, GraphDirectionSet.of(2), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 4)) {
            OcclusionCuller.visitNode(queue, section.adjacentWest, GraphDirectionSet.of(5), frame);
        }
        if (GraphDirectionSet.contains(outgoing, 5)) {
            OcclusionCuller.visitNode(queue, section.adjacentEast, GraphDirectionSet.of(4), frame);
        }
    }

    private static void visitNode(WriteQueue<RenderSection> queue, @NotNull RenderSection render, int incoming, int frame) {
        if (render.getLastVisibleFrame() != frame) {
            render.setLastVisibleFrame(frame);
            render.setIncomingDirections(0);
            queue.enqueue(render);
        }
        render.addIncomingDirections(incoming);
    }

    private static int getOutwardDirections(class_4076 origin, RenderSection section) {
        int planes = 0;
        planes |= section.getChunkX() <= origin.method_10263() ? 16 : 0;
        planes |= section.getChunkX() >= origin.method_10263() ? 32 : 0;
        planes |= section.getChunkY() <= origin.method_10264() ? 1 : 0;
        planes |= section.getChunkY() >= origin.method_10264() ? 2 : 0;
        planes |= section.getChunkZ() <= origin.method_10260() ? 4 : 0;
        return planes |= section.getChunkZ() >= origin.method_10260() ? 8 : 0;
    }

    private static boolean isOutsideRenderDistance(CameraTransform camera, RenderSection section, float maxDistance) {
        int ox = section.getOriginX() - camera.intX;
        int oy = section.getOriginY() - camera.intY;
        int oz = section.getOriginZ() - camera.intZ;
        float dx = (float)OcclusionCuller.nearestToZero(ox, ox + 16) - camera.fracX;
        float dy = (float)OcclusionCuller.nearestToZero(oy, oy + 16) - camera.fracY;
        float dz = (float)OcclusionCuller.nearestToZero(oz, oz + 16) - camera.fracZ;
        return dx * dx + dz * dz > maxDistance * maxDistance || Math.abs(dy) > maxDistance;
    }

    private static int nearestToZero(int min, int max) {
        int clamped = 0;
        if (min > 0) {
            clamped = min;
        }
        if (max < 0) {
            clamped = max;
        }
        return clamped;
    }

    public static boolean isOutsideFrustum(Viewport viewport, RenderSection section) {
        return !viewport.isBoxVisible(section.getCenterX(), section.getCenterY(), section.getCenterZ(), 9.125f);
    }

    private void init(Consumer<RenderSection> visitor, WriteQueue<RenderSection> queue, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame) {
        class_4076 origin = viewport.getChunkCoord();
        if (origin.method_10264() < this.world.method_32891()) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.world.method_32891(), 0);
        } else if (origin.method_10264() >= this.world.method_31597()) {
            this.initOutsideWorldHeight(queue, viewport, searchDistance, frame, this.world.method_31597() - 1, 1);
        } else {
            this.initWithinWorld(visitor, queue, viewport, useOcclusionCulling, frame);
        }
    }

    private void initWithinWorld(Consumer<RenderSection> visitor, WriteQueue<RenderSection> queue, Viewport viewport, boolean useOcclusionCulling, int frame) {
        class_4076 origin = viewport.getChunkCoord();
        RenderSection section = this.getRenderSection(origin.method_10263(), origin.method_10264(), origin.method_10260());
        if (section == null) {
            return;
        }
        section.setLastVisibleFrame(frame);
        section.setIncomingDirections(0);
        visitor.accept(section);
        int outgoing = useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData()) : 63;
        OcclusionCuller.visitNeighbors(queue, section, outgoing, frame);
    }

    private void initOutsideWorldHeight(WriteQueue<RenderSection> queue, Viewport viewport, float searchDistance, int frame, int height, int direction) {
        int layer;
        class_4076 origin = viewport.getChunkCoord();
        int radius = class_3532.method_15375((float)(searchDistance / 16.0f));
        this.tryVisitNode(queue, origin.method_10263(), height, origin.method_10260(), direction, frame, viewport);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                this.tryVisitNode(queue, origin.method_10263() + x, height, origin.method_10260() + z, direction, frame, viewport);
            }
        }
    }

    private void tryVisitNode(WriteQueue<RenderSection> queue, int x, int y, int z, int direction, int frame, Viewport viewport) {
        RenderSection section = this.getRenderSection(x, y, z);
        if (section == null || OcclusionCuller.isOutsideFrustum(viewport, section)) {
            return;
        }
        OcclusionCuller.visitNode(queue, section, GraphDirectionSet.of(direction), frame);
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sections.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }
}

