/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.common.collect.Maps;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1528;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1590;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3879;
import net.minecraft.class_3888;
import net.minecraft.class_4057;
import net.minecraft.class_4058;
import net.minecraft.class_4059;
import net.minecraft.class_4466;
import net.minecraft.class_4495;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4791;
import net.minecraft.class_4997;
import net.minecraft.class_5148;
import net.minecraft.class_549;
import net.minecraft.class_553;
import net.minecraft.class_555;
import net.minecraft.class_558;
import net.minecraft.class_5597;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_562;
import net.minecraft.class_564;
import net.minecraft.class_565;
import net.minecraft.class_566;
import net.minecraft.class_567;
import net.minecraft.class_570;
import net.minecraft.class_571;
import net.minecraft.class_572;
import net.minecraft.class_574;
import net.minecraft.class_575;
import net.minecraft.class_576;
import net.minecraft.class_5772;
import net.minecraft.class_582;
import net.minecraft.class_583;
import net.minecraft.class_588;
import net.minecraft.class_591;
import net.minecraft.class_596;
import net.minecraft.class_597;
import net.minecraft.class_602;
import net.minecraft.class_604;
import net.minecraft.class_606;
import net.minecraft.class_607;
import net.minecraft.class_608;
import net.minecraft.class_609;
import net.minecraft.class_610;
import net.minecraft.class_611;
import net.minecraft.class_620;
import net.minecraft.class_624;
import net.minecraft.class_630;
import net.minecraft.class_7280;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_8185;
import net.minecraft.class_8251;
import net.minecraft.class_889;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Radar
implements IRadar {
    private LayoutVariables layoutVariables;
    public final MapSettingsManager minimapOptions;
    public final RadarSettingsManager options;
    private final TextureAtlas textureAtlas;
    private boolean newMobs;
    private boolean completedLoading;
    private int timer = 500;
    private float direction;
    private final ArrayList<Contact> contacts = new ArrayList(40);
    public final HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    public final HashMap<String, Integer> contactsSkinGetTries = new HashMap();
    private Sprite clothIcon;
    private static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    private final String[] armorNames = new String[]{"cloth", "clothOverlay", "clothOuter", "clothOverlayOuter", "chain", "iron", "gold", "diamond", "netherite", "turtle"};
    private boolean randomobsOptifine;
    private Map<String, Object> mapProperties;
    private Object randomEntity;
    private Class<?> randomEntityClass;
    private Method setEntityMethod;
    private Class<?> randomEntitiesPropertiesClass;
    private Method getEntityTextureMethod;
    private boolean hasCustomNPCs;
    private Class<?> entityCustomNpcClass;
    private Field modelDataField;
    private Method getEntityMethod;
    private boolean lastOutlines = true;
    private class_607 playerSkullModel;
    private class_572<class_1309> bipedArmorModel;
    private class_606<class_1528> strayOverlayModel;
    private class_564<class_1642> drownedOverlayModel;
    private class_572<class_1309> piglinArmorModel;
    private class_1043 nativeBackedTexture = new class_1043(2, 2, false);
    private final class_2960 nativeBackedTextureLocation = new class_2960("voxelmap", "tempimage");
    private final Vector3f fullbright = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final HashMap<UUID, BufferedImage> entityIconMap = new HashMap();
    private static final Int2ObjectMap<class_2960> LEVEL_TO_ID = (Int2ObjectMap)class_156.method_654((Object)new Int2ObjectOpenHashMap(), int2ObjectOpenHashMap -> {
        int2ObjectOpenHashMap.put(1, (Object)new class_2960("stone"));
        int2ObjectOpenHashMap.put(2, (Object)new class_2960("iron"));
        int2ObjectOpenHashMap.put(3, (Object)new class_2960("gold"));
        int2ObjectOpenHashMap.put(4, (Object)new class_2960("emerald"));
        int2ObjectOpenHashMap.put(5, (Object)new class_2960("diamond"));
    });
    private static final Map<class_5148, Object> TEXTURES = (Map)class_156.method_654((Object)Maps.newEnumMap(class_5148.class), enumMap -> {
        enumMap.put(class_5148.field_23808, null);
        enumMap.put(class_5148.field_23809, new class_2960("textures/entity/horse/horse_markings_white.png"));
        enumMap.put(class_5148.field_23810, new class_2960("textures/entity/horse/horse_markings_whitefield.png"));
        enumMap.put(class_5148.field_23811, new class_2960("textures/entity/horse/horse_markings_whitedots.png"));
        enumMap.put(class_5148.field_23812, new class_2960("textures/entity/horse/horse_markings_blackdots.png"));
    });

    public Radar() {
        this.minimapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.options = VoxelConstants.getVoxelMapInstance().getRadarOptions();
        this.textureAtlas = new TextureAtlas("mobs");
        this.textureAtlas.method_4527(false, false);
        try {
            Class<?> randomEntitiesClass = Class.forName("net.optifine.RandomEntities");
            Field mapPropertiesField = randomEntitiesClass.getDeclaredField("mapProperties");
            mapPropertiesField.setAccessible(true);
            this.mapProperties = (Map)mapPropertiesField.get(null);
            Field randomEntityField = randomEntitiesClass.getDeclaredField("randomEntity");
            randomEntityField.setAccessible(true);
            this.randomEntity = randomEntityField.get(null);
            Class<?> iRandomEntityClass = Class.forName("net.optifine.IRandomEntity");
            this.randomEntityClass = Class.forName("net.optifine.RandomEntity");
            Class[] argClasses1 = new Class[]{class_1297.class};
            this.setEntityMethod = this.randomEntityClass.getDeclaredMethod("setEntity", argClasses1);
            this.randomEntitiesPropertiesClass = Class.forName("net.optifine.RandomEntityProperties");
            Class[] argClasses2 = new Class[]{class_2960.class, iRandomEntityClass};
            this.getEntityTextureMethod = this.randomEntitiesPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
            this.randomobsOptifine = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException var7) {
            this.randomobsOptifine = false;
        }
        try {
            this.entityCustomNpcClass = Class.forName("noppes.npcs.entity.EntityCustomNpc");
            Class<?> modelDataClass = Class.forName("noppes.npcs.ModelData");
            this.modelDataField = this.entityCustomNpcClass.getField("modelData");
            Class<?> entityNPCInterfaceClass = Class.forName("noppes.npcs.entity.EntityNPCInterface");
            this.getEntityMethod = modelDataClass.getMethod("getEntity", entityNPCInterfaceClass);
            this.hasCustomNPCs = true;
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException var4) {
            this.hasCustomNPCs = false;
        }
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.loadTexturePackIcons();
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.mpContactsSkinGetTries.clear();
            this.contactsSkinGetTries.clear();
            this.textureAtlas.reset();
            class_5607 texturedModelData12 = class_607.method_32049();
            class_630 skullModelPart = texturedModelData12.method_32109();
            this.playerSkullModel = new class_607(skullModelPart);
            class_5605 ARMOR_DILATION = new class_5605(1.0f);
            class_5607 texturedModelData2 = class_5607.method_32110((class_5609)class_572.method_32011((class_5605)ARMOR_DILATION, (float)0.0f), (int)64, (int)32);
            class_630 bipedArmorModelPart = texturedModelData2.method_32109();
            this.bipedArmorModel = new class_572(bipedArmorModelPart);
            class_5607 strayModelData = class_5607.method_32110((class_5609)class_572.method_32011((class_5605)new class_5605(0.25f), (float)0.0f), (int)64, (int)32);
            class_630 strayOverlayModelPart = strayModelData.method_32109();
            this.strayOverlayModel = new class_606(strayOverlayModelPart);
            class_5607 drownedModelData = class_564.method_31993((class_5605)new class_5605(0.25f));
            class_630 drownedOverlayModelPart = drownedModelData.method_32109();
            this.drownedOverlayModel = new class_564(drownedOverlayModelPart);
            class_5607 texturedModelData3 = class_5607.method_32110((class_5609)class_572.method_32011((class_5605)new class_5605(1.02f), (float)0.0f), (int)64, (int)32);
            class_630 piglinArmorModelPart = texturedModelData3.method_32109();
            this.piglinArmorModel = new class_572(piglinArmorModelPart);
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new class_2960("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new class_2960("mcpatcher/mob/cow/mooshroom_overlay.png") : new class_2960("textures/block/red_mushroom.png");
            for (int t = 0; t < EnumMobs.values().length - 1; ++t) {
                String identifier = "minecraft." + EnumMobs.values()[t].id;
                String identifierSimple = EnumMobs.values()[t].id;
                String spriteName = identifier + EnumMobs.values()[t].resourceLocation.toString();
                spriteName = spriteName + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "");
                BufferedImage mobImage = this.getCustomMobImage(identifier, identifierSimple);
                if (mobImage != null) {
                    Sprite sprite = this.textureAtlas.registerIconForBufferedImage(identifier + "custom", mobImage);
                    this.textureAtlas.registerMaskedIcon(spriteName, sprite);
                    continue;
                }
                this.textureAtlas.registerFailedIcon(identifier + "custom");
                if (!((double)EnumMobs.values()[t].expectedWidth > 0.5) || (mobImage = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation, null)) == null) continue;
                float scale = (float)mobImage.getWidth() / EnumMobs.values()[t].expectedWidth;
                mobImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobImage, 4.0f / scale)), this.options.outlines, 2);
                this.textureAtlas.registerIconForBufferedImage(spriteName, mobImage);
            }
            BufferedImage[] armorImages = new BufferedImage[]{ImageUtils.loadImage(new class_2960("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new class_2960("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8), ImageUtils.loadImage(new class_2960("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8), ImageUtils.loadImage(new class_2960("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8)};
            for (int t = 0; t < armorImages.length; ++t) {
                float scale = (float)armorImages[t].getWidth() / 8.0f;
                armorImages[t] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorImages[t], 4.0f / scale * 47.0f / 38.0f)), this.options.outlines && t != 2 && t != 3, true, 37.6f, 37.6f, 2);
                Sprite icon = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t], armorImages[t]);
                if (t != 0) continue;
                this.clothIcon = icon;
            }
            BufferedImage zombie = ImageUtils.loadImage(EnumMobs.ZOMBIE.resourceLocation, 8, 8, 8, 8, 64, 64);
            float scale = (float)zombie.getWidth() / 8.0f;
            zombie = ImageUtils.scaleImage(zombie, 4.0f / scale * 47.0f / 38.0f);
            BufferedImage zombieHat = ImageUtils.loadImage(EnumMobs.ZOMBIE.resourceLocation, 40, 8, 8, 8, 64, 64);
            zombieHat = ImageUtils.scaleImage(zombieHat, 4.0f / scale * 47.0f / 35.0f);
            zombie = ImageUtils.addImages(ImageUtils.addImages(new BufferedImage(zombieHat.getWidth(), zombieHat.getHeight() + 8, 6), zombie, (float)(zombieHat.getWidth() - zombie.getWidth()) / 2.0f, (float)(zombieHat.getHeight() - zombie.getHeight()) / 2.0f, zombieHat.getWidth(), zombieHat.getHeight() + 8), zombieHat, 0.0f, 0.0f, zombieHat.getWidth(), zombieHat.getHeight() + 8);
            zombieHat.flush();
            zombie = ImageUtils.fillOutline(ImageUtils.pad(zombie), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + "head", zombie);
            BufferedImage skeleton = ImageUtils.loadImage(EnumMobs.SKELETON.resourceLocation, 8, 8, 8, 8, 64, 32);
            scale = (float)skeleton.getWidth() / 8.0f;
            skeleton = ImageUtils.scaleImage(skeleton, 4.0f / scale * 47.0f / 38.0f);
            skeleton = ImageUtils.addImages(new BufferedImage(skeleton.getWidth(), skeleton.getHeight() + 8, 6), skeleton, 0.0f, 0.0f, skeleton.getWidth(), skeleton.getHeight() + 8);
            skeleton = ImageUtils.fillOutline(ImageUtils.pad(skeleton), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + "head", skeleton);
            BufferedImage witherSkeleton = ImageUtils.loadImage(EnumMobs.SKELETONWITHER.resourceLocation, 8, 8, 8, 8, 64, 32);
            scale = (float)witherSkeleton.getWidth() / 8.0f;
            witherSkeleton = ImageUtils.scaleImage(witherSkeleton, 4.0f / scale * 47.0f / 38.0f);
            witherSkeleton = ImageUtils.addImages(new BufferedImage(witherSkeleton.getWidth(), witherSkeleton.getHeight() + 8, 6), witherSkeleton, 0.0f, 0.0f, witherSkeleton.getWidth(), witherSkeleton.getHeight() + 8);
            witherSkeleton = ImageUtils.fillOutline(ImageUtils.pad(witherSkeleton), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + "head", witherSkeleton);
            BufferedImage creeper = ImageUtils.addImages(ImageUtils.blankImage(EnumMobs.CREEPER.resourceLocation, 8, 10), ImageUtils.loadImage(EnumMobs.CREEPER.resourceLocation, 8, 8, 8, 8), 0.0f, 0.0f, 8, 10);
            scale = (float)creeper.getWidth() / EnumMobs.CREEPER.expectedWidth;
            creeper = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(creeper, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + "head", creeper);
            BufferedImage dragon = this.createImageFromTypeAndResourceLocations(EnumMobs.ENDERDRAGON, EnumMobs.ENDERDRAGON.resourceLocation, null, null);
            scale = (float)dragon.getWidth() / EnumMobs.ENDERDRAGON.expectedWidth;
            dragon = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(dragon, 4.0f / scale)), this.options.outlines, true, 32.0f, 32.0f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + "head", dragon);
            BufferedImage sheepFur = ImageUtils.loadImage(new class_2960("textures/entity/sheep/sheep_fur.png"), 6, 6, 6, 6);
            scale = (float)sheepFur.getWidth() / 6.0f;
            sheepFur = ImageUtils.scaleImage(sheepFur, 4.0f / scale * 1.0625f);
            int chop = (int)Math.max(1.0f, 2.0f);
            ImageUtils.eraseArea(sheepFur, chop, chop, sheepFur.getWidth() - chop * 2, sheepFur.getHeight() - chop * 2, sheepFur.getWidth(), sheepFur.getHeight());
            sheepFur = ImageUtils.fillOutline(ImageUtils.pad(sheepFur), this.options.outlines, true, 27.5f, 27.5f, (int)Math.max(1.0f, 2.0f));
            this.textureAtlas.registerIconForBufferedImage("sheepfur", sheepFur);
            class_2960 fontResourceLocation = new class_2960("textures/font/ascii.png");
            BufferedImage fontImage = ImageUtils.loadImage(fontResourceLocation, 0, 0, 128, 128, 128, 128);
            if (fontImage.getWidth() > 512 || fontImage.getHeight() > 512) {
                int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
                float scaleBy = 512.0f / (float)maxDim;
                fontImage = ImageUtils.scaleImage(fontImage, scaleBy);
            }
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception var30) {
            VoxelConstants.getLogger().error("Failed getting mobs" + var30.getLocalizedMessage(), (Throwable)var30);
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, class_2960 resourceLocation, class_2960 resourceLocationSecondary, class_1297 entity) {
        BufferedImage mobImage = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
        BufferedImage mobImageSecondary = null;
        if (resourceLocationSecondary != null) {
            mobImageSecondary = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
        }
        try {
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary, entity);
        }
        catch (Exception var8) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary, class_1297 entity) {
        BufferedImage image = null;
        switch (type) {
            case GENERICHOSTILE: {
                image = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/hostile.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICNEUTRAL: {
                image = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/neutral.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICTAME: {
                image = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/tame.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0.0f, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0.0f, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3.0f, 8, 12);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2.0f, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4.0f, 6, 6);
                break;
            }
            case COD: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 5, 32, 32), ImageUtils.loadImage(mobImage, 15, 3, 1, 3, 32, 32), 1.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 16, 3, 3, 4, 32, 32), 2.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 9, 7, 7, 4, 32, 32), 5.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 7, 4, 4, 32, 32), 12.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 0, 6, 1, 32, 32), 4.0f, 0.0f, 16, 5);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16.0f, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0.0f, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0.0f, 16, 16);
                break;
            }
            case GHAST: 
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GUARDIAN: {
                image = ImageUtils.scaleImage(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12), 0.5f);
                break;
            }
            case GUARDIANELDER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 64, 64), ImageUtils.loadImage(mobImage, 56, 38, 2, 16, 64, 64), 1.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 42, 7, 12, 64, 64), 3.0f, 12.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 7, 5, 64, 64), 3.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 30, 5, 5, 64, 64), 10.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 19, 17, 1, 3, 64, 64), 3.0f, 4.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 64, 64), 3.0f, 0.0f, 16, 24);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8.0f, 8, 12);
                break;
            }
            case LLAMA: 
            case LLAMATRADER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3.0f, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15.0f, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                ImageUtils.addImages(image, mushroomImage, 12.0f, 0.0f, 40, 40);
                break;
            }
            case PARROT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8, 32, 32), ImageUtils.loadImage(mobImage, 2, 22, 3, 5, 32, 32), 1.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 10, 4, 4, 1, 32, 32), 2.0f, 4.0f, 8, 8), ImageUtils.loadImage(mobImage, 2, 4, 2, 3, 32, 32), 2.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 11, 8, 1, 2, 32, 32), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 16, 8, 1, 2, 32, 32), 5.0f, 5.0f, 8, 8);
                break;
            }
            case PHANTOM: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 5, 5, 7, 3, 64, 64), ImageUtils.loadImage(mobImageSecondary, 5, 5, 7, 3, 64, 64), 0.0f, 0.0f, 7, 3);
                break;
            }
            case PUFFERFISH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 3, 3, 32, 32), ImageUtils.loadImage(mobImage, 3, 30, 3, 2, 32, 32), 0.0f, 1.0f, 3, 3), ImageUtils.loadImage(mobImage, 3, 29, 1, 1, 32, 32), 0.0f, 0.0f, 3, 3), ImageUtils.loadImage(mobImage, 5, 29, 1, 1, 32, 32), 2.0f, 0.0f, 3, 3);
                break;
            }
            case PUFFERFISHHALF: {
                image = ImageUtils.loadImage(mobImage, 17, 27, 5, 5, 32, 32);
                break;
            }
            case PUFFERFISHFULL: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 32, 32);
                break;
            }
            case SALMON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 26, 7, 32, 32), ImageUtils.loadImage(mobImage, 27, 3, 3, 4, 32, 32), 1.0f, 2.5f, 26, 7), ImageUtils.loadImage(mobImage, 11, 8, 8, 5, 32, 32), 4.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 11, 21, 8, 5, 32, 32), 12.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 26, 16, 6, 5, 32, 32), 20.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 0, 0, 2, 2, 32, 32), 10.0f, 0.0f, 26, 7), ImageUtils.loadImage(mobImage, 5, 6, 3, 2, 32, 32), 12.0f, 0.0f, 26, 7);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case TROPICALFISHA: {
                float[] primaryColorsA = new float[]{0.9765f, 0.502f, 0.1137f};
                float[] secondaryColorsA = new float[]{0.9765f, 1.0f, 0.9961f};
                if (entity instanceof class_1474) {
                    class_1474 fish = (class_1474)entity;
                    primaryColorsA = fish.method_6658().method_7787();
                    secondaryColorsA = fish.method_6655().method_7787();
                }
                BufferedImage baseA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 6, 32, 32), ImageUtils.loadImage(mobImage, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImage, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImage, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), primaryColorsA[0], primaryColorsA[1], primaryColorsA[2]);
                BufferedImage patternA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 10, 6, 32, 32), ImageUtils.loadImage(mobImageSecondary, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), secondaryColorsA[0], secondaryColorsA[1], secondaryColorsA[2]);
                image = ImageUtils.addImages(baseA, patternA, 0.0f, 0.0f, 10, 6);
                baseA.flush();
                patternA.flush();
                break;
            }
            case TROPICALFISHB: {
                float[] primaryColorsB = new float[]{0.5373f, 0.1961f, 0.7216f};
                float[] secondaryColorsB = new float[]{0.9961f, 0.8471f, 0.2392f};
                if (entity instanceof class_1474) {
                    class_1474 fish = (class_1474)entity;
                    primaryColorsB = fish.method_6658().method_7787();
                    secondaryColorsB = fish.method_6655().method_7787();
                }
                BufferedImage baseB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 12, 12, 32, 32), ImageUtils.loadImage(mobImage, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), primaryColorsB[0], primaryColorsB[1], primaryColorsB[2]);
                BufferedImage patternB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 12, 12, 32, 32), ImageUtils.loadImage(mobImageSecondary, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), secondaryColorsB[0], secondaryColorsB[1], secondaryColorsB[2]);
                image = ImageUtils.addImages(baseB, patternB, 0.0f, 0.0f, 12, 12);
                baseB.flush();
                patternB.flush();
                break;
            }
            case WITHER: 
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
        }
        mobImage.flush();
        if (mobImageSecondary != null) {
            mobImageSecondary.flush();
        }
        return image;
    }

    @Override
    public void onTickInGame(class_332 drawContext, class_4587 matrixStack, LayoutVariables layoutVariables) {
        if (this.options.radarAllowed || this.options.radarMobsAllowed || this.options.radarPlayersAllowed) {
            this.layoutVariables = layoutVariables;
            if (this.options.isChanged()) {
                this.timer = 500;
                if (this.options.outlines != this.lastOutlines) {
                    this.lastOutlines = this.options.outlines;
                    this.loadTexturePackIcons();
                }
            }
            this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
            while (this.direction >= 360.0f) {
                this.direction -= 360.0f;
            }
            while (this.direction < 0.0f) {
                this.direction += 360.0f;
            }
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(drawContext, matrixStack, this.layoutVariables.mapX, this.layoutVariables.mapY);
            }
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private boolean isEntityShown(class_1297 entity) {
        return entity != null && !entity.method_5756((class_1657)VoxelConstants.getPlayer()) && (this.options.showHostiles && (this.options.radarAllowed || this.options.radarMobsAllowed) && this.isHostile(entity) || this.options.showPlayers && (this.options.radarAllowed || this.options.radarPlayersAllowed) && this.isPlayer(entity) || this.options.showNeutrals && this.options.radarMobsAllowed && this.isNeutral(entity));
    }

    public void calculateMobs() {
        this.contacts.clear();
        Iterable entities = VoxelConstants.getClientWorld().method_18112();
        for (class_1297 entity : entities) {
            try {
                String scrubbedName;
                if (!this.isEntityShown(entity)) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.method_19538().method_10216();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.method_19538().method_10215();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.method_19538().method_10214();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                if (this.hasCustomNPCs) {
                    try {
                        Object modelData;
                        class_1309 wrappedEntity;
                        if (this.entityCustomNpcClass.isInstance(entity) && (wrappedEntity = (class_1309)this.getEntityMethod.invoke(modelData = this.modelDataField.get(entity), entity)) != null) {
                            entity = wrappedEntity;
                        }
                    }
                    catch (Exception modelData) {
                        // empty catch block
                    }
                }
                Contact contact2 = new Contact(entity, EnumMobs.getMobTypeByEntity(entity));
                String unscrubbedName = TextUtils.asFormattedString(contact2.entity.method_5476());
                contact2.setName(unscrubbedName);
                if (contact2.entity.method_5854() != null && this.isEntityShown(contact2.entity.method_5854())) {
                    contact2.yFudge = 1;
                }
                contact2.updateLocation();
                boolean enabled = false;
                if (!contact2.vanillaType) {
                    String type = entity.method_5864().method_5882();
                    CustomMob customMob = CustomMobsManager.getCustomMobByType(type);
                    if (customMob == null || customMob.enabled) {
                        enabled = true;
                    }
                } else if (contact2.type.enabled) {
                    enabled = true;
                }
                if (!enabled) continue;
                if (contact2.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact2);
                }
                if (contact2.icon == null) {
                    this.tryCustomIcon(contact2);
                }
                if (contact2.icon == null) {
                    this.tryAutoIcon(contact2);
                }
                if (contact2.icon == null) {
                    this.getGenericIcon(contact2);
                }
                if (contact2.type == EnumMobs.HORSE) {
                    contact2.setRotationFactor(45);
                }
                if (((scrubbedName = TextUtils.scrubCodes(contact2.entity.method_5477().getString())).equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact2.entity instanceof class_1657) || ((class_1657)contact2.entity).method_7348(class_1664.field_7559))) {
                    contact2.setRotationFactor(contact2.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact2.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact2.type != EnumMobs.PLAYER || contact2.type == EnumMobs.SHEEP) {
                    this.getArmor(contact2, entity);
                }
                this.contacts.add(contact2);
            }
            catch (Exception var16) {
                VoxelConstants.getLogger().error(var16.getLocalizedMessage(), (Throwable)var16);
            }
        }
        if (this.newMobs) {
            try {
                this.textureAtlas.stitchNew();
            }
            catch (StitcherException var14) {
                VoxelConstants.getLogger().warn("Stitcher exception!  Resetting mobs texture atlas.");
                this.loadTexturePackIcons();
            }
        }
        this.newMobs = false;
        this.contacts.sort(Comparator.comparingInt(contact -> contact.y));
    }

    private void tryCustomIcon(Contact contact) {
        Object identifier = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
        String identifierSimple = contact.vanillaType ? contact.type.id : contact.entity.getClass().getSimpleName();
        Sprite icon = this.textureAtlas.getAtlasSprite((String)identifier + "custom");
        if (icon == this.textureAtlas.getMissingImage()) {
            boolean isHostile = this.isHostile(contact.entity);
            CustomMobsManager.add(contact.entity.method_5864().method_5882(), isHostile, !isHostile);
            BufferedImage mobSkin = this.getCustomMobImage((String)identifier, identifierSimple);
            if (mobSkin != null) {
                icon = this.textureAtlas.registerIconForBufferedImage((String)identifier + "custom", mobSkin);
                this.newMobs = true;
                contact.icon = icon;
                contact.custom = true;
            } else {
                this.textureAtlas.registerFailedIcon((String)identifier + "custom");
            }
        } else if (icon != this.textureAtlas.getFailedImage()) {
            contact.custom = true;
            contact.icon = icon;
        }
    }

    private BufferedImage getCustomMobImage(String identifier, String identifierSimple) {
        BufferedImage mobSkin = null;
        try {
            int intendedSize = 8;
            String fullPath = ("textures/icons/" + identifier + ".png").toLowerCase();
            InputStream is = null;
            try {
                is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + ".png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifier + "8.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "8.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                intendedSize = 16;
                fullPath = ("textures/icons/" + identifier + "16.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "16.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                intendedSize = 32;
                fullPath = ("textures/icons/" + identifier + "32.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "32.png").toLowerCase();
                try {
                    is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960(fullPath)).get()).method_14482();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is != null) {
                mobSkin = ImageIO.read(is);
                is.close();
                mobSkin = ImageUtils.validateImage(mobSkin);
                float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                mobSkin = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 4.0f / scale)), this.options.outlines, 2);
            }
        }
        catch (Exception var16) {
            mobSkin = null;
        }
        return mobSkin;
    }

    private void tryAutoIcon(Contact contact) {
        block34: {
            class_897 render = VoxelConstants.getMinecraft().method_1561().method_3953(contact.entity);
            class_2960 resourceLocation = render.method_3931(contact.entity);
            resourceLocation = this.getRandomizedResourceLocationForEntity(resourceLocation, contact.entity);
            class_2960 resourceLocationSecondary = null;
            class_2960 resourceLocationTertiary = null;
            class_2960 resourceLocationQuaternary = null;
            String color = "";
            if (contact.type.secondaryResourceLocation != null) {
                if (contact.type == EnumMobs.MOOSHROOM) {
                    if (!((class_1438)contact.entity).method_6109()) {
                        resourceLocationSecondary = EnumMobs.MOOSHROOM.secondaryResourceLocation;
                    }
                } else if (contact.type != EnumMobs.TROPICALFISHA && contact.type != EnumMobs.TROPICALFISHB) {
                    class_1297 var22;
                    if (contact.type == EnumMobs.HORSE && (var22 = contact.entity) instanceof class_1498) {
                        class_1792 var30;
                        class_1498 horse = (class_1498)var22;
                        resourceLocationSecondary = (class_2960)TEXTURES.get(horse.method_27078());
                        class_1799 itemStack = horse.method_6786();
                        if (this.options.showHelmetsMobs && (var30 = itemStack.method_7909()) instanceof class_4059) {
                            class_4059 horseArmorItem = (class_4059)var30;
                            resourceLocationTertiary = horseArmorItem.method_18454();
                            if (horseArmorItem instanceof class_4058) {
                                class_4058 dyableHorseArmorItem = (class_4058)horseArmorItem;
                                contact.armorColor = dyableHorseArmorItem.method_7800(itemStack);
                            }
                        }
                    } else if (contact.type != EnumMobs.VILLAGER && contact.type != EnumMobs.ZOMBIEVILLAGER) {
                        resourceLocationSecondary = contact.type.secondaryResourceLocation;
                    } else {
                        boolean showBiomeHat;
                        zombie = contact.type == EnumMobs.ZOMBIEVILLAGER ? "zombie_" : "";
                        class_3850 villagerData = ((class_3851)contact.entity).method_7231();
                        class_3854 villagerType = villagerData.method_16919();
                        class_3852 villagerProfession = villagerData.method_16924();
                        resourceLocationSecondary = class_7923.field_41194.method_10221((Object)villagerType);
                        resourceLocationSecondary = new class_2960(resourceLocationSecondary.method_12836(), "textures/entity/" + (String)zombie + "villager/type/" + resourceLocationSecondary.method_12832() + ".png");
                        if (villagerProfession != class_3852.field_17051 && !((class_1309)contact.entity).method_6109()) {
                            resourceLocationTertiary = class_7923.field_41195.method_10221((Object)villagerProfession);
                            resourceLocationTertiary = new class_2960(resourceLocationTertiary.method_12836(), "textures/entity/" + (String)zombie + "villager/profession/" + resourceLocationTertiary.method_12832() + ".png");
                            if (villagerProfession != class_3852.field_17062) {
                                resourceLocationQuaternary = (class_2960)LEVEL_TO_ID.get(class_3532.method_15340((int)villagerData.method_16925(), (int)1, (int)LEVEL_TO_ID.size()));
                                resourceLocationQuaternary = new class_2960(resourceLocationQuaternary.method_12836(), "textures/entity/" + (String)zombie + "villager/profession_level/" + resourceLocationQuaternary.method_12832() + ".png");
                            }
                        }
                        class_3888.class_3889 biomeHatType = this.getHatType(resourceLocationSecondary);
                        class_3888.class_3889 professionHatType = this.getHatType(resourceLocationTertiary);
                        boolean bl = showBiomeHat = professionHatType == class_3888.class_3889.field_17160 || professionHatType == class_3888.class_3889.field_17161 && biomeHatType != class_3888.class_3889.field_17162;
                        if (!showBiomeHat) {
                            resourceLocationSecondary = null;
                        }
                    }
                } else {
                    zombie = (class_1474)contact.entity;
                }
                if (resourceLocationSecondary != null) {
                    resourceLocationSecondary = this.getRandomizedResourceLocationForEntity(resourceLocationSecondary, contact.entity);
                }
                if (resourceLocationTertiary != null) {
                    resourceLocationTertiary = this.getRandomizedResourceLocationForEntity(resourceLocationTertiary, contact.entity);
                }
                if (resourceLocationQuaternary != null) {
                    resourceLocationQuaternary = this.getRandomizedResourceLocationForEntity(resourceLocationQuaternary, contact.entity);
                }
            }
            Object entityName = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
            String resourceLocationString = (resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
            resourceLocationString = resourceLocationString + (resourceLocationTertiary != null ? resourceLocationTertiary.toString() : "") + (resourceLocationQuaternary != null ? resourceLocationQuaternary.toString() : "");
            String name = (String)entityName + color + (resourceLocationString = resourceLocationString + (Serializable)(contact.armorColor != -1 ? Integer.valueOf(contact.armorColor) : ""));
            Sprite icon = this.textureAtlas.getAtlasSprite(name);
            if (icon == this.textureAtlas.getMissingImage()) {
                Integer checkCount = this.contactsSkinGetTries.get(name);
                if (checkCount == null) {
                    checkCount = 0;
                }
                BufferedImage mobImage = null;
                if (contact.type == EnumMobs.HORSE) {
                    BufferedImage base = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
                    if (resourceLocationSecondary != null && base != null) {
                        BufferedImage pattern = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
                        pattern = ImageUtils.scaleImage(pattern, (float)base.getWidth() / (float)pattern.getWidth(), (float)base.getHeight() / (float)pattern.getHeight());
                        base = ImageUtils.addImages(base, pattern, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        pattern.flush();
                    }
                    if (resourceLocationTertiary != null && base != null) {
                        BufferedImage armor = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationTertiary);
                        armor = ImageUtils.scaleImage(armor, (float)base.getWidth() / (float)armor.getWidth(), (float)base.getHeight() / (float)armor.getHeight());
                        armor = ImageUtils.colorify(armor, contact.armorColor);
                        base = ImageUtils.addImages(base, armor, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        armor.flush();
                    }
                    mobImage = this.createImageFromTypeAndImages(contact.type, base, null, contact.entity);
                    base.flush();
                } else if ((double)contact.type.expectedWidth > 0.5) {
                    mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, resourceLocationSecondary, contact.entity);
                }
                mobImage = mobImage != null ? this.trimAndOutlineImage(contact, mobImage, false, true) : this.createAutoIconImageFromResourceLocations(contact, (class_897<class_1297>)render, resourceLocation, resourceLocationSecondary, resourceLocationTertiary, resourceLocationQuaternary);
                if (mobImage != null) {
                    try {
                        contact.icon = icon = this.textureAtlas.registerIconForBufferedImage(name, mobImage);
                        this.newMobs = true;
                        this.contactsSkinGetTries.remove(name);
                    }
                    catch (Exception var16) {
                        checkCount = checkCount + 1;
                        if (checkCount > 4) {
                            this.textureAtlas.registerFailedIcon(name);
                            this.contactsSkinGetTries.remove(name);
                            break block34;
                        }
                        this.contactsSkinGetTries.put(name, checkCount);
                    }
                } else if ((checkCount = Integer.valueOf(checkCount + 1)) > 4) {
                    this.textureAtlas.registerFailedIcon(name);
                    this.contactsSkinGetTries.remove(name);
                } else {
                    this.contactsSkinGetTries.put(name, checkCount);
                }
            } else if (icon != this.textureAtlas.getFailedImage()) {
                contact.icon = icon;
            }
        }
    }

    public class_3888.class_3889 getHatType(class_2960 resourceLocation) {
        class_3888.class_3889 hatType = class_3888.class_3889.field_17160;
        if (resourceLocation != null) {
            try {
                Optional resource = VoxelConstants.getMinecraft().method_1478().method_14486(resourceLocation);
                if (resource.isPresent()) {
                    class_3888 villagerResourceMetadata = (class_3888)((class_3298)resource.get()).method_14481();
                    if (villagerResourceMetadata != null) {
                        hatType = villagerResourceMetadata.method_17167();
                    }
                    ((class_3298)resource.get()).method_43039().close();
                }
            }
            catch (IOException | ClassCastException ignored) {
                hatType = class_3888.class_3889.field_17160;
            }
        }
        return hatType;
    }

    private BufferedImage createAutoIconImageFromResourceLocations(Contact contact, class_897<class_1297> entityRenderer, class_2960 ... resourceLocations) {
        class_1297 entity = contact.entity;
        EnumMobs type = contact.type;
        UUID entityUUID = contact.uuid;
        if (type != EnumMobs.UNKNOWN && entityIconMap.containsKey(entityUUID)) {
            return entityIconMap.get(entityUUID);
        }
        if (type == EnumMobs.UNKNOWN) {
            VoxelConstants.getLogger().info("Unknown Entity: " + entity.method_5864());
        }
        BufferedImage headImage = null;
        class_583 model = null;
        if (entityRenderer instanceof class_922) {
            class_922 render = (class_922)entityRenderer;
            try {
                model = render.method_4038();
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, class_3879.class, class_630.class);
                ArrayList<Field> submodelArrays = ReflectionUtils.getFieldsByType(model, class_3879.class, class_630[].class);
                class_630[] headBits = null;
                ArrayList<ModelPartWithResourceLocation> headPartsWithResourceLocationList = new ArrayList<ModelPartWithResourceLocation>();
                Properties properties = new Properties();
                Object fullName = contact.vanillaType ? "minecraft." + type.id : entity.getClass().getName();
                String simpleName = contact.vanillaType ? type.id : entity.getClass().getSimpleName();
                String fullPath = ("textures/icons/" + (String)fullName + ".properties").toLowerCase();
                class_3300 resourceManager = VoxelConstants.getMinecraft().method_1478();
                Optional resource = resourceManager.method_14486(new class_2960(fullPath));
                if (resource.isEmpty()) {
                    fullPath = ("textures/icons/" + simpleName + ".properties").toLowerCase();
                    resource = resourceManager.method_14486(new class_2960(fullPath));
                }
                if (resource.isPresent()) {
                    try (InputStream is = ((class_3298)resource.get()).method_14482();){
                        String name;
                        properties.load(is);
                        is.close();
                        String subModelNames = properties.getProperty("models", "").toLowerCase();
                        String[] submodelNamesArray = subModelNames.split(",");
                        List<String> subModelNamesList = Arrays.asList(submodelNamesArray);
                        HashSet<String> subModelNamesSet = new HashSet<String>(subModelNamesList);
                        ArrayList<class_630> arrayList = new ArrayList<class_630>();
                        for (Field submodelArray : submodelArrays) {
                            class_630[] submodelArrayValue;
                            name = submodelArray.getName().toLowerCase();
                            if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (class_630[])submodelArray.get(model)) == null) continue;
                            Collections.addAll(arrayList, submodelArrayValue);
                        }
                        for (Field submodel : submodels) {
                            Object modelPartObjekt;
                            name = submodel.getName().toLowerCase();
                            if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null || !((modelPartObjekt = submodel.get(model)) instanceof class_630)) continue;
                            class_630 modelPart = (class_630)modelPartObjekt;
                            arrayList.add(modelPart);
                        }
                        if (!arrayList.isEmpty()) {
                            headBits = arrayList.toArray(new class_630[0]);
                        }
                    }
                }
                if (headBits == null) {
                    if (model instanceof class_591) {
                        boolean showHat = true;
                        if (entity instanceof class_1657) {
                            class_1657 player = (class_1657)entity;
                            showHat = player.method_7348(class_1664.field_7563);
                        }
                        headBits = showHat ? new class_630[]{((class_591)model).field_3398, ((class_591)model).field_3394} : new class_630[]{((class_591)model).field_3398};
                    } else if (type == EnumMobs.STRAY) {
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((class_606)model).field_3398, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((class_606)model).field_3394, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.strayOverlayModel.field_3398, resourceLocations[1]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.strayOverlayModel.field_3394, resourceLocations[1]));
                    } else if (type == EnumMobs.DROWNED) {
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((class_564)model).field_3398, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((class_564)model).field_3394, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.drownedOverlayModel.field_3398, resourceLocations[1]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.drownedOverlayModel.field_3394, resourceLocations[1]));
                    } else if (model instanceof class_5772) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_5772.class, class_630.class, 6)};
                    } else if (model instanceof class_553) {
                        class_553 batEntityModel = (class_553)model;
                        headBits = new class_630[]{batEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_4495) {
                        headBits = new class_630[]{((class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_4495.class, class_630.class, 0)).method_32086("body")};
                    } else if (model instanceof class_572) {
                        class_572 bipedEntityModel = (class_572)model;
                        headBits = new class_630[]{bipedEntityModel.field_3398, bipedEntityModel.field_3394};
                    } else if (model instanceof class_555) {
                        class_555 blazeEntityModel = (class_555)model;
                        headBits = new class_630[]{blazeEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_558) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_558.class, class_630.class)};
                    } else if (model instanceof class_562) {
                        class_562 creeperEntityModel = (class_562)model;
                        headBits = new class_630[]{creeperEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_889) {
                        class_889 dolphinEntityModel = (class_889)model;
                        headBits = new class_630[]{dolphinEntityModel.method_32008().method_32086("body").method_32086("head")};
                    } else if (model instanceof class_565) {
                        class_565 class_5652 = (class_565)model;
                        headBits = new class_630[]{class_5652.method_32008().method_32086("segment0"), class_5652.method_32008().method_32086("segment1")};
                    } else if (model instanceof class_567) {
                        class_567 ghastEntityModel = (class_567)model;
                        headBits = new class_630[]{ghastEntityModel.method_32008()};
                    } else if (model instanceof class_570) {
                        class_570 guardianEntityModel = (class_570)model;
                        headBits = new class_630[]{guardianEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_4791) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_4791.class, class_630.class)};
                    } else if (model instanceof class_549) {
                        class_549 horseEntityModel = (class_549)model;
                        headBits = (class_630[])StreamSupport.stream(horseEntityModel.method_22946().spliterator(), false).toArray(class_630[]::new);
                    } else if (model instanceof class_575) {
                        class_575 illagerEntityModel = (class_575)model;
                        headBits = new class_630[]{illagerEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_574) {
                        class_574 ironGolemEntityModel = (class_574)model;
                        headBits = new class_630[]{ironGolemEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_576) {
                        headBits = (class_630[])ReflectionUtils.getPrivateFieldValueByType(model, class_576.class, class_630[].class);
                    } else if (model instanceof class_582) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_582.class, class_630.class, 6)};
                    } else if (model instanceof class_588) {
                        class_588 phantomEntityModel = (class_588)model;
                        headBits = new class_630[]{phantomEntityModel.method_32008().method_32086("body")};
                    } else if (model instanceof class_596) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_596.class, class_630.class, 7), (class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_596.class, class_630.class, 8), (class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_596.class, class_630.class, 9), (class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_596.class, class_630.class, 11)};
                    } else if (model instanceof class_571) {
                        class_571 ravagerEntityModel = (class_571)model;
                        headBits = new class_630[]{ravagerEntityModel.method_32008().method_32086("neck").method_32086("head")};
                    } else if (model instanceof class_602) {
                        class_602 shulkerEntityModel = (class_602)model;
                        headBits = new class_630[]{shulkerEntityModel.method_2830()};
                    } else if (model instanceof class_604) {
                        class_604 silverFishEntityModel = (class_604)model;
                        headBits = new class_630[]{silverFishEntityModel.method_32008().method_32086("segment0"), silverFishEntityModel.method_32008().method_32086("segment1")};
                    } else if (model instanceof class_609) {
                        class_609 slimeEntityModel = (class_609)model;
                        headBits = new class_630[]{slimeEntityModel.method_32008()};
                    } else if (model instanceof class_8185) {
                        class_8185 snifferModel = (class_8185)model;
                        headBits = new class_630[]{snifferModel.method_32008().method_32086("bone").method_32086("body").method_32086("head")};
                    } else if (model instanceof class_608) {
                        class_608 snowGolemEntityModel = (class_608)model;
                        headBits = new class_630[]{snowGolemEntityModel.method_32008().method_32086("head")};
                    } else if (model instanceof class_611) {
                        class_611 spiderEntityModel = (class_611)model;
                        headBits = new class_630[]{spiderEntityModel.method_32008().method_32086("head"), spiderEntityModel.method_32008().method_32086("body0")};
                    } else if (model instanceof class_610) {
                        class_610 squidEntityModel = (class_610)model;
                        headBits = new class_630[]{squidEntityModel.method_32008().method_32086("body")};
                    } else if (model instanceof class_7280) {
                        class_7280 wardenEntityModel = (class_7280)model;
                        headBits = new class_630[]{wardenEntityModel.method_32008().method_32086("bone").method_32086("body").method_32086("head")};
                    } else if (model instanceof class_4997) {
                        class_4997 striderEntityModel = (class_4997)model;
                        headBits = new class_630[]{striderEntityModel.method_32008().method_32086("body")};
                    } else if (model instanceof class_620) {
                        class_620 villagerResemblingModel = (class_620)model;
                        headBits = new class_630[]{villagerResemblingModel.method_2838()};
                    } else if (model instanceof class_624) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_624.class, class_630.class)};
                    } else if (model instanceof class_597) {
                        headBits = new class_630[]{(class_630)ReflectionUtils.getPrivateFieldValueByType(model, class_597.class, class_630.class)};
                    } else if (model instanceof class_5597) {
                        class_5597 singlePartEntityModel = (class_5597)model;
                        try {
                            headBits = new class_630[]{singlePartEntityModel.method_32008().method_32086("head")};
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (headBits == null) {
                    String name;
                    ArrayList<class_630> headPartsArrayList = new ArrayList<class_630>();
                    ArrayList purge = new ArrayList();
                    for (Field submodelArray : submodelArrays) {
                        class_630[] class_630Array;
                        name = submodelArray.getName().toLowerCase();
                        if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (class_630Array = (class_630[])submodelArray.get(model)) == null) continue;
                        headPartsArrayList.add(class_630Array[0]);
                    }
                    for (Field submodel : submodels) {
                        name = submodel.getName().toLowerCase();
                        String string = submodel.getName();
                        if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | string.equals("REar") | string.equals("Trout")) || !(!string.equals("LeftSmallEar") & !string.equals("RightSmallEar") & !string.equals("BHead") & !string.equals("BSnout") & !string.equals("BMouth") & !string.equals("BMouthOpen") & !string.equals("BLEar") & !string.equals("BREar") & !string.equals("CHead") & !string.equals("CSnout") & !string.equals("CMouth") & !string.equals("CMouthOpen") & !string.equals("CLEar") & !string.equals("CREar")) || submodel.get(model) == null) continue;
                        headPartsArrayList.add((class_630)submodel.get(model));
                    }
                    if (headPartsArrayList.isEmpty()) {
                        class_630[] submodelArrayValue;
                        int pos;
                        int n = pos = model instanceof class_5597 ? 1 : 0;
                        if (submodels.size() > pos) {
                            if (submodels.get(pos).get(model) != null) {
                                headPartsArrayList.add((class_630)submodels.get(pos).get(model));
                            }
                        } else if (!submodelArrays.isEmpty() && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (class_630[])submodelArrays.get(0).get(model)).length > 0) {
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                    }
                    for (class_630 bit : headPartsArrayList) {
                        try {
                            Object childrenObj = ReflectionUtils.getPrivateFieldValueByType(bit, class_630.class, ObjectList.class, 1);
                            if (childrenObj == null) continue;
                            List list = (List)childrenObj;
                            purge.addAll(list);
                        }
                        catch (Exception childrenObj) {}
                    }
                    headPartsArrayList.removeAll(purge);
                    headBits = headPartsArrayList.toArray(new class_630[0]);
                }
                if (!(headBits.length <= 0 && headPartsWithResourceLocationList.isEmpty() || resourceLocations[0] == null)) {
                    String scaleString = properties.getProperty("scale", "1");
                    float scale = Float.parseFloat(scaleString);
                    class_2350 facing = class_2350.field_11043;
                    String facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = class_2350.field_11036;
                    } else if (facingString.equals("side")) {
                        facing = class_2350.field_11034;
                    }
                    class_2960 resourceLocation = this.combineResourceLocations(resourceLocations);
                    for (class_630 headBit : headBits) {
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(headBit, resourceLocation));
                    }
                    ModelPartWithResourceLocation[] modelPartWithResourceLocationArray = headPartsWithResourceLocationList.toArray(new ModelPartWithResourceLocation[0]);
                    boolean success = this.drawModel(scale, 1000, (class_1309)entity, facing, (class_3879)model, modelPartWithResourceLocationArray);
                    ImageUtils.saveImage(type.id, OpenGL.Utils.fboTextureId, 0, 512, 512);
                    if (success) {
                        headImage = ImageUtils.createBufferedImageFromGLID(OpenGL.Utils.fboTextureId);
                    }
                }
            }
            catch (Exception exception) {
                VoxelConstants.getLogger().error((Object)exception);
            }
        }
        if (headImage != null) {
            headImage = this.trimAndOutlineImage(contact, headImage, true, model instanceof class_572);
        }
        if (contact.type == EnumMobs.CAMEL || contact.type == EnumMobs.SNIFFER) {
            headImage = Radar.resizeBufferedImage(headImage, headImage.getHeight() / 2, headImage.getHeight() / 2);
        }
        entityIconMap.put(entityUUID, headImage);
        return headImage;
    }

    public static BufferedImage resizeBufferedImage(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    private class_2960 combineResourceLocations(class_2960 ... resourceLocations) {
        class_2960 resourceLocation = resourceLocations[0];
        if (resourceLocations.length > 1) {
            boolean hasAdditional = false;
            try {
                Image base = null;
                for (int t = 1; t < resourceLocations.length; ++t) {
                    if (resourceLocations[t] == null) continue;
                    if (!hasAdditional) {
                        base = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
                    }
                    hasAdditional = true;
                    BufferedImage overlay = ImageUtils.createBufferedImageFromResourceLocation(resourceLocations[t]);
                    float xScale = (float)((BufferedImage)base).getWidth() / (float)overlay.getWidth();
                    float yScale = (float)((BufferedImage)base).getHeight() / (float)overlay.getHeight();
                    if (xScale != 1.0f || yScale != 1.0f) {
                        overlay = ImageUtils.scaleImage(overlay, xScale, yScale);
                    }
                    ImageUtils.addImages((BufferedImage)base, overlay, 0.0f, 0.0f, ((BufferedImage)base).getWidth(), ((BufferedImage)base).getHeight());
                    overlay.flush();
                }
                if (hasAdditional) {
                    class_1011 nativeImage = OpenGL.Utils.nativeImageFromBufferedImage(base);
                    base.flush();
                    this.nativeBackedTexture.close();
                    this.nativeBackedTexture = new class_1043(nativeImage);
                    OpenGL.Utils.register(this.nativeBackedTextureLocation, (class_1044)this.nativeBackedTexture);
                    resourceLocation = this.nativeBackedTextureLocation;
                }
            }
            catch (Exception var9) {
                VoxelConstants.getLogger().warn((Object)var9);
            }
        }
        return resourceLocation;
    }

    private boolean drawModel(float scale, int captureDepth, class_1309 livingEntity, class_2350 facing, class_3879 model, ModelPartWithResourceLocation[] headBits) {
        boolean failed = false;
        float size = 64.0f * scale;
        OpenGL.glBindTexture(3553, OpenGL.Utils.fboTextureId);
        int width = OpenGL.glGetTexLevelParameteri(3553, 0, 4096);
        int height = OpenGL.glGetTexLevelParameteri(3553, 0, 4097);
        OpenGL.glBindTexture(3553, 0);
        OpenGL.glViewport(0, 0, width, height);
        Matrix4f minimapProjectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43360);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_34426();
        matrixStack.method_22904(0.0, 0.0, -3000.0 + (double)captureDepth);
        RenderSystem.applyModelViewMatrix();
        OpenGL.Utils.bindFramebuffer();
        OpenGL.glDepthMask(true);
        OpenGL.glEnable(2929);
        OpenGL.glEnable(3042);
        OpenGL.glDisable(2884);
        OpenGL.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        OpenGL.glClearDepth(1.0);
        OpenGL.glClear(16640);
        OpenGL.glBlendFunc(770, 771);
        matrixStack.method_22903();
        matrixStack.method_22904((double)((float)width / 2.0f), (double)((float)height / 2.0f), 0.0);
        matrixStack.method_22905(size, size, size);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        if (facing == class_2350.field_11034) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        } else if (facing == class_2350.field_11036) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        }
        RenderSystem.applyModelViewMatrix();
        Vector4f fullbright2 = new Vector4f(this.fullbright.x, this.fullbright.y, this.fullbright.z, 0.0f);
        fullbright2.mul((Matrix4fc)matrixStack.method_23760().method_23761());
        Vector3f fullbright3 = new Vector3f(fullbright2.x, fullbright2.y, fullbright2.z);
        RenderSystem.setShaderLights((Vector3f)fullbright3, (Vector3f)fullbright3);
        try {
            class_4587 newMatrixStack = new class_4587();
            class_4597.class_4598 immediate = VoxelConstants.getMinecraft().method_22940().method_23000();
            float offsetByY = model instanceof class_566 ? 8.0f : (!(model instanceof class_572) && !(model instanceof class_607) ? 0.0f : 4.0f);
            float maxY = 0.0f;
            float minY = 0.0f;
            for (ModelPartWithResourceLocation headBit : headBits) {
                if (headBit.modelPart.field_3656 < minY) {
                    minY = headBit.modelPart.field_3656;
                }
                if (!(headBit.modelPart.field_3656 > maxY)) continue;
                maxY = headBit.modelPart.field_3656;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            for (ModelPartWithResourceLocation headBit : headBits) {
                class_4588 vertexConsumer = immediate.getBuffer(model.method_23500(headBit.resourceLocation));
                if (model instanceof class_583) {
                    class_583 entityModel = (class_583)model;
                    entityModel.method_2819((class_1297)livingEntity, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
                }
                float y = headBit.modelPart.field_3656;
                headBit.modelPart.field_3656 += offsetByY;
                headBit.modelPart.method_22698(newMatrixStack, vertexConsumer, 0xF000F0, class_4608.field_21444);
                headBit.modelPart.field_3656 = y;
                immediate.method_22993();
            }
        }
        catch (Exception var25) {
            VoxelConstants.getLogger().warn("Error attempting to render head bits for " + livingEntity.getClass().getSimpleName(), (Throwable)var25);
            failed = true;
        }
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        OpenGL.glEnable(2884);
        OpenGL.glDisable(2929);
        OpenGL.glDepthMask(false);
        OpenGL.Utils.unbindFramebuffer();
        RenderSystem.setProjectionMatrix((Matrix4f)minimapProjectionMatrix, (class_8251)class_8251.field_43360);
        OpenGL.glViewport(0, 0, VoxelConstants.getMinecraft().method_22683().method_4489(), VoxelConstants.getMinecraft().method_22683().method_4506());
        return !failed;
    }

    private void getGenericIcon(Contact contact) {
        contact.type = this.getUnknownMobNeutrality(contact.entity);
        String name = "minecraft." + contact.type.id + contact.type.resourceLocation.toString();
        contact.icon = this.textureAtlas.getAtlasSprite(name);
    }

    private class_2960 getRandomizedResourceLocationForEntity(class_2960 resourceLocation, class_1297 entity) {
        try {
            Object randomEntitiesProperties;
            if (this.randomobsOptifine && (randomEntitiesProperties = this.mapProperties.get(resourceLocation.method_12832())) != null) {
                this.setEntityMethod.invoke(this.randomEntityClass.cast(this.randomEntity), entity);
                resourceLocation = (class_2960)this.getEntityTextureMethod.invoke(this.randomEntitiesPropertiesClass.cast(randomEntitiesProperties), resourceLocation, this.randomEntityClass.cast(this.randomEntity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceLocation;
    }

    private BufferedImage trimAndOutlineImage(Contact contact, BufferedImage image, boolean auto, boolean centered) {
        if (auto) {
            image = centered ? ImageUtils.trimCentered(image) : ImageUtils.trim(image);
            double acceptableMax = 64.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 128.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)Math.ceil((double)maxDimension / acceptableMax);
            return ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines, 2);
        }
        float scale = (float)image.getWidth() / contact.type.expectedWidth;
        return ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 4.0f / scale)), this.options.outlines, 2);
    }

    private void handleMPplayer(Contact contact) {
        class_742 player = (class_742)contact.entity;
        GameProfile gameProfile = player.method_7334();
        UUID uuid = gameProfile.getId();
        contact.setUUID(uuid);
        String playerName = this.scrubCodes(gameProfile.getName());
        Sprite icon = this.textureAtlas.getAtlasSprite(playerName);
        if (icon == this.textureAtlas.getMissingImage()) {
            Integer checkCount = this.mpContactsSkinGetTries.get(playerName);
            if (checkCount == null) {
                checkCount = 0;
            }
            if (checkCount < 5) {
                try {
                    class_2960 skinIdentifier = VoxelConstants.getMinecraft().method_1582().method_52862(player.method_7334()).comp_1626();
                    if (skinIdentifier == class_1068.method_4648((UUID)player.method_5667()).comp_1626()) {
                        throw new Exception("failed to get skin: skin is default");
                    }
                    class_1046 imageData = (class_1046)VoxelConstants.getMinecraft().method_1531().method_4619(skinIdentifier);
                    if (imageData == null) {
                        throw new Exception("failed to get skin: image data was null");
                    }
                    class_897 render = VoxelConstants.getMinecraft().method_1561().method_3953(contact.entity);
                    BufferedImage skinImage = this.createAutoIconImageFromResourceLocations(contact, (class_897<class_1297>)render, skinIdentifier, null);
                    icon = this.textureAtlas.registerIconForBufferedImage(playerName, skinImage);
                    this.newMobs = true;
                    this.mpContactsSkinGetTries.remove(playerName);
                }
                catch (Exception var11) {
                    icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString());
                    checkCount = checkCount + 1;
                    this.mpContactsSkinGetTries.put(playerName, checkCount);
                }
                contact.icon = icon;
            }
        } else {
            contact.icon = icon;
        }
    }

    private void getArmor(Contact contact, class_1297 entity) {
        Sprite icon = null;
        class_1799 stack = ((class_1309)entity).method_6118(class_1304.field_6169);
        class_1792 helmet = null;
        if (stack != null && stack.method_7947() > 0) {
            helmet = stack.method_7909();
        }
        if (contact.type == EnumMobs.SHEEP) {
            class_1472 sheepEntity = (class_1472)contact.entity;
            if (!sheepEntity.method_6629()) {
                icon = this.textureAtlas.getAtlasSprite("sheepfur");
                float[] sheepColors = class_1472.method_6634((class_1767)sheepEntity.method_6633());
                contact.setArmorColor((int)(sheepColors[0] * 255.0f) << 16 | (int)(sheepColors[1] * 255.0f) << 8 | (int)(sheepColors[2] * 255.0f));
            }
        } else if (helmet != null) {
            BufferedImage blockImage;
            class_1747 blockItem;
            class_2248 block;
            class_2680 blockState;
            int stateID;
            if (helmet == class_1802.field_8398) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + "head");
            } else if (helmet == class_1802.field_8791) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + "head");
            } else if (helmet == class_1802.field_8470) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + "head");
            } else if (helmet == class_1802.field_8681) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + "head");
            } else if (helmet == class_1802.field_8712) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + "head");
            } else if (helmet == class_1802.field_8575) {
                class_630 outer;
                class_630 inner;
                ModelPartWithResourceLocation[] headBits;
                boolean success;
                GameProfile gameProfile = null;
                if (stack.method_7985()) {
                    String name;
                    class_2487 nbttagcompound = stack.method_7969();
                    if (nbttagcompound.method_10573("SkullOwner", 10)) {
                        gameProfile = class_2512.method_10683((class_2487)nbttagcompound.method_10562("SkullOwner"));
                    } else if (nbttagcompound.method_10573("SkullOwner", 8) && (name = nbttagcompound.method_10558("SkullOwner")) != null && !name.isEmpty()) {
                        gameProfile = new GameProfile(null, name);
                        nbttagcompound.method_10551("SkullOwner");
                    }
                }
                class_2960 resourceLocation = class_1068.method_4649();
                if (gameProfile != null) {
                    resourceLocation = VoxelConstants.getMinecraft().method_1582().method_52862(gameProfile).comp_1626();
                }
                if ((icon = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched("minecraft." + EnumMobs.PLAYER.id + resourceLocation.toString() + "head")) == this.textureAtlas.getMissingImage() && (success = this.drawModel(1.1875f, 1000, (class_1309)contact.entity, class_2350.field_11043, (class_3879)this.playerSkullModel, headBits = new ModelPartWithResourceLocation[]{new ModelPartWithResourceLocation(inner = (class_630)ReflectionUtils.getPrivateFieldValueByType(this.playerSkullModel, class_607.class, class_630.class, 0), resourceLocation), new ModelPartWithResourceLocation(outer = (class_630)ReflectionUtils.getPrivateFieldValueByType(this.playerSkullModel, class_607.class, class_630.class, 1), resourceLocation)}))) {
                    BufferedImage headImage = ImageUtils.createBufferedImageFromGLID(OpenGL.Utils.fboTextureId);
                    headImage = this.trimAndOutlineImage(new Contact((class_1297)VoxelConstants.getPlayer(), EnumMobs.PLAYER), headImage, true, true);
                    icon = this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.PLAYER.id + resourceLocation + "head", headImage);
                    this.newMobs = true;
                }
            } else if (helmet instanceof class_1738) {
                class_1738 helmetArmor = (class_1738)helmet;
                int armorType = this.getArmorType(helmetArmor);
                if (armorType != UNKNOWN) {
                    icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType]);
                } else {
                    boolean isPiglin = contact.type == EnumMobs.PIGLIN || contact.type == EnumMobs.PIGLINZOMBIE;
                    icon = this.textureAtlas.getAtlasSprite("armor " + helmet.method_7876() + (isPiglin ? "_piglin" : ""));
                    if (icon == this.textureAtlas.getMissingImage()) {
                        icon = this.createUnknownArmorIcons(contact, stack, helmet);
                    } else if (icon == this.textureAtlas.getFailedImage()) {
                        icon = null;
                    }
                }
                if (helmetArmor instanceof class_4057) {
                    class_4057 dyeableHelmetArmor = (class_4057)helmetArmor;
                    contact.setArmorColor(dyeableHelmetArmor.method_7800(stack));
                }
            } else if (helmet instanceof class_1747 && (icon = this.textureAtlas.getAtlasSprite("blockArmor " + (stateID = class_2248.method_9507((class_2680)(blockState = (block = (blockItem = (class_1747)helmet).method_7711()).method_9564()))))) == this.textureAtlas.getMissingImage() && (blockImage = VoxelConstants.getVoxelMapInstance().getColorManager().getBlockImage(blockState, stack, entity.method_37908(), 4.9473686f, -8.0f)) != null) {
                int width = blockImage.getWidth();
                int height = blockImage.getHeight();
                ImageUtils.eraseArea(blockImage, width / 2 - 15, height / 2 - 15, 30, 30, width, height);
                BufferedImage blockImageFront = VoxelConstants.getVoxelMapInstance().getColorManager().getBlockImage(blockState, stack, entity.method_37908(), 4.9473686f, 7.25f);
                blockImageFront = blockImageFront.getSubimage(width / 2 - 15, height / 2 - 15, 30, 30);
                ImageUtils.addImages(blockImage, blockImageFront, (float)width / 2.0f - 15.0f, (float)height / 2.0f - 15.0f, width, height);
                blockImageFront.flush();
                blockImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.trimCentered(blockImage)), this.options.outlines, true, 37.6f, 37.6f, 2);
                icon = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID, blockImage);
                this.newMobs = true;
            }
        }
        contact.armorIcon = icon;
    }

    private Sprite createUnknownArmorIcons(Contact contact, class_1799 stack, class_1792 helmet) {
        BufferedImage armorTexture;
        class_572<class_1309> modelBiped;
        Sprite icon = null;
        boolean isPiglin = contact.type == EnumMobs.PIGLIN || contact.type == EnumMobs.PIGLINZOMBIE;
        class_2960 resourceLocation = null;
        try {
            String materialName = ((class_1738)helmet).method_7686().method_7694();
            String domain = "minecraft";
            int sep = materialName.indexOf(58);
            if (sep != -1) {
                domain = materialName.substring(0, sep);
                materialName = materialName.substring(sep + 1);
            }
            String suffix = "";
            String resourcePath = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, materialName, 1, suffix);
            resourceLocation = new class_2960(resourcePath);
        }
        catch (RuntimeException materialName) {
            // empty catch block
        }
        float intendedWidth = 9.0f;
        float intendedHeight = 9.0f;
        if (isPiglin) {
            modelBiped = this.piglinArmorModel;
            intendedWidth = 11.5f;
        } else {
            modelBiped = this.bipedArmorModel;
        }
        if (modelBiped != null && resourceLocation != null) {
            ModelPartWithResourceLocation[] headBitsWithResourceLocation = new ModelPartWithResourceLocation[]{new ModelPartWithResourceLocation(modelBiped.field_3398, resourceLocation), new ModelPartWithResourceLocation(modelBiped.field_3394, resourceLocation)};
            this.drawModel(1.0f, 2, (class_1309)contact.entity, class_2350.field_11043, (class_3879)modelBiped, headBitsWithResourceLocation);
            BufferedImage armorImage = ImageUtils.createBufferedImageFromGLID(OpenGL.Utils.fboTextureId);
            armorImage = armorImage.getSubimage(200, 200, 112, 112);
            armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.trimCentered(armorImage)), this.options.outlines, true, intendedWidth * 4.0f, intendedHeight * 4.0f, 2);
            icon = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.method_7876() + (isPiglin ? "_piglin" : ""), armorImage);
            this.newMobs = true;
        }
        if (icon == null && resourceLocation != null && (armorTexture = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation)) != null) {
            if (!isPiglin) {
                armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                float scale = (float)armorTexture.getWidth() / 8.0f;
                BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 37.6f, 37.6f, 2);
                icon = this.textureAtlas.registerIconForBufferedImage("armor " + resourceLocation, armorImage);
            } else {
                armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                float scale = (float)armorTexture.getWidth() / 8.0f;
                BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 47.0f, 37.6f, 2);
                icon = this.textureAtlas.registerIconForBufferedImage("armor " + resourceLocation + "_piglin", armorImage);
            }
            this.newMobs = true;
        }
        if (icon == null) {
            VoxelConstants.getLogger().warn("can't get texture for custom armor type: " + helmet.getClass());
            this.textureAtlas.registerFailedIcon("armor " + helmet.method_7876() + helmet.getClass().getName());
        }
        return icon;
    }

    private String scrubCodes(String string) {
        return string.replaceAll("(\\xA7.)", "");
    }

    private EnumMobs getUnknownMobNeutrality(class_1297 entity) {
        class_1321 tameableEntity;
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof class_1321 && (tameableEntity = (class_1321)entity).method_6181() && (VoxelConstants.getMinecraft().method_1496() || tameableEntity.method_35057().equals((Object)VoxelConstants.getPlayer()))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private int getArmorType(class_1738 helmet) {
        return helmet.method_7876().equals("item.minecraft.leather_helmet") ? 0 : UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(class_332 drawContext, class_4587 matrixStack, int x, int y) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        double lastX = GameVariableAccessShim.xCoordDouble();
        double lastZ = GameVariableAccessShim.zCoordDouble();
        int lastY = GameVariableAccessShim.yCoord();
        for (Contact contact : this.contacts) {
            boolean inRange;
            RenderSystem.setShader(class_757::method_34542);
            OpenGL.Utils.disp2(this.textureAtlas.method_4624());
            OpenGL.glEnable(3042);
            OpenGL.glBlendFunc(770, 771);
            RenderSystem.setShader(class_757::method_34542);
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = lastX - contactX;
            double wayZ = lastZ - contactZ;
            int wayY = lastY - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY), 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            if (wayY < 0) {
                OpenGL.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                OpenGL.glColor3f(contact.brightness, contact.brightness, contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            if (!this.minimapOptions.squareMap) {
                inRange = contact.distance < 31.0;
            } else {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                boolean bl = inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            }
            if (!inRange) continue;
            try {
                matrixStack.method_22903();
                if (this.options.filtering) {
                    matrixStack.method_22904((double)x, (double)y, 0.0);
                    matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-contact.angle));
                    matrixStack.method_22904(0.0, -contact.distance, 0.0);
                    matrixStack.method_22907(class_7833.field_40718.rotationDegrees(contact.angle + (float)contact.rotationFactor));
                    matrixStack.method_22904((double)(-x), (double)(-y), 0.0);
                } else {
                    wayX = Math.sin(Math.toRadians(contact.angle)) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(contact.angle)) * contact.distance;
                    matrixStack.method_22904((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, (double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, 0.0);
                }
                RenderSystem.applyModelViewMatrix();
                float yOffset = 0.0f;
                if (contact.entity.method_5854() != null && this.isEntityShown(contact.entity.method_5854())) {
                    yOffset = -4.0f;
                }
                if (Stream.of(EnumMobs.GHAST, EnumMobs.GHASTATTACKING, EnumMobs.WITHER, EnumMobs.WITHERINVULNERABLE, EnumMobs.VEX, EnumMobs.VEXCHARGING, EnumMobs.PUFFERFISH, EnumMobs.PUFFERFISHHALF, EnumMobs.PUFFERFISHFULL).anyMatch(enumMobs -> contact.type == enumMobs)) {
                    if (contact.type != EnumMobs.GHAST && contact.type != EnumMobs.GHASTATTACKING) {
                        if (contact.type != EnumMobs.WITHER && contact.type != EnumMobs.WITHERINVULNERABLE) {
                            if (contact.type != EnumMobs.VEX && contact.type != EnumMobs.VEXCHARGING) {
                                int size = ((class_1454)contact.entity).method_6594();
                                switch (size) {
                                    case 0: {
                                        contact.type = EnumMobs.PUFFERFISH;
                                        break;
                                    }
                                    case 1: {
                                        contact.type = EnumMobs.PUFFERFISHHALF;
                                        break;
                                    }
                                    case 2: {
                                        contact.type = EnumMobs.PUFFERFISHFULL;
                                    }
                                }
                            } else {
                                class_897 render = VoxelConstants.getMinecraft().method_1561().method_3953(contact.entity);
                                String path = render.method_3931(contact.entity).method_12832();
                                contact.type = path.endsWith("vex_charging.png") ? EnumMobs.VEXCHARGING : EnumMobs.VEX;
                            }
                        } else {
                            class_897 render = VoxelConstants.getMinecraft().method_1561().method_3953(contact.entity);
                            String path = render.method_3931(contact.entity).method_12832();
                            contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                        }
                    } else {
                        class_897 render = VoxelConstants.getMinecraft().method_1561().method_3953(contact.entity);
                        String path = render.method_3931(contact.entity).method_12832();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                    }
                    this.tryAutoIcon(contact);
                    this.tryCustomIcon(contact);
                    if (this.newMobs) {
                        try {
                            this.textureAtlas.stitchNew();
                        }
                        catch (StitcherException var45) {
                            VoxelConstants.getLogger().warn("Stitcher exception in render method!  Resetting mobs texture atlas.");
                            this.loadTexturePackIcons();
                        }
                        OpenGL.Utils.disp2(this.textureAtlas.method_4624());
                    }
                    this.newMobs = false;
                }
                this.applyFilteringParameters();
                OpenGL.Utils.drawPre();
                OpenGL.Utils.setMap(contact.icon, x, (float)y + yOffset, (int)((float)contact.icon.getIconWidth() / 4.0f));
                OpenGL.Utils.drawPost();
                if ((this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) && contact.armorIcon != null) {
                    Sprite icon = contact.armorIcon;
                    float armorOffset = 0.0f;
                    if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                        armorOffset = -0.5f;
                    }
                    float armorScale = 1.0f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    if (contact.armorColor != -1) {
                        red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                        green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                        blue = (float)(contact.armorColor & 0xFF) / 255.0f;
                        if (contact.type == EnumMobs.SHEEP) {
                            class_1472 sheepEntity = (class_1472)contact.entity;
                            if (sheepEntity.method_16914() && "jeb_".equals(sheepEntity.method_5477().getString())) {
                                int semiRandom = sheepEntity.field_6012 / 25 + sheepEntity.method_5628();
                                int numDyeColors = class_1767.values().length;
                                int colorID1 = semiRandom % numDyeColors;
                                int colorID2 = (semiRandom + 1) % numDyeColors;
                                float lerpVal = ((float)(sheepEntity.field_6012 % 25) + VoxelConstants.getMinecraft().method_1488()) / 25.0f;
                                float[] sheepColors1 = class_1472.method_6634((class_1767)class_1767.method_7791((int)colorID1));
                                float[] sheepColors2 = class_1472.method_6634((class_1767)class_1767.method_7791((int)colorID2));
                                red = sheepColors1[0] * (1.0f - lerpVal) + sheepColors2[0] * lerpVal;
                                green = sheepColors1[1] * (1.0f - lerpVal) + sheepColors2[1] * lerpVal;
                                blue = sheepColors1[2] * (1.0f - lerpVal) + sheepColors2[2] * lerpVal;
                            }
                            armorScale = 1.04f;
                        }
                        if (wayY < 0) {
                            OpenGL.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            OpenGL.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                    }
                    this.applyFilteringParameters();
                    OpenGL.Utils.drawPre();
                    OpenGL.Utils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / 4.0f * armorScale));
                    OpenGL.Utils.drawPost();
                    if (icon == this.clothIcon) {
                        if (wayY < 0) {
                            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
                        } else {
                            OpenGL.glColor3f(contact.brightness, contact.brightness, contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[2]);
                        this.applyFilteringParameters();
                        OpenGL.Utils.drawPre();
                        OpenGL.Utils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale);
                        OpenGL.Utils.drawPost();
                        if (wayY < 0) {
                            OpenGL.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            OpenGL.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[1]);
                        this.applyFilteringParameters();
                        OpenGL.Utils.drawPre();
                        OpenGL.Utils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale * 40.0f / 37.0f);
                        OpenGL.Utils.drawPost();
                        OpenGL.glColor3f(1.0f, 1.0f, 1.0f);
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[3]);
                        this.applyFilteringParameters();
                        OpenGL.Utils.drawPre();
                        OpenGL.Utils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale * 40.0f / 37.0f);
                        OpenGL.Utils.drawPost();
                    }
                }
                if (contact.name == null || (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) && (!this.options.showMobNames || contact.type == EnumMobs.PLAYER)) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                matrixStack.method_22905(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
                RenderSystem.applyModelViewMatrix();
                String name = contact.entity.method_5476().getString();
                int m = VoxelConstants.getMinecraft().field_1772.method_1727(name) / 2;
                class_4587 textMatrixStack = drawContext.method_51448();
                textMatrixStack.method_22903();
                textMatrixStack.method_34426();
                textMatrixStack.method_46416(0.0f, 0.0f, 900.0f);
                drawContext.method_51433(VoxelConstants.getMinecraft().field_1772, name, (int)((float)x * scaleFactor - (float)m), (int)((float)(y + 3) * scaleFactor), -1, false);
                textMatrixStack.method_22909();
            }
            catch (Exception e) {
                VoxelConstants.getLogger().error("Error rendering mob icon! " + e.getLocalizedMessage() + " contact type " + contact.type, (Throwable)e);
            }
            finally {
                matrixStack.method_22909();
                RenderSystem.applyModelViewMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            OpenGL.glTexParameteri(3553, 10241, 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
            OpenGL.glTexParameteri(3553, 10242, 33071);
            OpenGL.glTexParameteri(3553, 10243, 33071);
        } else {
            OpenGL.glTexParameteri(3553, 10241, 9728);
            OpenGL.glTexParameteri(3553, 10240, 9728);
        }
    }

    private boolean isHostile(class_1297 entity) {
        if (entity instanceof class_1590) {
            class_1590 zombifiedPiglinEntity = (class_1590)entity;
            return zombifiedPiglinEntity.method_7076((class_1657)VoxelConstants.getPlayer());
        }
        if (entity instanceof class_1569) {
            return true;
        }
        if (entity instanceof class_4466) {
            class_4466 beeEntity = (class_4466)entity;
            return beeEntity.method_29511();
        }
        if (entity instanceof class_1456) {
            class_1456 polarBearEntity = (class_1456)entity;
            for (class_1456 object : polarBearEntity.method_37908().method_18467(class_1456.class, polarBearEntity.method_5829().method_1009(8.0, 4.0, 8.0))) {
                if (!object.method_6109()) continue;
                return true;
            }
        }
        if (entity instanceof class_1463) {
            class_1463 rabbitEntity = (class_1463)entity;
            return rabbitEntity.method_47855().method_47856() == 99;
        }
        if (entity instanceof class_1493) {
            class_1493 wolfEntity = (class_1493)entity;
            return wolfEntity.method_29511();
        }
        return false;
    }

    private boolean isPlayer(class_1297 entity) {
        return entity instanceof class_745;
    }

    private boolean isNeutral(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        return !(entity instanceof class_1657) && !this.isHostile(entity);
    }

    private record ModelPartWithResourceLocation(class_630 modelPart, class_2960 resourceLocation) {
    }
}

