/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.ISubSettingsManager;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import net.minecraft.class_1074;

public class RadarSettingsManager
implements ISubSettingsManager {
    private boolean somethingChanged;
    public int radarMode = 2;
    public boolean showRadar = true;
    public boolean showHostiles = true;
    public boolean showPlayers = true;
    public boolean showNeutrals;
    public boolean showPlayerNames = true;
    public boolean showMobNames = true;
    public boolean outlines = true;
    public boolean filtering = true;
    public boolean showHelmetsPlayers = true;
    public boolean showHelmetsMobs = true;
    public boolean showFacing = true;
    public boolean radarAllowed = true;
    public boolean radarPlayersAllowed = true;
    public boolean radarMobsAllowed = true;
    float fontScale = 1.0f;

    @Override
    public void loadSettings(File settingsFile) {
        try {
            String sCurrentLine;
            BufferedReader in = new BufferedReader(new FileReader(settingsFile));
            while ((sCurrentLine = in.readLine()) != null) {
                String[] curLine = sCurrentLine.split(":");
                switch (curLine[0]) {
                    case "Radar Mode": {
                        this.radarMode = Math.max(1, Math.min(2, Integer.parseInt(curLine[1])));
                        break;
                    }
                    case "Show Radar": {
                        this.showRadar = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Hostiles": {
                        this.showHostiles = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Players": {
                        this.showPlayers = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Neutrals": {
                        this.showNeutrals = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Filter Mob Icons": {
                        this.filtering = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Outline Mob Icons": {
                        this.outlines = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Player Helmets": {
                        this.showHelmetsPlayers = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Mob Helmets": {
                        this.showHelmetsMobs = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Player Names": {
                        this.showPlayerNames = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Mob Names": {
                        this.showMobNames = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Font Scale": {
                        this.fontScale = Float.parseFloat(curLine[1]);
                        break;
                    }
                    case "Show Facing": {
                        this.showFacing = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Hidden Mobs": {
                        this.applyHiddenMobSettings(curLine[1]);
                    }
                }
            }
            in.close();
        }
        catch (IOException | ArrayIndexOutOfBoundsException exception) {
            // empty catch block
        }
    }

    private void applyHiddenMobSettings(String hiddenMobs) {
        String[] mobsToHide;
        for (String s : mobsToHide = hiddenMobs.split(",")) {
            boolean builtIn = false;
            for (EnumMobs mob : EnumMobs.values()) {
                if (!mob.id.equals(s)) continue;
                mob.enabled = false;
                builtIn = true;
            }
            if (builtIn) continue;
            CustomMobsManager.add(s, false);
        }
    }

    @Override
    public void saveAll(PrintWriter out) {
        out.println("Radar Mode:" + this.radarMode);
        out.println("Show Radar:" + this.showRadar);
        out.println("Show Hostiles:" + this.showHostiles);
        out.println("Show Players:" + this.showPlayers);
        out.println("Show Neutrals:" + this.showNeutrals);
        out.println("Filter Mob Icons:" + this.filtering);
        out.println("Outline Mob Icons:" + this.outlines);
        out.println("Show Player Helmets:" + this.showHelmetsPlayers);
        out.println("Show Mob Helmets:" + this.showHelmetsMobs);
        out.println("Show Player Names:" + this.showPlayerNames);
        out.println("Show Mob Names:" + this.showMobNames);
        out.println("Font Scale:" + this.fontScale);
        out.println("Show Facing:" + this.showFacing);
        out.print("Hidden Mobs:");
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.isTopLevelUnit || mob.enabled) continue;
            out.print(mob.id + ",");
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if (mob.enabled) continue;
            out.print(mob.id + ",");
        }
        out.println();
    }

    @Override
    public String getKeyText(EnumOptionsMinimap options) {
        String s = class_1074.method_4662((String)options.getName(), (Object[])new Object[0]) + ": ";
        if (options.isBoolean()) {
            return this.getOptionBooleanValue(options) ? s + class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : s + class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
        }
        if (options.isList()) {
            String state = this.getOptionListValue(options);
            return s + state;
        }
        return s;
    }

    public boolean getOptionBooleanValue(EnumOptionsMinimap par1EnumOptions) {
        return switch (par1EnumOptions) {
            case EnumOptionsMinimap.SHOWRADAR -> this.showRadar;
            case EnumOptionsMinimap.SHOWHOSTILES -> this.showHostiles;
            case EnumOptionsMinimap.SHOWPLAYERS -> this.showPlayers;
            case EnumOptionsMinimap.SHOWNEUTRALS -> this.showNeutrals;
            case EnumOptionsMinimap.SHOWPLAYERHELMETS -> this.showHelmetsPlayers;
            case EnumOptionsMinimap.SHOWMOBHELMETS -> this.showHelmetsMobs;
            case EnumOptionsMinimap.SHOWPLAYERNAMES -> this.showPlayerNames;
            case EnumOptionsMinimap.SHOWMOBNAMES -> this.showMobNames;
            case EnumOptionsMinimap.RADAROUTLINES -> this.outlines;
            case EnumOptionsMinimap.RADARFILTERING -> this.filtering;
            case EnumOptionsMinimap.SHOWFACING -> this.showFacing;
            default -> throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a boolean)");
        };
    }

    public String getOptionListValue(EnumOptionsMinimap par1EnumOptions) {
        if (Objects.requireNonNull(par1EnumOptions) == EnumOptionsMinimap.RADARMODE) {
            if (this.radarMode == 2) {
                return class_1074.method_4662((String)"options.minimap.radar.radarmode.full", (Object[])new Object[0]);
            }
            return class_1074.method_4662((String)"options.minimap.radar.radarmode.simple", (Object[])new Object[0]);
        }
        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a list value applicable to minimap)");
    }

    @Override
    public void setOptionFloatValue(EnumOptionsMinimap options, float value) {
    }

    public void setOptionValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case SHOWRADAR: {
                this.showRadar = !this.showRadar;
                break;
            }
            case SHOWHOSTILES: {
                this.showHostiles = !this.showHostiles;
                break;
            }
            case SHOWPLAYERS: {
                this.showPlayers = !this.showPlayers;
                break;
            }
            case SHOWNEUTRALS: {
                this.showNeutrals = !this.showNeutrals;
                break;
            }
            case SHOWPLAYERHELMETS: {
                this.showHelmetsPlayers = !this.showHelmetsPlayers;
                break;
            }
            case SHOWMOBHELMETS: {
                this.showHelmetsMobs = !this.showHelmetsMobs;
                break;
            }
            case SHOWPLAYERNAMES: {
                this.showPlayerNames = !this.showPlayerNames;
                break;
            }
            case SHOWMOBNAMES: {
                this.showMobNames = !this.showMobNames;
                break;
            }
            case RADAROUTLINES: {
                this.outlines = !this.outlines;
                break;
            }
            case RADARFILTERING: {
                this.filtering = !this.filtering;
                break;
            }
            case SHOWFACING: {
                this.showFacing = !this.showFacing;
                break;
            }
            case RADARMODE: {
                if (this.radarMode == 2) {
                    this.radarMode = 1;
                    break;
                }
                this.radarMode = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName());
            }
        }
        this.somethingChanged = true;
    }

    public boolean isChanged() {
        if (this.somethingChanged) {
            this.somethingChanged = false;
            return true;
        }
        return false;
    }

    @Override
    public float getOptionFloatValue(EnumOptionsMinimap options) {
        return 0.0f;
    }
}

