/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.gson.Gson;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8674;

public class VoxelmapSettingsChannelHandler
implements ClientPlayNetworking.PlayChannelHandler,
ClientConfigurationNetworking.ConfigurationChannelHandler {
    private static final class_2960 CHANNEL_IDENTIFIER = new class_2960("voxelmap", "settings");

    public VoxelmapSettingsChannelHandler() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_IDENTIFIER, (ClientPlayNetworking.PlayChannelHandler)this);
        ClientConfigurationNetworking.registerGlobalReceiver((class_2960)CHANNEL_IDENTIFIER, (ClientConfigurationNetworking.ConfigurationChannelHandler)this);
    }

    public void receive(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
        this.parsePacket(client, buffer);
    }

    public void receive(class_310 client, class_8674 handler, class_2540 buffer, PacketSender responseSender) {
        this.parsePacket(client, buffer);
    }

    private void parsePacket(class_310 client, class_2540 buffer) {
        buffer.readByte();
        Map settings = (Map)new Gson().fromJson(buffer.method_19772(), Map.class);
        block16: for (Map.Entry entry : settings.entrySet()) {
            String setting = (String)entry.getKey();
            Object value = entry.getValue();
            switch (setting) {
                case "worldName": {
                    if (value instanceof String) {
                        String worldName = (String)value;
                        client.execute(() -> {
                            VoxelConstants.getLogger().info("Received world name from settings: " + worldName);
                            VoxelConstants.getVoxelMapInstance().newSubWorldName(worldName, true);
                        });
                        continue block16;
                    }
                    VoxelConstants.getLogger().warn("Invalid world name: " + value);
                    continue block16;
                }
                case "radarAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarAllowed = (Boolean)value;
                    continue block16;
                }
                case "radarMobsAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarMobsAllowed = (Boolean)value;
                    continue block16;
                }
                case "radarPlayersAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarPlayersAllowed = (Boolean)value;
                    continue block16;
                }
                case "cavesAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().cavesAllowed = (Boolean)value;
                    continue block16;
                }
                case "teleportCommand": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().serverTeleportCommand = (String)value;
                    continue block16;
                }
            }
            VoxelConstants.getLogger().warn("Unknown configuration option " + setting);
        }
    }
}

