/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import java.nio.charset.StandardCharsets;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8674;

public class VoxelmapWorldIdChannelHandler
implements ClientPlayNetworking.PlayChannelHandler,
ClientConfigurationNetworking.ConfigurationChannelHandler {
    private static final class_2960 CHANNEL_IDENTIFIER = new class_2960("worldinfo", "world_id");

    public VoxelmapWorldIdChannelHandler() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_IDENTIFIER, (ClientPlayNetworking.PlayChannelHandler)this);
        ClientConfigurationNetworking.registerGlobalReceiver((class_2960)CHANNEL_IDENTIFIER, (ClientConfigurationNetworking.ConfigurationChannelHandler)this);
    }

    public void receive(class_310 client, class_634 handler, class_2540 buffer, PacketSender responseSender) {
        this.parsePacket(client, buffer);
    }

    public void receive(class_310 client, class_8674 handler, class_2540 buffer, PacketSender responseSender) {
        this.parsePacket(client, buffer);
    }

    private void parsePacket(class_310 client, class_2540 buffer) {
        byte length;
        buffer.readByte();
        byte b = buffer.readByte();
        if (b == 42) {
            length = buffer.readByte();
        } else {
            if (b == 0) {
                VoxelConstants.getLogger().warn("Received unknown world_id packet");
                return;
            }
            VoxelConstants.getLogger().warn("Assuming legacy world_id packet. The support might be removed in the future versions.");
            length = b;
        }
        byte[] bytes = new byte[length];
        buffer.method_52979(bytes);
        String subWorldName = new String(bytes, StandardCharsets.UTF_8);
        client.execute(() -> {
            VoxelConstants.getLogger().info("Received world_id: " + subWorldName);
            VoxelConstants.getVoxelMapInstance().newSubWorldName(subWorldName, true);
        });
    }
}

