/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiSlotDimensions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_757;

public class GuiAddWaypoint
extends GuiScreenMinimap
implements IPopupGuiScreen {
    final WaypointManager waypointManager;
    final ColorManager colorManager;
    private final IGuiWaypoints parentGui;
    private PopupGuiButton doneButton;
    private GuiSlotDimensions dimensionList;
    protected DimensionContainer selectedDimension;
    private class_2561 tooltip;
    private class_342 waypointName;
    private class_342 waypointX;
    private class_342 waypointZ;
    private class_342 waypointY;
    private PopupGuiButton buttonEnabled;
    protected final Waypoint waypoint;
    private boolean choosingColor;
    private boolean choosingIcon;
    private final float red;
    private final float green;
    private final float blue;
    private final String suffix;
    private final boolean enabled;
    private final boolean editing;
    private final class_2960 pickerResourceLocation = new class_2960("voxelmap", "images/colorpicker.png");
    private final class_2960 blank = new class_2960("textures/misc/white.png");

    public GuiAddWaypoint(IGuiWaypoints par1GuiScreen, Waypoint par2Waypoint, boolean editing) {
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.parentGui = par1GuiScreen;
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.suffix = this.waypoint.imageSuffix;
        this.enabled = this.waypoint.enabled;
        this.editing = editing;
    }

    public void method_25393() {
    }

    public void method_25426() {
        this.method_37067();
        this.waypointName = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 13, 200, 20, null);
        this.waypointName.method_1852(this.waypoint.name);
        this.waypointX = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointX.method_1880(128);
        this.waypointX.method_1852(String.valueOf(this.waypoint.getX()));
        this.waypointZ = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointZ.method_1880(128);
        this.waypointZ.method_1852(String.valueOf(this.waypoint.getZ()));
        this.waypointY = new class_342(this.getFontRenderer(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointY.method_1880(128);
        this.waypointY.method_1852(String.valueOf(this.waypoint.getY()));
        this.method_37063((class_364)this.waypointName);
        this.method_37063((class_364)this.waypointX);
        this.method_37063((class_364)this.waypointZ);
        this.method_37063((class_364)this.waypointY);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.buttonEnabled = new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY, 100, 20, (class_2561)class_2561.method_43470((String)("Enabled: " + (this.waypoint.enabled ? "On" : "Off"))), button -> {
            this.waypoint.enabled = !this.waypoint.enabled;
        }, this);
        this.method_37063((class_364)this.buttonEnabled);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 24, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortbycolor", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingColor = true;
        }, this));
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 48, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortbyicon", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingIcon = true;
        }, this));
        this.doneButton = new PopupGuiButton(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, (class_2561)class_2561.method_43471((String)"addServer.add"), button -> this.acceptWaypoint(), this);
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.cancelWaypoint(), this));
        this.doneButton.field_22763 = !this.waypointName.method_1882().isEmpty();
        this.method_25395((class_364)this.waypointName);
        this.waypointName.method_25365(true);
        this.dimensionList = new GuiSlotDimensions(this);
    }

    @Override
    public void method_25432() {
    }

    protected void cancelWaypoint() {
        this.waypoint.red = this.red;
        this.waypoint.green = this.green;
        this.waypoint.blue = this.blue;
        this.waypoint.imageSuffix = this.suffix;
        this.waypoint.enabled = this.enabled;
        if (this.parentGui != null) {
            this.parentGui.accept(false);
            return;
        }
        VoxelConstants.getMinecraft().method_1507(null);
    }

    protected void acceptWaypoint() {
        this.waypoint.name = this.waypointName.method_1882();
        this.waypoint.setX(Integer.parseInt(this.waypointX.method_1882()));
        this.waypoint.setZ(Integer.parseInt(this.waypointZ.method_1882()));
        this.waypoint.setY(Integer.parseInt(this.waypointY.method_1882()));
        if (this.parentGui != null) {
            this.parentGui.accept(true);
            return;
        }
        if (this.editing) {
            this.waypointManager.saveWaypoints();
            VoxelConstants.getMinecraft().method_1507(null);
            return;
        }
        this.waypointManager.addWaypoint(this.waypoint);
        VoxelConstants.getMinecraft().method_1507(null);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean OK = false;
        if (this.popupOpen()) {
            OK = super.method_25404(keyCode, scanCode, modifiers);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
            }
            catch (NumberFormatException var7) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
            if ((keyCode == 257 || keyCode == 335) && acceptable) {
                this.acceptWaypoint();
            }
        }
        return OK;
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean OK = false;
        if (this.popupOpen()) {
            OK = super.method_25400(chr, modifiers);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
            }
            catch (NumberFormatException var6) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
        }
        return OK;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popupOpen()) {
            super.method_25402(mouseX, mouseY, button);
            this.waypointName.method_25402(mouseX, mouseY, button);
            this.waypointX.method_25402(mouseX, mouseY, button);
            this.waypointZ.method_25402(mouseX, mouseY, button);
            this.waypointY.method_25402(mouseX, mouseY, button);
        } else if (this.choosingColor) {
            if (mouseX >= (double)((float)this.getWidth() / 2.0f - 128.0f) && mouseX < (double)((float)this.getWidth() / 2.0f + 128.0f) && mouseY >= (double)((float)this.getHeight() / 2.0f - 128.0f) && mouseY < (double)((float)this.getHeight() / 2.0f + 128.0f)) {
                int color = this.colorManager.getColorPicker().getRGB((int)mouseX - (this.getWidth() / 2 - 128), (int)mouseY - (this.getHeight() / 2 - 128));
                this.waypoint.red = (float)(color >> 16 & 0xFF) / 255.0f;
                this.waypoint.green = (float)(color >> 8 & 0xFF) / 255.0f;
                this.waypoint.blue = (float)(color & 0xFF) / 255.0f;
                this.choosingColor = false;
            }
        } else if (this.choosingIcon) {
            float y;
            float x;
            Sprite icon;
            float adj;
            float scScale = (float)VoxelConstants.getMinecraft().method_22683().method_4495();
            TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)VoxelConstants.getMinecraft().method_22683().method_4489()) {
                adj = displayWidthFloat / (float)VoxelConstants.getMinecraft().method_22683().method_4489();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)VoxelConstants.getMinecraft().method_22683().method_4506()) {
                adj = displayHeightFloat / (float)VoxelConstants.getMinecraft().method_22683().method_4506();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            if (mouseX >= (double)((float)this.getWidth() / 2.0f - (float)displayWidth / 2.0f) && mouseX < (double)((float)this.getWidth() / 2.0f + (float)displayWidth / 2.0f) && mouseY >= (double)((float)this.getHeight() / 2.0f - (float)displayHeight / 2.0f) && mouseY < (double)((float)this.getHeight() / 2.0f + (float)displayHeight / 2.0f) && (icon = chooser.getIconAt(x = ((float)mouseX - ((float)this.getWidth() / 2.0f - (float)displayWidth / 2.0f)) * scale, y = ((float)mouseY - ((float)this.getHeight() / 2.0f - (float)displayHeight / 2.0f)) * scale)) != chooser.getMissingImage()) {
                this.waypoint.imageSuffix = icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
                this.choosingIcon = false;
            }
        }
        if (this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25406(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return !this.popupOpen() || this.dimensionList == null || this.dimensionList.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        return !this.popupOpen() || this.dimensionList == null || this.dimensionList.method_25401(mouseX, mouseY, 0.0, amount);
    }

    @Override
    public boolean overPopup(int mouseX, int mouseY) {
        return !this.choosingColor && !this.choosingIcon;
    }

    @Override
    public boolean popupOpen() {
        return !this.choosingColor && !this.choosingIcon;
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.drawMap(drawContext);
        float scScale = (float)VoxelConstants.getMinecraft().method_22683().method_4495();
        this.tooltip = null;
        this.buttonEnabled.method_25355((class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.enabled", (Object[])new Object[0]) + " " + (this.waypoint.enabled ? class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : class_1074.method_4662((String)"options.off", (Object[])new Object[0])))));
        if (!this.choosingColor && !this.choosingIcon) {
            this.method_52752(drawContext);
        }
        this.dimensionList.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_25300(this.getFontRenderer(), (this.parentGui == null || !this.parentGui.isEditing()) && !this.editing ? class_1074.method_4662((String)"minimap.waypoints.new", (Object[])new Object[0]) : class_1074.method_4662((String)"minimap.waypoints.edit", (Object[])new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"minimap.waypoints.name", (Object[])new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6, 0xA0A0A0);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"X", (Object[])new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41, 0xA0A0A0);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"Z", (Object[])new Object[0]), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41, 0xA0A0A0);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"Y", (Object[])new Object[0]), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41, 0xA0A0A0);
        this.waypointName.method_25394(drawContext, mouseX, mouseY, delta);
        this.waypointX.method_25394(drawContext, mouseX, mouseY, delta);
        this.waypointZ.method_25394(drawContext, mouseX, mouseY, delta);
        this.waypointY.method_25394(drawContext, mouseX, mouseY, delta);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        super.method_25394(drawContext, mouseX, mouseY, delta);
        OpenGL.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.blank);
        drawContext.method_25302(this.blank, this.getWidth() / 2 - 25, buttonListY + 24 + 5, 0, 0, 16, 10);
        TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
        RenderSystem.setShader(class_757::method_34542);
        OpenGL.Utils.disp2(chooser.method_4624());
        OpenGL.glTexParameteri(3553, 10241, 9729);
        Sprite icon = chooser.getAtlasSprite("voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png");
        this.drawTexturedModalRect((float)this.getWidth() / 2.0f - 25.0f, buttonListY + 48 + 2, icon, 16.0f, 16.0f);
        if (this.choosingColor || this.choosingIcon) {
            this.method_52752(drawContext);
        }
        if (this.choosingColor) {
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            OpenGL.Utils.img2(this.pickerResourceLocation);
            OpenGL.glTexParameteri(3553, 10241, 9728);
            RenderSystem.disableDepthTest();
            drawContext.method_25302(this.pickerResourceLocation, this.getWidth() / 2 - 128, this.getHeight() / 2 - 128, 0, 0, 256, 256);
            RenderSystem.enableDepthTest();
        }
        if (this.choosingIcon) {
            float y;
            float x;
            float adj;
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)VoxelConstants.getMinecraft().method_22683().method_4489()) {
                adj = displayWidthFloat / (float)VoxelConstants.getMinecraft().method_22683().method_4489();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)VoxelConstants.getMinecraft().method_22683().method_4506()) {
                adj = displayHeightFloat / (float)VoxelConstants.getMinecraft().method_22683().method_4506();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.blank);
            OpenGL.glTexParameteri(3553, 10241, 9728);
            OpenGL.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
            drawContext.method_25302(this.blank, this.getWidth() / 2 - displayWidth / 2 - 1, this.getHeight() / 2 - displayHeight / 2 - 1, 0, 0, displayWidth + 2, displayHeight + 2);
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            drawContext.method_25302(this.blank, this.getWidth() / 2 - displayWidth / 2, this.getHeight() / 2 - displayHeight / 2, 0, 0, displayWidth, displayHeight);
            OpenGL.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
            OpenGL.glEnable(3042);
            RenderSystem.setShader(class_757::method_34542);
            OpenGL.Utils.disp2(chooser.method_4624());
            OpenGL.glTexParameteri(3553, 10241, 9729);
            this.drawTexturedModalRect((float)this.getWidth() / 2.0f - (float)displayWidth / 2.0f, (float)this.getHeight() / 2.0f - (float)displayHeight / 2.0f, displayWidth, displayHeight);
            if (mouseX >= this.getWidth() / 2 - displayWidth / 2 && mouseX <= this.getWidth() / 2 + displayWidth / 2 && mouseY >= this.getHeight() / 2 - displayHeight / 2 && mouseY <= this.getHeight() / 2 + displayHeight / 2 && (icon = chooser.getIconAt(x = ((float)mouseX - ((float)this.getWidth() / 2.0f - (float)displayWidth / 2.0f)) * scale, y = ((float)mouseY - ((float)this.getHeight() / 2.0f - (float)displayHeight / 2.0f)) * scale)) != chooser.getMissingImage()) {
                this.tooltip = class_2561.method_43470((String)icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", ""));
            }
            RenderSystem.enableDepthTest();
            OpenGL.glDisable(3042);
            OpenGL.glTexParameteri(3553, 10241, 9728);
        }
        if (this.tooltip != null) {
            this.renderTooltip(drawContext, this.tooltip, mouseX, mouseY);
        }
    }

    public void setSelectedDimension(DimensionContainer dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension) && this.selectedDimension != VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908())) {
            this.waypoint.dimensions.remove(this.selectedDimension);
        } else {
            this.waypoint.dimensions.add(this.selectedDimension);
        }
    }

    static void setTooltip(GuiAddWaypoint par0GuiWaypoint, class_2561 par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        vertexbuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + heightIn), 0.0).method_22913(icon.getMinU(), icon.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), 0.0).method_22913(icon.getMaxU(), icon.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + 0.0f), 0.0).method_22913(icon.getMaxU(), icon.getMinV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), 0.0).method_22913(icon.getMinU(), icon.getMinV()).method_1344();
        tessellator.method_1350();
    }

    public void drawTexturedModalRect(float x, float y, float width, float height) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + height), 0.0).method_22913(0.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22913(1.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + 0.0f), 0.0).method_22913(1.0f, 0.0f).method_1344();
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + 0.0f), 0.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
    }
}

