/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;

class GuiSlotWaypoints
extends GuiSlotMinimap {
    private final ArrayList<WaypointItem> waypoints;
    private ArrayList<?> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";
    static final class_2561 ENABLE = class_2561.method_43471((String)"minimap.waypoints.enable");
    static final class_2561 DISABLE = class_2561.method_43471((String)"minimap.waypoints.disable");
    final class_2960 visibleIconIdentifier = new class_2960("textures/mob_effect/night_vision.png");
    final class_2960 invisibleIconIdentifier = new class_2960("textures/mob_effect/blindness.png");

    GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 90 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(new WaypointItem(this.parentGui, pt));
        }
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        this.waypointsFiltered.forEach(x -> this.method_25321((class_350.class_351)x));
    }

    public void setSelected(WaypointItem entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.method_25334() instanceof WaypointItem) {
            class_333 narratorManager = new class_333(VoxelConstants.getMinecraft());
            narratorManager.method_19788(class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{((WaypointItem)this.method_25334()).waypoint.name}).getString());
        }
        this.parentGui.setSelectedWaypoint(entry.waypoint);
    }

    protected boolean method_25332(int index) {
        return ((WaypointItem)this.waypointsFiltered.get((int)index)).waypoint.equals(this.parentGui.selectedWaypoint);
    }

    protected int method_25317() {
        return this.method_25340() * this.field_22741;
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, Sprite textureSprite, int widthIn, int heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        vertexbuffer.method_22912((double)xCoord, (double)(yCoord + heightIn), 1.0).method_22913(textureSprite.getMinU(), textureSprite.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).method_22913(textureSprite.getMaxU(), textureSprite.getMaxV()).method_1344();
        vertexbuffer.method_22912((double)(xCoord + widthIn), (double)yCoord, 1.0).method_22913(textureSprite.getMaxU(), textureSprite.getMinV()).method_1344();
        vertexbuffer.method_22912((double)xCoord, (double)yCoord, 1.0).method_22913(textureSprite.getMinU(), textureSprite.getMinV()).method_1344();
        tessellator.method_1350();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        int order;
        int n = order = ascending ? 1 : -1;
        if (sortKey == 1) {
            ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> Double.compare(masterWaypointsList.indexOf(waypointEntry1.waypoint), masterWaypointsList.indexOf(waypointEntry2.waypoint)) * order);
        } else if (sortKey == 3) {
            if (ascending) {
                Collections.sort(this.waypoints);
            } else {
                this.waypoints.sort(Collections.reverseOrder());
            }
        } else if (sortKey == 2) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> String.CASE_INSENSITIVE_ORDER.compare(waypointEntry1.waypoint.name, waypointEntry2.waypoint.name) * order);
        } else if (sortKey == 4) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> {
                Waypoint waypoint1 = waypointEntry1.waypoint;
                Waypoint waypoint2 = waypointEntry2.waypoint;
                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                return Double.compare(hue1, hue2) * order;
            });
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        Iterator<?> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = ((WaypointItem)iterator.next()).waypoint;
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
        this.waypointsFiltered.forEach(x -> this.method_25321((class_350.class_351)x));
    }

    public class WaypointItem
    extends class_350.class_351<WaypointItem>
    implements Comparable<WaypointItem> {
        private final GuiWaypoints parentGui;
        private final Waypoint waypoint;

        protected WaypointItem(GuiWaypoints waypointScreen, Waypoint waypoint) {
            this.parentGui = waypointScreen;
            this.waypoint = waypoint;
        }

        public void method_25343(class_332 drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            drawContext.method_25300(this.parentGui.getFontRenderer(), this.waypoint.name, this.parentGui.getWidth() / 2, y + 3, this.waypoint.getUnifiedColor());
            int padding = 3;
            if (mouseX >= x - padding && mouseY >= y && mouseX <= x + 215 + padding && mouseY <= y + entryHeight) {
                class_2561 tooltip;
                if (mouseX >= x + 215 - 16 - padding && mouseX <= x + 215 + padding) {
                    tooltip = this.waypoint.enabled ? DISABLE : ENABLE;
                } else {
                    String tooltipText = "X: " + this.waypoint.getX() + " Z: " + this.waypoint.getZ();
                    if (this.waypoint.getY() > ((GuiSlotWaypoints)GuiSlotWaypoints.this).field_22740.field_1687.method_31607()) {
                        tooltipText = tooltipText + " Y: " + this.waypoint.getY();
                    }
                    tooltip = class_2561.method_43470((String)tooltipText);
                }
                if (mouseX >= GuiSlotWaypoints.this.method_46426() && mouseX <= GuiSlotWaypoints.this.method_55442() && mouseY >= GuiSlotWaypoints.this.method_46427() && mouseY <= GuiSlotWaypoints.this.method_55443()) {
                    GuiWaypoints.setTooltip(GuiSlotWaypoints.this.parentGui, tooltip);
                }
            }
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            OpenGL.Utils.img2(this.waypoint.enabled ? GuiSlotWaypoints.this.visibleIconIdentifier : GuiSlotWaypoints.this.invisibleIconIdentifier);
            drawContext.method_25291(this.waypoint.enabled ? GuiSlotWaypoints.this.visibleIconIdentifier : GuiSlotWaypoints.this.invisibleIconIdentifier, x + 198, y - 2, 0, 0.0f, 0.0f, 18, 18, 18, 18);
            if (this.waypoint == this.parentGui.highlightedWaypoint) {
                int x1 = x + 199;
                int y1 = y - 1;
                OpenGL.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
                TextureAtlas textureAtlas = this.parentGui.waypointManager.getTextureAtlas();
                OpenGL.Utils.disp(textureAtlas.method_4624());
                Sprite icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png");
                GuiSlotWaypoints.this.drawTexturedModalRect(x1, y1, icon, 16, 16);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            GuiSlotWaypoints.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                if (GuiSlotWaypoints.this.doubleclick) {
                    this.parentGui.setHighlightedWaypoint();
                }
                this.parentGui.toggleWaypointVisibility();
            } else if (GuiSlotWaypoints.this.doubleclick) {
                this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            }
            return true;
        }

        @Override
        public int compareTo(WaypointItem o) {
            return this.waypoint.compareTo(o.waypoint);
        }
    }
}

