/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.fabricmod.FabricModVoxelMap;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final class_437 parentScreen;
    protected final MapSettingsManager options;
    protected final WaypointManager waypointManager;
    protected class_2561 screenTitle;
    private GuiSlotWaypoints waypointList;
    private class_4185 buttonEdit;
    private boolean editClicked;
    private class_4185 buttonDelete;
    private boolean deleteClicked;
    private class_4185 buttonHighlight;
    private class_4185 buttonShare;
    private class_4185 buttonTeleport;
    private class_4185 buttonSortName;
    private class_4185 buttonSortCreated;
    private class_4185 buttonSortDistance;
    private class_4185 buttonSortColor;
    protected class_342 filter;
    private boolean addClicked;
    private class_2561 tooltip;
    protected Waypoint selectedWaypoint;
    protected Waypoint highlightedWaypoint;
    protected Waypoint newWaypoint;
    private final Random generator = new Random();
    private boolean changedSort;

    public GuiWaypoints(class_437 parentScreen) {
        this.parentScreen = parentScreen;
        this.options = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void method_25393() {
    }

    public void method_25426() {
        boolean isSomethingSelected;
        this.screenTitle = class_2561.method_43471((String)"minimap.waypoints.title");
        this.waypointList = new GuiSlotWaypoints(this);
        this.buttonSortName = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbyname"), button -> this.sortClicked(2)).method_46434(this.getWidth() / 2 - 154, 34, 77, 20).method_46431();
        this.method_37063((class_364)this.buttonSortName);
        this.buttonSortDistance = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbydistance"), button -> this.sortClicked(3)).method_46434(this.getWidth() / 2 - 77, 34, 77, 20).method_46431();
        this.method_37063((class_364)this.buttonSortDistance);
        this.buttonSortCreated = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbycreated"), button -> this.sortClicked(1)).method_46434(this.getWidth() / 2, 34, 77, 20).method_46431();
        this.method_37063((class_364)this.buttonSortCreated);
        this.buttonSortColor = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbycolor"), button -> this.sortClicked(4)).method_46434(this.getWidth() / 2 + 77, 34, 77, 20).method_46431();
        this.method_37063((class_364)this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().method_1727(class_1074.method_4662((String)"minimap.waypoints.filter", (Object[])new Object[0]) + ":");
        this.filter = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20, null);
        this.filter.method_1880(35);
        this.method_37063((class_364)this.filter);
        this.buttonEdit = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"selectServer.edit"), button -> this.editWaypoint(this.selectedWaypoint)).method_46434(this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20).method_46431();
        this.method_37063((class_364)this.buttonEdit);
        this.buttonDelete = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"selectServer.delete"), button -> this.deleteClicked()).method_46434(this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20).method_46431();
        this.method_37063((class_364)this.buttonDelete);
        this.buttonHighlight = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.highlight"), button -> this.setHighlightedWaypoint()).method_46434(this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20).method_46431();
        this.method_37063((class_364)this.buttonHighlight);
        this.buttonTeleport = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.teleportto"), button -> this.teleportClicked()).method_46434(this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20).method_46431();
        this.method_37063((class_364)this.buttonTeleport);
        this.buttonShare = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.share"), button -> CommandUtils.sendWaypoint(this.selectedWaypoint)).method_46434(this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20).method_46431();
        this.method_37063((class_364)this.buttonShare);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"minimap.waypoints.newwaypoint"), button -> this.addWaypoint()).method_46434(this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"menu.options"), button -> VoxelConstants.getMinecraft().method_1507((class_437)new GuiWaypointsOptions(this, this.options))).method_46434(this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> VoxelConstants.getMinecraft().method_1507(this.parentScreen)).method_46434(this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20).method_46431());
        this.method_25395((class_364)this.filter);
        this.filter.method_25365(true);
        this.buttonEdit.field_22763 = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_22763 = isSomethingSelected;
        this.buttonHighlight.field_22763 = isSomethingSelected;
        this.buttonShare.field_22763 = isSomethingSelected;
        this.buttonTeleport.field_22763 = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        String arrow;
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String string = arrow = ascending ? "\u2191" : "\u2193";
        if (sortKey == 2) {
            this.buttonSortName.method_25355((class_2561)class_2561.method_43470((String)(arrow + " " + class_1074.method_4662((String)"minimap.waypoints.sortbyname", (Object[])new Object[0]) + " " + arrow)));
        } else {
            this.buttonSortName.method_25355((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbyname"));
        }
        if (sortKey == 3) {
            this.buttonSortDistance.method_25355((class_2561)class_2561.method_43470((String)(arrow + " " + class_1074.method_4662((String)"minimap.waypoints.sortbydistance", (Object[])new Object[0]) + " " + arrow)));
        } else {
            this.buttonSortDistance.method_25355((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbydistance"));
        }
        if (sortKey == 1) {
            this.buttonSortCreated.method_25355((class_2561)class_2561.method_43470((String)(arrow + " " + class_1074.method_4662((String)"minimap.waypoints.sortbycreated", (Object[])new Object[0]) + " " + arrow)));
        } else {
            this.buttonSortCreated.method_25355((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbycreated"));
        }
        if (sortKey == 4) {
            this.buttonSortColor.method_25355((class_2561)class_2561.method_43470((String)(arrow + " " + class_1074.method_4662((String)"minimap.waypoints.sortbycolor", (Object[])new Object[0]) + " " + arrow)));
        } else {
            this.buttonSortColor.method_25355((class_2561)class_2561.method_43471((String)"minimap.waypoints.sortbycolor"));
        }
    }

    private void deleteClicked() {
        String var2 = this.selectedWaypoint.name;
        if (var2 != null) {
            this.deleteClicked = true;
            class_5250 title = class_2561.method_43471((String)"minimap.waypoints.deleteconfirm");
            class_5250 explanation = class_2561.method_43469((String)"selectServer.deleteWarning", (Object[])new Object[]{var2});
            class_5250 affirm = class_2561.method_43471((String)"selectServer.deleteButton");
            class_5250 deny = class_2561.method_43471((String)"gui.cancel");
            class_410 confirmScreen = new class_410((BooleanConsumer)this, (class_2561)title, (class_2561)explanation, (class_2561)affirm, (class_2561)deny);
            VoxelConstants.getMinecraft().method_1507((class_437)confirmScreen);
        }
    }

    private void teleportClicked() {
        int y = this.selectedWaypoint.getY() > VoxelConstants.getPlayer().method_37908().method_31607() ? this.selectedWaypoint.getY() : (!VoxelConstants.getPlayer().method_37908().method_8597().comp_643() ? VoxelConstants.getPlayer().method_37908().method_31600() : 64);
        FabricModVoxelMap.instance.playerRunTeleportCommand(this.selectedWaypoint.getX(), y, this.selectedWaypoint.getZ());
        VoxelConstants.getMinecraft().method_1507(null);
    }

    protected void sortClicked(int id) {
        this.options.setSort(id);
        this.changedSort = true;
        this.sort();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean OK = super.method_25404(keyCode, scanCode, modifiers);
        if (this.filter.method_25370()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean OK = super.method_25400(chr, modifiers);
        if (this.filter.method_25370()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.waypointList.method_25402(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.waypointList.method_25406(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.waypointList.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        return this.waypointList.method_25401(mouseX, mouseY, 0.0, amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean b) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (b) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            VoxelConstants.getMinecraft().method_1507((class_437)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (b) {
                this.waypointManager.saveWaypoints();
            }
            VoxelConstants.getMinecraft().method_1507((class_437)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (b) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            VoxelConstants.getMinecraft().method_1507((class_437)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.field_22763 = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_22763 = isSomethingSelected;
        this.buttonHighlight.field_22763 = isSomethingSelected;
        this.buttonHighlight.method_25355((class_2561)class_2561.method_43471((String)(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight")));
        this.buttonShare.field_22763 = isSomethingSelected;
        this.buttonTeleport.field_22763 = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.method_25355((class_2561)class_2561.method_43471((String)(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight")));
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        VoxelConstants.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().isEmpty()) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908()));
        double dimensionScale = VoxelConstants.getPlayer().method_37908().method_8597().comp_646();
        this.newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        VoxelConstants.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.drawMap(drawContext);
        this.tooltip = null;
        this.waypointList.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_27534(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"minimap.waypoints.filter", (Object[])new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 75, 0xA0A0A0);
        this.filter.method_25394(drawContext, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            this.renderTooltip(drawContext, this.tooltip, mouseX, mouseY);
        }
    }

    static void setTooltip(GuiWaypoints par0GuiWaypoints, class_2561 par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
    }

    public boolean canTeleport() {
        Optional<class_1132> integratedServer = VoxelConstants.getIntegratedServer();
        if (integratedServer.isEmpty()) {
            return true;
        }
        try {
            return integratedServer.get().method_3760().method_14569(VoxelConstants.getPlayer().method_7334());
        }
        catch (RuntimeException exception) {
            return integratedServer.get().method_27728().method_194();
        }
    }

    @Override
    public void method_25432() {
        if (this.changedSort) {
            super.method_25432();
        }
    }
}

