/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.CompressionUtils;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.zip.DataFormatException;

public class CompressibleGLBufferedImage {
    private byte[] bytes;
    private int index;
    private final int width;
    private final int height;
    private final Object bufferLock = new Object();
    private boolean isCompressed;
    private static final HashMap<Integer, ByteBuffer> byteBuffers = new HashMap(4);
    private static final ByteBuffer defaultSizeBuffer = ByteBuffer.allocateDirect(262144).order(ByteOrder.nativeOrder());
    private final boolean compressNotDelete;

    public CompressibleGLBufferedImage(int width, int height, int imageType) {
        this.width = width;
        this.height = height;
        this.bytes = new byte[width * height * 4];
        this.compressNotDelete = VoxelConstants.getVoxelMapInstance().getPersistentMapOptions().outputImages;
    }

    public byte[] getData() {
        if (this.isCompressed) {
            this.decompress();
        }
        return this.bytes;
    }

    public int getIndex() {
        return this.index;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void baleet() {
        int currentIndex = this.index;
        this.index = 0;
        if (currentIndex != 0 && RenderSystem.isOnRenderThreadOrInit()) {
            OpenGL.glDeleteTexture(currentIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        ByteBuffer buffer;
        if (this.isCompressed) {
            this.decompress();
        }
        if (this.index == 0) {
            this.index = OpenGL.glGenTextures();
        }
        if ((buffer = byteBuffers.get(this.width * this.height)) == null) {
            buffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
            byteBuffers.put(this.width * this.height, buffer);
        }
        buffer.clear();
        Object object = this.bufferLock;
        synchronized (object) {
            buffer.put(this.bytes);
        }
        buffer.position(0).limit(this.bytes.length);
        OpenGL.glBindTexture(3553, this.index);
        OpenGL.glTexParameteri(3553, 10241, 9728);
        OpenGL.glTexParameteri(3553, 10240, 9728);
        OpenGL.glTexParameteri(3553, 10242, 33071);
        OpenGL.glTexParameteri(3553, 10243, 33071);
        OpenGL.glPixelStorei(3314, 0);
        OpenGL.glPixelStorei(3316, 0);
        OpenGL.glPixelStorei(3315, 0);
        OpenGL.glTexImage2D(3553, 0, 6408, this.getWidth(), this.getHeight(), 0, 6408, 32821, buffer);
        OpenGL.glGenerateMipmap(3553);
        this.compress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int x, int y, int color) {
        if (this.isCompressed) {
            this.decompress();
        }
        int index = (x + y * this.getWidth()) * 4;
        Object object = this.bufferLock;
        synchronized (object) {
            int alpha = color >> 24 & 0xFF;
            this.bytes[index] = -1;
            this.bytes[index + 1] = (byte)((color & 0xFF) * alpha / 255);
            this.bytes[index + 2] = (byte)((color >> 8 & 0xFF) * alpha / 255);
            this.bytes[index + 3] = (byte)((color >> 16 & 0xFF) * alpha / 255);
        }
    }

    private synchronized void compress() {
        if (!this.isCompressed) {
            if (this.compressNotDelete) {
                try {
                    this.bytes = CompressionUtils.compress(this.bytes);
                }
                catch (IOException iOException) {}
            } else {
                this.bytes = null;
            }
            this.isCompressed = true;
        }
    }

    private synchronized void decompress() {
        if (this.isCompressed) {
            if (this.compressNotDelete) {
                try {
                    this.bytes = CompressionUtils.decompress(this.bytes);
                }
                catch (IOException | DataFormatException exception) {}
            } else {
                this.bytes = new byte[this.width * this.height * 4];
                this.isCompressed = false;
            }
        }
    }

    static {
        byteBuffers.put(65536, defaultSizeBuffer);
    }
}

