/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.fabricmod.FabricModVoxelMap;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapOptions;
import com.mamiyaotaru.voxelmap.gui.GuiSubworldsSelect;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.BiomeMapData;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.lwjgl.glfw.GLFW;

public class GuiPersistentMap
extends PopupGuiScreen
implements IGuiWaypoints {
    private final Random generator = new Random();
    private final PersistentMap persistentMap;
    private final WaypointManager waypointManager;
    private final class_437 parent;
    private final MapSettingsManager mapOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "World Map";
    protected String worldNameDisplay = "";
    protected int worldNameDisplayLength;
    protected int maxWorldNameDisplayLength;
    private String subworldName = "";
    private PopupGuiButton buttonMultiworld;
    private int top;
    private int bottom;
    private boolean oldNorth;
    private boolean lastStill;
    private boolean editingCoordinates;
    private boolean lastEditingCoordinates;
    private class_342 coordinates;
    int centerX;
    int centerY;
    float mapCenterX;
    float mapCenterZ;
    float deltaX;
    float deltaY;
    float deltaXonRelease;
    float deltaYonRelease;
    long timeOfRelease;
    boolean mouseCursorShown = true;
    long timeAtLastTick;
    long timeOfLastKBInput;
    long timeOfLastMouseInput;
    float lastMouseX;
    float lastMouseY;
    protected int mouseX;
    protected int mouseY;
    boolean leftMouseButtonDown;
    float zoom;
    float zoomStart;
    float zoomGoal;
    long timeOfZoom;
    float zoomDirectX;
    float zoomDirectY;
    private float scScale = 1.0f;
    private float guiToMap = 2.0f;
    private float mapToGui = 0.5f;
    private float mouseDirectToMap = 1.0f;
    private float guiToDirectMouse = 2.0f;
    private static int playerGLID;
    private static boolean gotSkin;
    private static int skinTries;
    private boolean closed;
    private CachedRegion[] regions = new CachedRegion[0];
    BackgroundImageInfo backGroundImageInfo;
    private final BiomeMapData biomeMapData = new BiomeMapData(760, 360);
    private float mapPixelsX;
    private float mapPixelsY;
    private final Object closedLock = new Object();
    private final class_304 keyBindForward = new class_304("key.forward.fake", 17, "key.categories.movement");
    private final class_304 keyBindLeft = new class_304("key.left.fake", 30, "key.categories.movement");
    private final class_304 keyBindBack = new class_304("key.back.fake", 31, "key.categories.movement");
    private final class_304 keyBindRight = new class_304("key.right.fake", 32, "key.categories.movement");
    private final class_304 keyBindSprint = new class_304("key.sprint.fake", 29, "key.categories.movement");
    private final class_3675.class_306 forwardCode;
    private final class_3675.class_306 leftCode;
    private final class_3675.class_306 backCode;
    private final class_3675.class_306 rightCode;
    private final class_3675.class_306 sprintCode;
    final class_3675.class_306 nullInput = class_3675.method_15981((String)"key.keyboard.unknown");
    private class_2561 multiworldButtonName;
    private class_5250 multiworldButtonNameRed;
    int sideMargin = 10;
    int buttonCount = 5;
    int buttonSeparation = 4;
    int buttonWidth = 66;
    public boolean editClicked;
    public boolean deleteClicked;
    public boolean addClicked;
    Waypoint newWaypoint;
    Waypoint selectedWaypoint;
    public boolean passEvents;

    public GuiPersistentMap(class_437 parent) {
        this.parent = parent;
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.mapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.persistentMap = VoxelConstants.getVoxelMapInstance().getPersistentMap();
        this.options = VoxelConstants.getVoxelMapInstance().getPersistentMapOptions();
        this.zoom = this.options.zoom;
        this.zoomStart = this.options.zoom;
        this.zoomGoal = this.options.zoom;
        this.persistentMap.setLightMapArray(VoxelConstants.getVoxelMapInstance().getMap().getLightmapArray());
        if (!gotSkin && skinTries < 5) {
            this.getSkin();
        }
        this.forwardCode = class_3675.method_15981((String)VoxelConstants.getMinecraft().field_1690.field_1894.method_1428());
        this.leftCode = class_3675.method_15981((String)VoxelConstants.getMinecraft().field_1690.field_1913.method_1428());
        this.backCode = class_3675.method_15981((String)VoxelConstants.getMinecraft().field_1690.field_1881.method_1428());
        this.rightCode = class_3675.method_15981((String)VoxelConstants.getMinecraft().field_1690.field_1849.method_1428());
        this.sprintCode = class_3675.method_15981((String)VoxelConstants.getMinecraft().field_1690.field_1867.method_1428());
    }

    private void getSkin() {
        class_2960 skinLocation = VoxelConstants.getMinecraft().method_1582().method_52862(VoxelConstants.getPlayer().method_7334()).comp_1626();
        class_1046 imageData = null;
        try {
            if (skinLocation != class_1068.method_4648((UUID)VoxelConstants.getPlayer().method_5667()).comp_1626()) {
                imageData = (class_1046)VoxelConstants.getMinecraft().method_1531().method_4619(skinLocation);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (imageData != null) {
            gotSkin = true;
            OpenGL.Utils.disp(imageData.method_4624());
        } else {
            ++skinTries;
            OpenGL.Utils.img(skinLocation);
        }
        BufferedImage skinImage = ImageUtils.createBufferedImageFromCurrentGLImage();
        boolean showHat = VoxelConstants.getPlayer().method_7348(class_1664.field_7563);
        skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
        float scale = (float)skinImage.getWidth() / 8.0f;
        skinImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), true, 1);
        if (playerGLID != 0) {
            OpenGL.Utils.glah(playerGLID);
        }
        playerGLID = OpenGL.Utils.tex(skinImage);
    }

    public void method_25426() {
        this.passEvents = true;
        this.oldNorth = this.mapOptions.oldNorth;
        this.centerAt(this.options.mapX, this.options.mapZ);
        if (VoxelConstants.getMinecraft().field_1755 == this) {
            this.closed = false;
        }
        this.screenTitle = class_1074.method_4662((String)"worldmap.title", (Object[])new Object[0]);
        this.buildWorldName();
        this.leftMouseButtonDown = false;
        this.sideMargin = 10;
        this.buttonCount = 5;
        this.buttonSeparation = 4;
        this.buttonWidth = (this.field_22789 - this.sideMargin * 2 - this.buttonSeparation * (this.buttonCount - 1)) / this.buttonCount;
        this.method_37063((class_364)new PopupGuiButton(this.sideMargin, this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"options.minimap.waypoints"), buttonWidget_1 -> VoxelConstants.getMinecraft().method_1507((class_437)new GuiWaypoints(this)), this));
        this.multiworldButtonName = class_2561.method_43471((String)(VoxelConstants.isRealmServer() ? "menu.online" : "options.worldmap.multiworld"));
        this.multiworldButtonNameRed = class_2561.method_43471((String)(VoxelConstants.isRealmServer() ? "menu.online" : "options.worldmap.multiworld")).method_27692(class_124.field_1061);
        if (!VoxelConstants.getMinecraft().method_1496() && !VoxelConstants.getVoxelMapInstance().getWaypointManager().receivedAutoSubworldName()) {
            this.buttonMultiworld = new PopupGuiButton(this.sideMargin + (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, this.multiworldButtonName, buttonWidget_1 -> VoxelConstants.getMinecraft().method_1507((class_437)new GuiSubworldsSelect(this)), this);
            this.method_37063((class_364)this.buttonMultiworld);
        }
        this.method_37063((class_364)new PopupGuiButton(this.sideMargin + 3 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"menu.options"), null, this){

            public void method_25306() {
                VoxelConstants.getMinecraft().method_1507((class_437)new GuiMinimapOptions(GuiPersistentMap.this));
            }
        });
        this.method_37063((class_364)new PopupGuiButton(this.sideMargin + 4 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.done"), null, this){

            public void method_25306() {
                VoxelConstants.getMinecraft().method_1507(GuiPersistentMap.this.parent);
            }
        });
        this.coordinates = new class_342(this.getFontRenderer(), this.sideMargin, 10, 140, 20, null);
        this.top = 32;
        this.bottom = this.getHeight() - 32;
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        this.scScale = (float)VoxelConstants.getMinecraft().method_22683().method_4495();
        this.mapPixelsX = VoxelConstants.getMinecraft().method_22683().method_4489();
        this.mapPixelsY = VoxelConstants.getMinecraft().method_22683().method_4506() - (int)(64.0f * this.scScale);
        this.lastStill = false;
        this.timeAtLastTick = System.currentTimeMillis();
        this.keyBindForward.method_1422(this.forwardCode);
        this.keyBindLeft.method_1422(this.leftCode);
        this.keyBindBack.method_1422(this.backCode);
        this.keyBindRight.method_1422(this.rightCode);
        this.keyBindSprint.method_1422(this.sprintCode);
        VoxelConstants.getMinecraft().field_1690.field_1894.method_1422(this.nullInput);
        VoxelConstants.getMinecraft().field_1690.field_1913.method_1422(this.nullInput);
        VoxelConstants.getMinecraft().field_1690.field_1881.method_1422(this.nullInput);
        VoxelConstants.getMinecraft().field_1690.field_1849.method_1422(this.nullInput);
        VoxelConstants.getMinecraft().field_1690.field_1867.method_1422(this.nullInput);
        class_304.method_1426();
    }

    private void centerAt(int x, int z) {
        if (this.oldNorth) {
            this.mapCenterX = -z;
            this.mapCenterZ = x;
        } else {
            this.mapCenterX = x;
            this.mapCenterZ = z;
        }
    }

    private void buildWorldName() {
        String subworldName;
        AtomicReference<String> worldName = new AtomicReference<String>();
        VoxelConstants.getIntegratedServer().ifPresentOrElse(integratedServer -> {
            worldName.set(integratedServer.method_27728().method_150());
            if (worldName.get() == null || ((String)worldName.get()).isBlank()) {
                worldName.set("Singleplayer World");
            }
        }, () -> {
            class_642 info = VoxelConstants.getMinecraft().method_1558();
            if (info != null) {
                worldName.set(info.field_3752);
            }
            if (worldName.get() == null || ((String)worldName.get()).isBlank()) {
                worldName.set("Multiplayer Server");
            }
            if (VoxelConstants.isRealmServer()) {
                worldName.set("Realms");
            }
        });
        StringBuilder worldNameBuilder = new StringBuilder("\u00a7r").append((String)worldName.get());
        this.subworldName = subworldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true);
        if ((subworldName == null || subworldName.isEmpty()) && VoxelConstants.getVoxelMapInstance().getWaypointManager().isMultiworld()) {
            subworldName = "???";
        }
        if (subworldName != null && !subworldName.isEmpty()) {
            worldNameBuilder.append(" - ").append(subworldName);
        }
        this.worldNameDisplay = worldNameBuilder.toString();
        this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
        this.maxWorldNameDisplayLength = this.getWidth() / 2 - this.getFontRenderer().method_1727(this.screenTitle) / 2 - this.sideMargin * 2;
        while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && ((String)worldName.get()).length() > 5) {
            worldName.set(((String)worldName.get()).substring(0, ((String)worldName.get()).length() - 1));
            worldNameBuilder = new StringBuilder((String)worldName.get());
            worldNameBuilder.append("...");
            if (subworldName != null && !subworldName.isEmpty()) {
                worldNameBuilder.append(" - ").append(subworldName);
            }
            this.worldNameDisplay = worldNameBuilder.toString();
            this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
        }
        if (subworldName != null && !subworldName.isEmpty()) {
            while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && subworldName.length() > 5) {
                worldNameBuilder = new StringBuilder((String)worldName.get());
                worldNameBuilder.append("...");
                subworldName = subworldName.substring(0, subworldName.length() - 1);
                worldNameBuilder.append(" - ").append(subworldName);
                this.worldNameDisplay = worldNameBuilder.toString();
                this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
            }
        }
    }

    private float bindZoom(float zoom) {
        zoom = Math.max(this.options.minZoom, zoom);
        return Math.min(this.options.maxZoom, zoom);
    }

    private float easeOut(float elapsedTime, float startValue, float finalDelta, float totalTime) {
        float value = elapsedTime == totalTime ? startValue + finalDelta : finalDelta * (-((float)Math.pow(2.0, -10.0f * elapsedTime / totalTime)) + 1.0f) + startValue;
        return value;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        this.timeOfLastMouseInput = System.currentTimeMillis();
        this.switchToMouseInput();
        float mouseDirectX = (float)VoxelConstants.getMinecraft().field_1729.method_1603();
        float mouseDirectY = (float)VoxelConstants.getMinecraft().field_1729.method_1604();
        if (amount != 0.0) {
            if (amount > 0.0) {
                this.zoomGoal *= 1.26f;
            } else if (amount < 0.0) {
                this.zoomGoal /= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = mouseDirectX;
            this.zoomDirectY = mouseDirectY;
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (mouseY > (double)this.top && mouseY < (double)this.bottom && button == 1) {
            this.timeOfLastKBInput = 0L;
            int mouseDirectX = (int)VoxelConstants.getMinecraft().field_1729.method_1603();
            int mouseDirectY = (int)VoxelConstants.getMinecraft().field_1729.method_1604();
            this.createPopup((int)mouseX, (int)mouseY, mouseDirectX, mouseDirectY);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popupOpen()) {
            this.coordinates.method_25402(mouseX, mouseY, button);
            this.editingCoordinates = this.coordinates.method_25370();
            if (this.editingCoordinates && !this.lastEditingCoordinates) {
                int z;
                int x;
                if (this.oldNorth) {
                    x = (int)Math.floor(this.mapCenterZ);
                    z = -((int)Math.floor(this.mapCenterX));
                } else {
                    x = (int)Math.floor(this.mapCenterX);
                    z = (int)Math.floor(this.mapCenterZ);
                }
                this.coordinates.method_1852(x + ", " + z);
                this.coordinates.method_1868(0xFFFFFF);
            }
            this.lastEditingCoordinates = this.editingCoordinates;
        }
        return super.method_25402(mouseX, mouseY, button) || button == 1;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.editingCoordinates && (VoxelConstants.getMinecraft().field_1690.field_1903.method_1417(keyCode, scanCode) || VoxelConstants.getMinecraft().field_1690.field_1832.method_1417(keyCode, scanCode))) {
            if (VoxelConstants.getMinecraft().field_1690.field_1903.method_1417(keyCode, scanCode)) {
                this.zoomGoal /= 1.26f;
            }
            if (VoxelConstants.getMinecraft().field_1690.field_1832.method_1417(keyCode, scanCode)) {
                this.zoomGoal *= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = (float)VoxelConstants.getMinecraft().method_22683().method_4489() / 2.0f;
            this.zoomDirectY = (float)VoxelConstants.getMinecraft().method_22683().method_4506() - (float)VoxelConstants.getMinecraft().method_22683().method_4506() / 2.0f;
            this.switchToKeyboardInput();
        }
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.method_25404(keyCode, scanCode, modifiers);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if ((keyCode == 257 || keyCode == 335) && this.coordinates.method_25370() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.parseInt(xz[0].trim()), Integer.parseInt(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
            if (keyCode == 258 && this.coordinates.method_25370()) {
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (VoxelConstants.getVoxelMapInstance().getMapOptions().keyBindMenu.method_1417(keyCode, scanCode)) {
            keyCode = 256;
            scanCode = -1;
            modifiers = -1;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.method_25400(chr, modifiers);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if (chr == '\r' && this.coordinates.method_25370() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.parseInt(xz[0].trim()), Integer.parseInt(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (VoxelConstants.getVoxelMapInstance().getMapOptions().keyBindMenu.method_1417(modifiers, -1)) {
            super.method_25404(256, -1, -1);
        }
        return super.method_25400(chr, modifiers);
    }

    private boolean isAcceptable(String input) {
        try {
            String[] xz = this.coordinates.method_1882().split(",");
            Integer.valueOf(xz[0].trim());
            Integer.valueOf(xz[1].trim());
            return true;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException var3) {
            return false;
        }
    }

    private void switchToMouseInput() {
        this.timeOfLastKBInput = 0L;
        if (!this.mouseCursorShown) {
            GLFW.glfwSetInputMode((long)VoxelConstants.getMinecraft().method_22683().method_4490(), (int)208897, (int)212993);
        }
        this.mouseCursorShown = true;
    }

    private void switchToKeyboardInput() {
        this.timeOfLastKBInput = System.currentTimeMillis();
        this.mouseCursorShown = false;
        GLFW.glfwSetInputMode((long)VoxelConstants.getMinecraft().method_22683().method_4490(), (int)208897, (int)212995);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        float cursorCoordZ;
        float cursorCoordX;
        float cursorY;
        float cursorX;
        int bottom;
        int top;
        int right;
        int left;
        this.zoomGoal = this.bindZoom(this.zoomGoal);
        if (this.mouseX != mouseX || this.mouseY != mouseY) {
            this.timeOfLastMouseInput = System.currentTimeMillis();
            this.switchToMouseInput();
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        float mouseDirectX = (float)VoxelConstants.getMinecraft().field_1729.method_1603();
        float mouseDirectY = (float)VoxelConstants.getMinecraft().field_1729.method_1604();
        if (this.zoom != this.zoomGoal) {
            float previousZoom = this.zoom;
            long timeSinceZoom = System.currentTimeMillis() - this.timeOfZoom;
            this.zoom = (float)timeSinceZoom < 700.0f ? this.easeOut(timeSinceZoom, this.zoomStart, this.zoomGoal - this.zoomStart, 700.0f) : this.zoomGoal;
            float scaledZoom = this.zoom;
            if (VoxelConstants.getMinecraft().method_22683().method_4489() > 1600) {
                scaledZoom = this.zoom * (float)VoxelConstants.getMinecraft().method_22683().method_4489() / 1600.0f;
            }
            float zoomDelta = this.zoom / previousZoom;
            float zoomOffsetX = (float)this.centerX * this.guiToDirectMouse - this.zoomDirectX;
            float zoomOffsetY = (float)(this.top + this.centerY) * this.guiToDirectMouse - this.zoomDirectY;
            float zoomDeltaX = zoomOffsetX - zoomOffsetX * zoomDelta;
            float zoomDeltaY = zoomOffsetY - zoomOffsetY * zoomDelta;
            this.mapCenterX += zoomDeltaX / scaledZoom;
            this.mapCenterZ += zoomDeltaY / scaledZoom;
        }
        this.options.zoom = this.zoomGoal;
        float scaledZoom = this.zoom;
        if (VoxelConstants.getMinecraft().method_22683().method_4480() > 1600) {
            scaledZoom = this.zoom * (float)VoxelConstants.getMinecraft().method_22683().method_4480() / 1600.0f;
        }
        this.guiToMap = this.scScale / scaledZoom;
        this.mapToGui = 1.0f / this.scScale * scaledZoom;
        this.mouseDirectToMap = 1.0f / scaledZoom;
        this.guiToDirectMouse = this.scScale;
        this.renderBackground(drawContext);
        if (VoxelConstants.getMinecraft().field_1729.method_1608()) {
            if (!this.leftMouseButtonDown && this.overPopup(mouseX, mouseY)) {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.leftMouseButtonDown = true;
            } else if (this.leftMouseButtonDown) {
                this.deltaX = (this.lastMouseX - mouseDirectX) * this.mouseDirectToMap;
                this.deltaY = (this.lastMouseY - mouseDirectY) * this.mouseDirectToMap;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.deltaXonRelease = this.deltaX;
                this.deltaYonRelease = this.deltaY;
                this.timeOfRelease = System.currentTimeMillis();
            }
        } else {
            long timeSinceRelease = System.currentTimeMillis() - this.timeOfRelease;
            if ((float)timeSinceRelease < 700.0f) {
                this.deltaX = this.deltaXonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
                this.deltaY = this.deltaYonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
            } else {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.deltaXonRelease = 0.0f;
                this.deltaYonRelease = 0.0f;
            }
            this.leftMouseButtonDown = false;
        }
        long timeSinceLastTick = System.currentTimeMillis() - this.timeAtLastTick;
        this.timeAtLastTick = System.currentTimeMillis();
        if (!this.editingCoordinates) {
            int kbDelta = 5;
            if (this.keyBindSprint.method_1434()) {
                kbDelta = 10;
            }
            if (this.keyBindForward.method_1434()) {
                this.deltaY -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindBack.method_1434()) {
                this.deltaY += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindLeft.method_1434()) {
                this.deltaX -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindRight.method_1434()) {
                this.deltaX += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
        }
        this.mapCenterX += this.deltaX;
        this.mapCenterZ += this.deltaY;
        if (this.oldNorth) {
            this.options.mapX = (int)this.mapCenterZ;
            this.options.mapZ = -((int)this.mapCenterX);
        } else {
            this.options.mapX = (int)this.mapCenterX;
            this.options.mapZ = (int)this.mapCenterZ;
        }
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        if (this.oldNorth) {
            left = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
            top = (int)Math.floor((-this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((-this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
        } else {
            left = (int)Math.floor((this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
            top = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
        }
        Object zoomDeltaX = this.closedLock;
        synchronized (zoomDeltaX) {
            if (this.closed) {
                return;
            }
            this.regions = this.persistentMap.getRegions(left - 1, right + 1, top - 1, bottom + 1);
        }
        class_4587 modelViewMatrixStack = RenderSystem.getModelViewStack();
        modelViewMatrixStack.method_22903();
        OpenGL.glColor3f(1.0f, 1.0f, 1.0f);
        modelViewMatrixStack.method_22904((double)((float)this.centerX - this.mapCenterX * this.mapToGui), (double)((float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui), 0.0);
        if (this.oldNorth) {
            modelViewMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        }
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34542);
        this.backGroundImageInfo = this.waypointManager.getBackgroundImageInfo();
        if (this.backGroundImageInfo != null) {
            OpenGL.Utils.disp2(this.backGroundImageInfo.glid);
            this.drawTexturedModalRect((float)this.backGroundImageInfo.left * this.mapToGui, (float)this.backGroundImageInfo.top * this.mapToGui, (float)this.backGroundImageInfo.width * this.mapToGui, (float)this.backGroundImageInfo.height * this.mapToGui);
        }
        for (CachedRegion region : this.regions) {
            int glid = region.getGLID();
            if (glid == 0) continue;
            OpenGL.Utils.disp2(glid);
            RenderSystem.bindTextureForSetup((int)glid);
            if (this.mapOptions.filtering) {
                OpenGL.glTexParameteri(3553, 10241, 9987);
                OpenGL.glTexParameteri(3553, 10240, 9729);
            } else {
                OpenGL.glTexParameteri(3553, 10241, 9987);
                OpenGL.glTexParameteri(3553, 10240, 9728);
            }
            this.drawTexturedModalRect((float)(region.getX() * 256) * this.mapToGui, (float)(region.getZ() * 256) * this.mapToGui, (float)region.getWidth() * this.mapToGui, (float)region.getWidth() * this.mapToGui);
        }
        if (this.mouseCursorShown) {
            cursorX = mouseDirectX;
            cursorY = mouseDirectY - (float)this.top * this.guiToDirectMouse;
        } else {
            cursorX = (float)VoxelConstants.getMinecraft().method_22683().method_4489() / 2.0f;
            cursorY = (float)VoxelConstants.getMinecraft().method_22683().method_4506() - (float)VoxelConstants.getMinecraft().method_22683().method_4506() / 2.0f - (float)this.top * this.guiToDirectMouse;
        }
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        RenderSystem.setShader(class_757::method_34542);
        if (this.options.showWaypoints) {
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                this.drawWaypoint(drawContext, pt, cursorCoordX, cursorCoordZ, null, null, null, null);
            }
            if (this.waypointManager.getHighlightedWaypoint() != null) {
                this.drawWaypoint(drawContext, this.waypointManager.getHighlightedWaypoint(), cursorCoordX, cursorCoordZ, VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas().getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
        }
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.setShader(class_757::method_34542);
        OpenGL.Utils.disp2(playerGLID);
        OpenGL.glTexParameteri(3553, 10241, 9729);
        OpenGL.glTexParameteri(3553, 10240, 9729);
        float playerX = (float)GameVariableAccessShim.xCoordDouble();
        float playerZ = (float)GameVariableAccessShim.zCoordDouble();
        if (this.oldNorth) {
            modelViewMatrixStack.method_22903();
            modelViewMatrixStack.method_22904((double)(playerX * this.mapToGui), (double)(playerZ * this.mapToGui), 0.0);
            modelViewMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
            modelViewMatrixStack.method_22904((double)(-(playerX * this.mapToGui)), (double)(-(playerZ * this.mapToGui)), 0.0);
            RenderSystem.applyModelViewMatrix();
        }
        this.drawTexturedModalRect(-10.0f / this.scScale + playerX * this.mapToGui, -10.0f / this.scScale + playerZ * this.mapToGui, 20.0f / this.scScale, 20.0f / this.scScale);
        if (this.oldNorth) {
            modelViewMatrixStack.method_22909();
        }
        if (this.oldNorth) {
            modelViewMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
        }
        modelViewMatrixStack.method_22904((double)(-((float)this.centerX - this.mapCenterX * this.mapToGui)), (double)(-((float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui)), 0.0);
        RenderSystem.applyModelViewMatrix();
        if (this.mapOptions.biomeOverlay != 0) {
            float biomeScaleX = this.mapPixelsX / 760.0f;
            float biomeScaleY = this.mapPixelsY / 360.0f;
            boolean still = !this.leftMouseButtonDown;
            still = still && this.zoom == this.zoomGoal;
            still = still && this.deltaX == 0.0f && this.deltaY == 0.0f;
            boolean bl = still = still && ThreadManager.executorService.getActiveCount() == 0;
            if (still && !this.lastStill) {
                int column = this.oldNorth ? (int)Math.floor(Math.floor(this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0) - (left - 1) : (int)Math.floor(Math.floor(this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0) - (left - 1);
                for (int x = 0; x < this.biomeMapData.getWidth(); ++x) {
                    for (int z = 0; z < this.biomeMapData.getHeight(); ++z) {
                        float floatMapZ;
                        float floatMapX;
                        if (this.oldNorth) {
                            floatMapX = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                            floatMapZ = -((float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
                        } else {
                            floatMapX = (float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
                            floatMapZ = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                        }
                        int mapX = (int)Math.floor(floatMapX);
                        int mapZ = (int)Math.floor(floatMapZ);
                        int regionX = (int)Math.floor((float)mapX / 256.0f) - (left - 1);
                        int regionZ = (int)Math.floor((float)mapZ / 256.0f) - (top - 1);
                        if (!this.oldNorth && regionX != column || this.oldNorth && regionZ != column) {
                            this.persistentMap.compress();
                        }
                        column = !this.oldNorth ? regionX : regionZ;
                        CachedRegion region = this.regions[regionZ * (right + 1 - (left - 1) + 1) + regionX];
                        int id = -1;
                        if (region.getMapData() != null && region.isLoaded() && !region.isEmpty()) {
                            int inRegionX = mapX - region.getX() * region.getWidth();
                            int inRegionZ = mapZ - region.getZ() * region.getWidth();
                            int height = region.getMapData().getHeight(inRegionX, inRegionZ);
                            int light = region.getMapData().getLight(inRegionX, inRegionZ);
                            if (height != 0 || light != 0) {
                                id = region.getMapData().getBiomeID(inRegionX, inRegionZ);
                            }
                        }
                        this.biomeMapData.setBiomeID(x, z, id);
                    }
                }
                this.persistentMap.compress();
                this.biomeMapData.segmentBiomes();
                this.biomeMapData.findCenterOfSegments(true);
            }
            this.lastStill = still;
            boolean displayStill = !this.leftMouseButtonDown;
            displayStill = displayStill && this.zoom == this.zoomGoal;
            boolean bl2 = displayStill = displayStill && this.deltaX == 0.0f && this.deltaY == 0.0f;
            if (displayStill) {
                int minimumSize = (int)(20.0f * this.scScale / biomeScaleX);
                minimumSize *= minimumSize;
                ArrayList<AbstractMapData.BiomeLabel> labels = this.biomeMapData.getBiomeLabels();
                OpenGL.glDisable(2929);
                for (AbstractMapData.BiomeLabel biomeLabel : labels) {
                    if (biomeLabel.segmentSize <= minimumSize) continue;
                    int nameWidth = this.chkLen(biomeLabel.name);
                    float x = (float)biomeLabel.x * biomeScaleX / this.scScale;
                    float z = (float)biomeLabel.z * biomeScaleY / this.scScale;
                    this.write(drawContext, biomeLabel.name, x - (float)nameWidth / 2.0f, (float)this.top + z - 3.0f, 0xFFFFFF);
                }
                OpenGL.glEnable(2929);
            }
        }
        modelViewMatrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (System.currentTimeMillis() - this.timeOfLastKBInput < 2000L) {
            int scWidth = VoxelConstants.getMinecraft().method_22683().method_4486();
            int scHeight = VoxelConstants.getMinecraft().method_22683().method_4502();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            class_2960 GUI_ICONS_TEXTURE = new class_2960("textures/gui/icons.png");
            RenderSystem.setShaderTexture((int)0, (class_2960)GUI_ICONS_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)775, (int)769, (int)1, (int)0);
            drawContext.method_25302(GUI_ICONS_TEXTURE, scWidth / 2 - 7, scHeight / 2 - 7, 0, 0, 16, 16);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        } else {
            this.switchToMouseInput();
        }
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.getHeight(), 255, 255);
        drawContext.method_25300(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 16, 0xFFFFFF);
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        if (VoxelConstants.getVoxelMapInstance().getMapOptions().coords) {
            if (!this.editingCoordinates) {
                drawContext.method_25303(this.getFontRenderer(), "X: " + x, this.sideMargin, 16, 0xFFFFFF);
                drawContext.method_25303(this.getFontRenderer(), "Z: " + z, this.sideMargin + 64, 16, 0xFFFFFF);
            } else {
                this.coordinates.method_25394(drawContext, mouseX, mouseY, delta);
            }
        }
        if (this.subworldName != null && !this.subworldName.equals(VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true)) || VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true) != null && !VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true).equals(this.subworldName)) {
            this.buildWorldName();
        }
        drawContext.method_25303(this.getFontRenderer(), this.worldNameDisplay, this.getWidth() - this.sideMargin - this.worldNameDisplayLength, 16, 0xFFFFFF);
        if (this.buttonMultiworld != null) {
            if ((this.subworldName == null || this.subworldName.isEmpty()) && VoxelConstants.getVoxelMapInstance().getWaypointManager().isMultiworld()) {
                if ((int)(System.currentTimeMillis() / 1000L % 2L) == 0) {
                    this.buttonMultiworld.method_25355((class_2561)this.multiworldButtonNameRed);
                } else {
                    this.buttonMultiworld.method_25355(this.multiworldButtonName);
                }
            } else {
                this.buttonMultiworld.method_25355(this.multiworldButtonName);
            }
        }
        super.method_25394(drawContext, mouseX, mouseY, delta);
    }

    private void drawWaypoint(class_332 drawContext, Waypoint pt, float cursorCoordX, float cursorCoordZ, Sprite icon, Float r, Float g, Float b) {
        class_4587 matrixStack = drawContext.method_51448();
        if (pt.inWorld && pt.inDimension && this.isOnScreen(pt.getX(), pt.getZ())) {
            String name = pt.name;
            if (r == null) {
                r = Float.valueOf(pt.red);
            }
            if (g == null) {
                g = Float.valueOf(pt.green);
            }
            if (b == null) {
                b = Float.valueOf(pt.blue);
            }
            float ptX = pt.getX();
            float ptZ = pt.getZ();
            if (this.backGroundImageInfo != null && this.backGroundImageInfo.isInRange((int)ptX, (int)ptZ) || this.persistentMap.isRegionLoaded((int)ptX, (int)ptZ)) {
                boolean hover = cursorCoordX > (ptX += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > (ptZ += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
                boolean target = false;
                RenderSystem.setShader(class_757::method_34542);
                TextureAtlas atlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
                OpenGL.Utils.disp2(atlas.method_4624());
                if (icon == null) {
                    icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
                    if (icon == atlas.getMissingImage()) {
                        icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
                    }
                } else {
                    name = "";
                    target = true;
                }
                OpenGL.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), !pt.enabled && !target && !hover ? 0.3f : 1.0f);
                OpenGL.glTexParameteri(3553, 10241, 9729);
                OpenGL.glTexParameteri(3553, 10240, 9729);
                if (this.oldNorth) {
                    matrixStack.method_22903();
                    matrixStack.method_22904((double)(ptX * this.mapToGui), (double)(ptZ * this.mapToGui), 0.0);
                    matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
                    matrixStack.method_22904((double)(-(ptX * this.mapToGui)), (double)(-(ptZ * this.mapToGui)), 0.0);
                    RenderSystem.applyModelViewMatrix();
                }
                this.drawTexturedModalRect(-16.0f / this.scScale + ptX * this.mapToGui, -16.0f / this.scScale + ptZ * this.mapToGui, icon, 32.0f / this.scScale, 32.0f / this.scScale);
                if (this.oldNorth) {
                    matrixStack.method_22909();
                    RenderSystem.applyModelViewMatrix();
                }
                if (this.mapOptions.biomeOverlay == 0 && this.options.showWaypointNames || target || hover) {
                    float fontScale = 2.0f / this.scScale;
                    int m = this.chkLen(name) / 2;
                    matrixStack.method_22903();
                    matrixStack.method_22905(fontScale, fontScale, 1.0f);
                    if (this.oldNorth) {
                        matrixStack.method_22904((double)(ptX * this.mapToGui / fontScale), (double)(ptZ * this.mapToGui / fontScale), 0.0);
                        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
                        matrixStack.method_22904((double)(-(ptX * this.mapToGui / fontScale)), (double)(-(ptZ * this.mapToGui / fontScale)), 0.0);
                        RenderSystem.applyModelViewMatrix();
                    }
                    this.write(drawContext, name, ptX * this.mapToGui / fontScale - (float)m, ptZ * this.mapToGui / fontScale + 16.0f / this.scScale / fontScale, !pt.enabled && !target && !hover ? 0x55FFFFFF : 0xFFFFFF);
                    matrixStack.method_22909();
                    RenderSystem.applyModelViewMatrix();
                    OpenGL.glEnable(3042);
                }
            }
        }
    }

    private boolean isOnScreen(int x, int z) {
        int bottom;
        int top;
        int right;
        int left;
        if (this.oldNorth) {
            left = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)(-this.mapCenterX) - (double)((float)this.centerX * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)(-this.mapCenterX) + (double)((float)this.centerX * this.guiToMap) * 1.1);
        } else {
            left = (int)Math.floor((double)this.mapCenterX - (double)((float)this.centerX * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterX + (double)((float)this.centerX * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
        }
        return x > left && x < right && z > top && z < bottom;
    }

    public void renderBackground(class_332 drawContext) {
        drawContext.method_25294(0, 0, this.getWidth(), this.getHeight(), -16777216);
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        vertexBuffer.method_22912(0.0, (double)endY, 0.0).method_22913(0.0f, (float)endY / 32.0f).method_1336(64, 64, 64, endAlpha).method_1344();
        vertexBuffer.method_22912((double)this.getWidth(), (double)endY, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)endY / 32.0f).method_1336(64, 64, 64, endAlpha).method_1344();
        vertexBuffer.method_22912((double)this.getWidth(), (double)startY, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)startY / 32.0f).method_1336(64, 64, 64, startAlpha).method_1344();
        vertexBuffer.method_22912(0.0, (double)startY, 0.0).method_22913(0.0f, (float)startY / 32.0f).method_1336(64, 64, 64, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void method_25393() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25432() {
        VoxelConstants.getMinecraft().field_1690.field_1894.method_1422(this.forwardCode);
        VoxelConstants.getMinecraft().field_1690.field_1913.method_1422(this.leftCode);
        VoxelConstants.getMinecraft().field_1690.field_1881.method_1422(this.backCode);
        VoxelConstants.getMinecraft().field_1690.field_1849.method_1422(this.rightCode);
        VoxelConstants.getMinecraft().field_1690.field_1867.method_1422(this.sprintCode);
        this.keyBindForward.method_1422(this.nullInput);
        this.keyBindLeft.method_1422(this.nullInput);
        this.keyBindBack.method_1422(this.nullInput);
        this.keyBindRight.method_1422(this.nullInput);
        this.keyBindSprint.method_1422(this.nullInput);
        class_304.method_1426();
        class_304.method_1437();
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
            this.persistentMap.getRegions(0, -1, 0, -1);
            this.regions = new CachedRegion[0];
        }
    }

    public void drawTexturedModalRect(float x, float y, float width, float height) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + height), 0.0).method_22913(0.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22913(1.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + 0.0f), 0.0).method_22913(1.0f, 0.0f).method_1344();
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + 0.0f), 0.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        vertexBuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + heightIn), 0.0).method_22913(icon.getMinU(), icon.getMaxV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), 0.0).method_22913(icon.getMaxU(), icon.getMaxV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + 0.0f), 0.0).method_22913(icon.getMaxU(), icon.getMinV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), 0.0).method_22913(icon.getMinU(), icon.getMinV()).method_1344();
        tessellator.method_1350();
    }

    private void createPopup(int x, int y, int directX, int directY) {
        Popup.PopupEntry entry;
        float cursorCoordZ;
        float cursorCoordX;
        ArrayList<Popup.PopupEntry> entries = new ArrayList<Popup.PopupEntry>();
        float cursorX = directX;
        float cursorY = (float)directY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        if (hovered != null && this.waypointManager.getWaypoints().contains(hovered)) {
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"selectServer.edit", (Object[])new Object[0]), 4, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"selectServer.delete", (Object[])new Object[0]), 5, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)(hovered != this.waypointManager.getHighlightedWaypoint() ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight"), (Object[])new Object[0]), 1, true, true);
        } else {
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.newwaypoint", (Object[])new Object[0]), 0, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)(hovered == null ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight"), (Object[])new Object[0]), 1, true, true);
        }
        entries.add(entry);
        entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.teleportto", (Object[])new Object[0]), 3, true, true);
        entries.add(entry);
        entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.share", (Object[])new Object[0]), 2, true, true);
        entries.add(entry);
        this.createPopup(x, y, directX, directY, entries);
    }

    private Waypoint getHovered(float cursorCoordX, float cursorCoordZ) {
        Waypoint pt;
        Waypoint waypoint = null;
        for (Waypoint pt2 : this.waypointManager.getWaypoints()) {
            float ptX = (float)pt2.getX() + 0.5f;
            float ptZ = (float)pt2.getZ() + 0.5f;
            boolean hover = pt2.inDimension && pt2.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (!hover) continue;
            waypoint = pt2;
        }
        if (waypoint == null && (pt = this.waypointManager.getHighlightedWaypoint()) != null) {
            boolean hover;
            float ptX = (float)pt.getX() + 0.5f;
            float ptZ = (float)pt.getZ() + 0.5f;
            boolean bl = hover = pt.inDimension && pt.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (hover) {
                waypoint = pt;
            }
        }
        return waypoint;
    }

    @Override
    public void popupAction(Popup popup, int action) {
        float cursorCoordZ;
        float cursorCoordX;
        int mouseDirectX = popup.clickedDirectX;
        int mouseDirectY = popup.clickedDirectY;
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        int y = this.persistentMap.getHeightAt(x, z);
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        this.editClicked = false;
        this.addClicked = false;
        this.deleteClicked = false;
        double dimensionScale = VoxelConstants.getPlayer().method_37908().method_8597().comp_646();
        switch (action) {
            case 0: {
                float b;
                float g;
                float r;
                if (hovered != null) {
                    x = hovered.getX();
                    z = hovered.getZ();
                }
                this.addClicked = true;
                if (this.waypointManager.getWaypoints().isEmpty()) {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                } else {
                    r = this.generator.nextFloat();
                    g = this.generator.nextFloat();
                    b = this.generator.nextFloat();
                }
                TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908()));
                this.newWaypoint = new Waypoint("", (int)((double)x * dimensionScale), (int)((double)z * dimensionScale), y, true, r, g, b, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
                VoxelConstants.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.newWaypoint, false));
                break;
            }
            case 1: {
                if (hovered != null) {
                    this.waypointManager.setHighlightedWaypoint(hovered, true);
                    break;
                }
                y = y > VoxelConstants.getPlayer().method_37908().method_31607() ? y : 64;
                TreeSet<DimensionContainer> dimensions2 = new TreeSet<DimensionContainer>();
                dimensions2.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908()));
                Waypoint fakePoint = new Waypoint("", (int)((double)x * dimensionScale), (int)((double)z * dimensionScale), y, true, 1.0f, 0.0f, 0.0f, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions2);
                this.waypointManager.setHighlightedWaypoint(fakePoint, true);
                break;
            }
            case 2: {
                if (hovered != null) {
                    CommandUtils.sendWaypoint(hovered);
                    break;
                }
                y = y > VoxelConstants.getPlayer().method_37908().method_31607() ? y : 64;
                CommandUtils.sendCoordinate(x, y, z);
                break;
            }
            case 3: {
                if (hovered == null) {
                    if (y == 0) {
                        y = !VoxelConstants.getPlayer().method_37908().method_8597().comp_643() ? VoxelConstants.getPlayer().method_37908().method_31600() : 64;
                    }
                    FabricModVoxelMap.instance.playerRunTeleportCommand(x, y, z);
                    break;
                }
                this.selectedWaypoint = hovered;
                y = this.selectedWaypoint.getY() > VoxelConstants.getPlayer().method_37908().method_31607() ? this.selectedWaypoint.getY() : (!VoxelConstants.getPlayer().method_37908().method_8597().comp_643() ? VoxelConstants.getPlayer().method_37908().method_31600() : 64);
                FabricModVoxelMap.instance.playerRunTeleportCommand(this.selectedWaypoint.getX(), y, this.selectedWaypoint.getZ());
                break;
            }
            case 4: {
                if (hovered == null) break;
                this.editClicked = true;
                this.selectedWaypoint = hovered;
                VoxelConstants.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, hovered, true));
                break;
            }
            case 5: {
                if (hovered == null) break;
                this.deleteClicked = true;
                this.selectedWaypoint = hovered;
                class_5250 title = class_2561.method_43471((String)"minimap.waypoints.deleteconfirm");
                class_5250 explanation = class_2561.method_43469((String)"selectServer.deleteWarning", (Object[])new Object[]{this.selectedWaypoint.name});
                class_5250 affirm = class_2561.method_43471((String)"selectServer.deleteButton");
                class_5250 deny = class_2561.method_43471((String)"gui.cancel");
                class_410 confirmScreen = new class_410((BooleanConsumer)this, (class_2561)title, (class_2561)explanation, (class_2561)affirm, (class_2561)deny);
                VoxelConstants.getMinecraft().method_1507((class_437)confirmScreen);
                break;
            }
            default: {
                VoxelConstants.getLogger().warn("unimplemented command");
            }
        }
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean b) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (b) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (b) {
                this.waypointManager.saveWaypoints();
            }
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (b) {
                this.waypointManager.addWaypoint(this.newWaypoint);
            }
        }
        VoxelConstants.getMinecraft().method_1507((class_437)this);
    }

    private int chkLen(String string) {
        return this.getFontRenderer().method_1727(string);
    }

    private void write(class_332 drawContext, String string, float x, float y, int color) {
        drawContext.method_25303(this.field_22793, string, (int)x, (int)y, color);
    }
}

