/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_3532;

public class Stitcher {
    private final Set<Holder> setStitchHolders = Sets.newHashSetWithExpectedSize((int)256);
    private final List<Slot> stitchSlots = Lists.newArrayListWithCapacity((int)256);
    private int currentWidth;
    private int currentHeight;
    private int currentWidthToPowerOfTwo;
    private int currentHeightToPowerOfTwo;
    private final int maxWidth;
    private final int maxHeight;
    private final int maxTileDimension;

    public Stitcher(int maxWidth, int maxHeight, int maxTileDimension) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.maxTileDimension = maxTileDimension;
    }

    public int getCurrentImageWidth() {
        return this.currentWidthToPowerOfTwo;
    }

    public int getCurrentImageHeight() {
        return this.currentHeightToPowerOfTwo;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public void addSprite(Sprite icon) {
        Holder holder = new Holder(icon);
        if (this.maxTileDimension > 0) {
            holder.setNewDimension(this.maxTileDimension);
        }
        this.setStitchHolders.add(holder);
    }

    public void doStitch() {
        Object[] stitchHoldersArray = this.setStitchHolders.toArray(new Holder[0]);
        Arrays.sort(stitchHoldersArray);
        int stitcherHoldersArrayLength = stitchHoldersArray.length;
        if (stitcherHoldersArrayLength > 0) {
            Object holder = stitchHoldersArray[0];
            int iconWidth = ((Holder)holder).width;
            int iconHeight = ((Holder)holder).height;
            boolean allSameSize = true;
            for (int stitcherHolderIndex = 1; stitcherHolderIndex < stitcherHoldersArrayLength && allSameSize; ++stitcherHolderIndex) {
                holder = stitchHoldersArray[stitcherHolderIndex];
                allSameSize = ((Holder)holder).width == iconWidth && ((Holder)holder).height == iconHeight;
            }
            if (allSameSize) {
                int nextPowerOfTwo = class_3532.method_15339((int)stitcherHoldersArrayLength);
                int power = Integer.numberOfTrailingZeros(nextPowerOfTwo);
                int width = (int)Math.pow(2.0, Math.ceil((double)power / 2.0)) * iconWidth;
                int height = (int)Math.pow(2.0, Math.floor((double)power / 2.0)) * iconHeight;
                this.currentWidth = width;
                this.currentHeight = height;
                this.currentWidthToPowerOfTwo = width;
                this.currentHeightToPowerOfTwo = height;
                Slot slot = new Slot(0, 0, this.currentWidth, this.currentHeight);
                this.stitchSlots.add(slot);
            }
        }
        for (Object holder : stitchHoldersArray) {
            if (this.allocateSlot((Holder)holder)) continue;
            String errorString = String.format("Unable to fit: %s - size: %dx%d - Maybe try a lower resolution resourcepack?", ((Holder)holder).getAtlasSprite().getIconName(), ((Holder)holder).getAtlasSprite().getIconWidth(), ((Holder)holder).getAtlasSprite().getIconHeight());
            throw new StitcherException(errorString);
        }
        this.currentWidthToPowerOfTwo = class_3532.method_15339((int)this.currentWidth);
        this.currentHeightToPowerOfTwo = class_3532.method_15339((int)this.currentHeight);
        this.setStitchHolders.clear();
    }

    public void doStitchNew() {
        Object[] stitchHoldersArray = this.setStitchHolders.toArray(new Holder[0]);
        Arrays.sort(stitchHoldersArray);
        for (Object holder : stitchHoldersArray) {
            if (this.allocateSlot((Holder)holder)) continue;
            String errorString = String.format("Unable to fit: %s - size: %dx%d - Maybe try a lower resolution resourcepack?", ((Holder)holder).getAtlasSprite().getIconName(), ((Holder)holder).getAtlasSprite().getIconWidth(), ((Holder)holder).getAtlasSprite().getIconHeight());
            throw new StitcherException(errorString);
        }
        this.currentWidthToPowerOfTwo = class_3532.method_15339((int)this.currentWidth);
        this.currentHeightToPowerOfTwo = class_3532.method_15339((int)this.currentHeight);
        this.setStitchHolders.clear();
    }

    public List<Sprite> getStitchSlots() {
        ArrayList listOfStitchSlots = Lists.newArrayList();
        for (Slot slot : this.stitchSlots) {
            slot.getAllStitchSlots(listOfStitchSlots);
        }
        ArrayList spritesList = Lists.newArrayList();
        for (Slot stitcherSlot : listOfStitchSlots) {
            Holder stitcherHolder = stitcherSlot.getStitchHolder();
            Sprite icon = stitcherHolder.getAtlasSprite();
            icon.initSprite(this.currentWidthToPowerOfTwo, this.currentHeightToPowerOfTwo, stitcherSlot.getOriginX(), stitcherSlot.getOriginY());
            spritesList.add(icon);
        }
        return spritesList;
    }

    private boolean allocateSlot(Holder holder) {
        return this.stitchSlots.stream().anyMatch(stitchSlot -> stitchSlot.addSlot(holder)) || this.expandAndAllocateSlot(holder);
    }

    private boolean expandAndAllocateSlot(Holder holder) {
        Slot slot;
        boolean heightWouldChange;
        boolean isRoomToExpandDown;
        int expandBy = holder.getWidth();
        int currentWidthToPowerOfTwo = class_3532.method_15339((int)this.currentWidth);
        int currentHeightToPowerOfTwo = class_3532.method_15339((int)this.currentHeight);
        int possibleNewWidthToPowerOfTwo = class_3532.method_15339((int)(this.currentWidth + expandBy));
        int possibleNewHeightToPowerOfTwo = class_3532.method_15339((int)(this.currentHeight + expandBy));
        boolean isRoomToExpandRight = possibleNewWidthToPowerOfTwo <= this.maxWidth;
        boolean bl = isRoomToExpandDown = possibleNewHeightToPowerOfTwo <= this.maxHeight;
        if (!isRoomToExpandRight && !isRoomToExpandDown) {
            return false;
        }
        boolean widthWouldChange = currentWidthToPowerOfTwo != possibleNewWidthToPowerOfTwo;
        boolean bl2 = heightWouldChange = currentHeightToPowerOfTwo != possibleNewHeightToPowerOfTwo;
        boolean shouldExpandRight = widthWouldChange ^ heightWouldChange ? !widthWouldChange : isRoomToExpandRight && currentWidthToPowerOfTwo <= currentHeightToPowerOfTwo;
        if (class_3532.method_15339((int)((shouldExpandRight ? this.currentWidth : this.currentHeight) + expandBy)) > (shouldExpandRight ? this.maxWidth : this.maxHeight)) {
            return false;
        }
        if (shouldExpandRight) {
            if (this.currentHeight == 0) {
                this.currentHeight = holder.getHeight();
            }
            slot = new Slot(this.currentWidth, 0, holder.getWidth(), this.currentHeight);
            this.currentWidth += holder.getWidth();
        } else {
            slot = new Slot(0, this.currentHeight, this.currentWidth, holder.getHeight());
            this.currentHeight += holder.getHeight();
        }
        if (!slot.addSlot(holder)) {
            String errorString = String.format("Unable to fit: %s - size: %dx%d - Maybe try a lower resolution resourcepack?", holder.getAtlasSprite().getIconName(), holder.getAtlasSprite().getIconWidth(), holder.getAtlasSprite().getIconHeight());
            VoxelConstants.getLogger().warn(errorString);
        }
        this.stitchSlots.add(slot);
        return true;
    }

    public static class Holder
    implements Comparable<Holder> {
        private final Sprite icon;
        private final int width;
        private final int height;
        private float scaleFactor = 1.0f;

        public Holder(Sprite icon) {
            this.icon = icon;
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }

        public Sprite getAtlasSprite() {
            return this.icon;
        }

        public int getWidth() {
            return (int)((float)this.width * this.scaleFactor);
        }

        public int getHeight() {
            return (int)((float)this.height * this.scaleFactor);
        }

        public void setNewDimension(int newDimension) {
            if (this.width > newDimension && this.height > newDimension) {
                this.scaleFactor = (float)newDimension / (float)Math.min(this.width, this.height);
            }
        }

        @Override
        public int compareTo(Holder o) {
            int var2;
            if (this.getHeight() == o.getHeight()) {
                if (this.getWidth() == o.getWidth()) {
                    if (this.icon.getIconName() == null) {
                        return o.icon.getIconName() == null ? 0 : -1;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(this.icon.getIconName(), o.icon.getIconName());
                }
                var2 = this.getWidth() < o.getWidth() ? 1 : -1;
            } else {
                var2 = this.getHeight() < o.getHeight() ? 1 : -1;
            }
            return var2;
        }
    }

    public class Slot {
        private final int originX;
        private final int originY;
        private final int width;
        private final int height;
        private int failsAt;
        private List<Slot> subSlots;
        private Holder holder;

        public Slot(int originX, int originY, int width, int height) {
            this.failsAt = Stitcher.this.maxWidth;
            this.originX = originX;
            this.originY = originY;
            this.width = width;
            this.height = height;
        }

        public Holder getStitchHolder() {
            return this.holder;
        }

        public int getOriginX() {
            return this.originX;
        }

        public int getOriginY() {
            return this.originY;
        }

        public boolean addSlot(Holder holder) {
            if (holder.width >= this.failsAt) {
                return false;
            }
            if (this.holder != null) {
                this.failsAt = 0;
                return false;
            }
            int holderWidth = holder.getWidth();
            int holderHeight = holder.getHeight();
            if (holderWidth <= this.width && holderHeight <= this.height) {
                if (holderWidth == this.width && holderHeight == this.height) {
                    this.holder = holder;
                    return true;
                }
                if (this.subSlots == null) {
                    this.subSlots = Lists.newArrayListWithCapacity((int)1);
                    Stitcher stitcher = Stitcher.this;
                    Objects.requireNonNull(stitcher);
                    this.subSlots.add(stitcher.new Slot(this.originX, this.originY, holderWidth, holderHeight));
                    int excessWidth = this.width - holderWidth;
                    int excessHeight = this.height - holderHeight;
                    if (excessHeight > 0 && excessWidth > 0) {
                        int var7;
                        int var6 = Math.max(this.height, excessWidth);
                        if (var6 > (var7 = Math.max(this.width, excessHeight))) {
                            Stitcher stitcher2 = Stitcher.this;
                            Objects.requireNonNull(stitcher2);
                            this.subSlots.add(stitcher2.new Slot(this.originX, this.originY + holderHeight, holderWidth, excessHeight));
                            Stitcher stitcher3 = Stitcher.this;
                            Objects.requireNonNull(stitcher3);
                            this.subSlots.add(stitcher3.new Slot(this.originX + holderWidth, this.originY, excessWidth, this.height));
                        } else {
                            Stitcher stitcher4 = Stitcher.this;
                            Objects.requireNonNull(stitcher4);
                            this.subSlots.add(stitcher4.new Slot(this.originX + holderWidth, this.originY, excessWidth, holderHeight));
                            Stitcher stitcher5 = Stitcher.this;
                            Objects.requireNonNull(stitcher5);
                            this.subSlots.add(stitcher5.new Slot(this.originX, this.originY + holderHeight, this.width, excessHeight));
                        }
                    } else if (excessWidth == 0) {
                        Stitcher stitcher6 = Stitcher.this;
                        Objects.requireNonNull(stitcher6);
                        this.subSlots.add(stitcher6.new Slot(this.originX, this.originY + holderHeight, holderWidth, excessHeight));
                    } else if (excessHeight == 0) {
                        Stitcher stitcher7 = Stitcher.this;
                        Objects.requireNonNull(stitcher7);
                        this.subSlots.add(stitcher7.new Slot(this.originX + holderWidth, this.originY, excessWidth, holderHeight));
                    }
                }
                for (Slot slot : this.subSlots) {
                    if (!slot.addSlot(holder)) continue;
                    return true;
                }
                this.failsAt = holder.width;
                return false;
            }
            this.failsAt = holder.width;
            return false;
        }

        public void getAllStitchSlots(List<Slot> listOfStitchSlots) {
            if (this.holder != null) {
                listOfStitchSlots.add(this);
            } else if (this.subSlots != null) {
                for (Slot slot : this.subSlots) {
                    slot.getAllStitchSlots(listOfStitchSlots);
                }
            }
        }
    }
}

