/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.mamiyaotaru.voxelmap.util.OpenGL;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public final class TextureUtilLegacy {
    private static final IntBuffer DATA_BUFFER = TextureUtilLegacy.createDirectIntBuffer(0x400000);

    private TextureUtilLegacy() {
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public static IntBuffer createDirectIntBuffer(int capacity) {
        return TextureUtilLegacy.createDirectByteBuffer(capacity << 2).asIntBuffer();
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        if (imageStream == null) {
            return null;
        }
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
        return bufferedimage;
    }

    public static void allocateTextureImpl(int glTextureId, int mipmapLevels, int width, int height) {
        TextureUtilLegacy.bindTexture(glTextureId);
        if (mipmapLevels >= 0) {
            OpenGL.glTexParameteri(3553, 33085, mipmapLevels);
            OpenGL.glTexParameteri(3553, 33082, 0);
            OpenGL.glTexParameteri(3553, 33083, mipmapLevels);
            OpenGL.glTexParameterf(3553, 34049, 0.0f);
        }
        for (int i = 0; i <= mipmapLevels; ++i) {
            OpenGL.glPixelStorei(3314, 0);
            OpenGL.glPixelStorei(3316, 0);
            OpenGL.glPixelStorei(3315, 0);
            OpenGL.glTexImage2D(3553, i, 6408, width >> i, height >> i, 0, 32993, 33639, (IntBuffer)null);
        }
    }

    public static void uploadTexture(int glTextureId, int[] zeros, int currentImageWidth, int currentImageHeight) {
        TextureUtilLegacy.bindTexture(glTextureId);
        TextureUtilLegacy.uploadTextureSub(0, zeros, currentImageWidth, currentImageHeight, 0, 0, false, false, false);
    }

    private static void copyToBufferPos(int[] imageData, int p_110994_1_, int p_110994_2_) {
        DATA_BUFFER.clear();
        DATA_BUFFER.put(imageData, p_110994_1_, p_110994_2_);
        DATA_BUFFER.position(0).limit(p_110994_2_);
    }

    static void bindTexture(int id) {
        OpenGL.glBindTexture(3553, id);
    }

    public static void uploadTextureMipmap(int[][] textureData, int width, int height, int originX, int originY, boolean blurred, boolean clamped) {
        for (int i = 0; i < textureData.length; ++i) {
            int[] aint = textureData[i];
            TextureUtilLegacy.uploadTextureSub(i, aint, width >> i, height >> i, originX >> i, originY >> i, blurred, clamped, textureData.length > 1);
        }
    }

    public static void setTextureClamped(boolean clamped) {
        if (clamped) {
            OpenGL.glTexParameteri(3553, 10242, 33071);
            OpenGL.glTexParameteri(3553, 10243, 33071);
        } else {
            OpenGL.glTexParameteri(3553, 10242, 10497);
            OpenGL.glTexParameteri(3553, 10243, 10497);
        }
    }

    public static void setTextureBlurMipmap(boolean blurred, boolean mipmapped) {
        if (blurred) {
            OpenGL.glTexParameteri(3553, 10241, mipmapped ? 9987 : 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
        } else {
            OpenGL.glTexParameteri(3553, 10241, mipmapped ? 9986 : 9728);
            OpenGL.glTexParameteri(3553, 10240, 9728);
        }
    }

    private static void uploadTextureSub(int mipmapLevel, int[] imageData, int width, int height, int originX, int originY, boolean blurred, boolean clamped, boolean mipmapped) {
        int rowsToCopy;
        int maxRows = 0x400000 / width;
        TextureUtilLegacy.setTextureBlurMipmap(blurred, mipmapped);
        TextureUtilLegacy.setTextureClamped(clamped);
        OpenGL.glPixelStorei(3314, width);
        OpenGL.glPixelStorei(3316, 0);
        OpenGL.glPixelStorei(3315, 0);
        for (int pos = 0; pos < width * height; pos += width * rowsToCopy) {
            int rowsCopied = pos / width;
            rowsToCopy = Math.min(maxRows, height - rowsCopied);
            int sizeOfCopy = width * rowsToCopy;
            TextureUtilLegacy.copyToBufferPos(imageData, pos, sizeOfCopy);
            OpenGL.glTexSubImage2D(3553, mipmapLevel, originX, originY + rowsCopied, width, rowsToCopy, 32993, 33639, DATA_BUFFER);
        }
    }
}

