/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_311;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public final class OpenGL {
    public static final int GL11_GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL11_GL_LEQUAL = 515;
    public static final int GL11_GL_ALWAYS = 519;
    public static final int GL11_GL_SRC_ALPHA = 770;
    public static final int GL11_GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL11_GL_CULL_FACE = 2884;
    public static final int GL11_GL_DEPTH_TEST = 2929;
    public static final int GL11_GL_BLEND = 3042;
    public static final int GL11_GL_SCISSOR_TEST = 3089;
    public static final int GL11_GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL11_GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL11_GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL11_GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL11_GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL11_GL_PACK_ALIGNMENT = 3333;
    public static final int GL11_GL_TEXTURE_2D = 3553;
    public static final int GL11_GL_TRANSFORM_BIT = 4096;
    public static final int GL11_GL_TEXTURE_HEIGHT = 4097;
    public static final int GL11_GL_BYTE = 5120;
    public static final int GL11_GL_UNSIGNED_BYTE = 5121;
    public static final int GL11_GL_RGBA = 6408;
    public static final int GL11_GL_NEAREST = 9728;
    public static final int GL11_GL_LINEAR = 9729;
    public static final int GL11_GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL11_GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL11_GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL11_GL_TEXTURE_WRAP_S = 10242;
    public static final int GL11_GL_TEXTURE_WRAP_T = 10243;
    public static final int GL11_GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL11_GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL11_GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL12_GL_UNSIGNED_INT_8_8_8_8 = 32821;
    public static final int GL12_GL_BGRA = 32993;
    public static final int GL12_GL_CLAMP_TO_EDGE = 33071;
    public static final int GL12_GL_UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL14_GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL30_GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL30_GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL30_GL_FRAMEBUFFER = 36160;
    public static final int GL30_GL_READ_FRAMEBUFFER = 36008;
    public static final int GL30_GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL30_GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL30_GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL30_GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL30_GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int GL30_GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int GL30_GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL30_GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL30_GL_RENDERBUFFER = 36161;

    private OpenGL() {
    }

    public static void glEnable(int target) {
        switch (target) {
            case 2884: {
                RenderSystem.enableCull();
                break;
            }
            case 2929: {
                RenderSystem.enableDepthTest();
                break;
            }
            case 3042: {
                RenderSystem.enableBlend();
                break;
            }
            case 3089: {
                GL11.glEnable((int)3089);
                break;
            }
            case 32823: {
                RenderSystem.enablePolygonOffset();
                break;
            }
            default: {
                VoxelConstants.getLogger().warn("OpenGL - Invalid state received by Enable (" + target + ")");
            }
        }
    }

    public static void glDisable(int target) {
        switch (target) {
            case 2884: {
                RenderSystem.disableCull();
                break;
            }
            case 2929: {
                RenderSystem.disableDepthTest();
                break;
            }
            case 3042: {
                RenderSystem.disableBlend();
                break;
            }
            case 3089: {
                GL11.glDisable((int)3089);
                break;
            }
            case 32823: {
                RenderSystem.disablePolygonOffset();
                break;
            }
            default: {
                VoxelConstants.getLogger().warn("OpenGL - Invalid state received by Disable (" + target + ")");
            }
        }
    }

    public static void glBlendFunc(int srcFactor, int dstFactor) {
        RenderSystem.blendFunc((int)srcFactor, (int)dstFactor);
    }

    public static void glBlendFuncSeparate(int srcFactorRGB, int dstFactorRGB, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.blendFuncSeparate((int)srcFactorRGB, (int)dstFactorRGB, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static void glClear(int mask) {
        RenderSystem.clear((int)mask, (boolean)VoxelConstants.isSystemMacOS());
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        RenderSystem.clearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        RenderSystem.clearDepth((double)depth);
    }

    public static void glColor3f(float red, float green, float blue) {
        OpenGL.glColor4f(red, green, blue, 1.0f);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glDeleteTexture(int texture) {
        RenderSystem.deleteTexture((int)texture);
    }

    public static void glDepthMask(boolean mask) {
        RenderSystem.depthMask((boolean)mask);
    }

    public static int glGenTextures() {
        return GlStateManager._genTexture();
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        return GlStateManager._getTexLevelParameter((int)target, (int)level, (int)pname);
    }

    public static void glPixelStorei(int pname, int param) {
        RenderSystem.pixelStore((int)pname, (int)param);
    }

    public static void glPolygonOffset(float factor, float units) {
        RenderSystem.polygonOffset((float)factor, (float)units);
    }

    public static void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GlStateManager._texImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexParameterf(int target, int pname, float param) {
        GlStateManager._texParameter((int)target, (int)pname, (float)param);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        RenderSystem.texParameter((int)target, (int)pname, (int)param);
    }

    public static void glViewport(int x, int y, int width, int height) {
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glBindTexture(int target, int texture) {
        if (target == 3553) {
            RenderSystem.bindTexture((int)texture);
            return;
        }
        GL11.glBindTexture((int)target, (int)texture);
    }

    public static void glGenerateMipmap(int target) {
        GL30.glGenerateMipmap((int)target);
    }

    public static void glGetFloatv(int pname, FloatBuffer params) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public static int glGetInteger(int pname) {
        return GL11.glGetInteger((int)pname);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, ByteBuffer pixels) {
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, IntBuffer pixels) {
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glPopAttrib() {
        GL11.glPopAttrib();
    }

    public static void glPushAttrib(int mask) {
        GL11.glPushAttrib((int)mask);
    }

    public static void glScissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static int glGenFramebuffers() {
        return GL30.glGenFramebuffers();
    }

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        GL30.glBindFramebuffer((int)target, (int)framebuffer);
    }

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public static int glGenRenderbuffers() {
        return GL30.glGenRenderbuffers();
    }

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
    }

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GL30.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
    }

    public static int glCheckFramebufferStatus(int target) {
        return GL30.glCheckFramebufferStatus((int)target);
    }

    public static final class Utils {
        public static final class_289 TESSELLATOR = class_289.method_1348();
        public static final class_287 VERTEX_BUFFER = TESSELLATOR.method_1349();
        public static final IntBuffer DATA_BUFFER = class_311.method_1596((int)0x1000000).asIntBuffer();
        public static final class_1060 textureManager = VoxelConstants.getMinecraft().method_1531();
        public static int fboId = -1;
        public static int fboTextureId = -1;
        public static int previousFboId = -1;
        public static int previousFboIdRead = -1;
        public static int previousFboIdDraw = -1;

        private Utils() {
        }

        public static void setupFramebuffer() {
            previousFboId = OpenGL.glGetInteger(36006);
            fboId = OpenGL.glGenFramebuffers();
            fboTextureId = OpenGL.glGenTextures();
            int width = 512;
            int height = 512;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(4 * width * height));
            OpenGL.glBindFramebuffer(36160, fboId);
            OpenGL.glBindTexture(3553, fboTextureId);
            OpenGL.glTexParameteri(3553, 10242, 33071);
            OpenGL.glTexParameterf(3553, 10243, 33071.0f);
            OpenGL.glTexParameterf(3553, 10241, 9729.0f);
            OpenGL.glTexParameterf(3553, 10240, 9729.0f);
            OpenGL.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5120, buffer);
            OpenGL.glFramebufferTexture2D(36160, 36064, 3553, fboTextureId, 0);
            int rboId = OpenGL.glGenRenderbuffers();
            OpenGL.glBindRenderbuffer(36161, rboId);
            OpenGL.glRenderbufferStorage(36161, 33190, width, height);
            OpenGL.glFramebufferRenderbuffer(36160, 36096, 36161, rboId);
            OpenGL.glBindRenderbuffer(36009, 0);
            Utils.checkFramebufferStatus();
            OpenGL.glBindRenderbuffer(36009, previousFboId);
            GlStateManager._bindTexture((int)0);
        }

        public static void checkFramebufferStatus() {
            int status = OpenGL.glCheckFramebufferStatus(36160);
            if (status == 36053) {
                return;
            }
            switch (status) {
                case 36054: {
                    throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
                }
                case 36055: {
                    throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
                }
                case 36059: {
                    throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
                }
                case 36060: {
                    throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
                }
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status: " + status);
        }

        public static void bindFramebuffer() {
            previousFboId = OpenGL.glGetInteger(36006);
            previousFboIdRead = OpenGL.glGetInteger(36010);
            previousFboIdDraw = OpenGL.glGetInteger(36006);
            OpenGL.glBindFramebuffer(36160, fboId);
            OpenGL.glBindFramebuffer(36008, fboId);
            OpenGL.glBindFramebuffer(36009, fboId);
        }

        public static void unbindFramebuffer() {
            OpenGL.glBindFramebuffer(36160, previousFboId);
            OpenGL.glBindFramebuffer(36008, previousFboIdRead);
            OpenGL.glBindFramebuffer(36009, previousFboIdDraw);
        }

        public static void setMapWithScale(int x, int y, float scale) {
            Utils.setMap(x, y, (int)(128.0f * scale));
        }

        public static void setMap(float x, float y, int imageSize) {
            float scale = (float)imageSize / 4.0f;
            Utils.ldrawthree(x - scale, y + scale, 1.0, 0.0f, 1.0f);
            Utils.ldrawthree(x + scale, y + scale, 1.0, 1.0f, 1.0f);
            Utils.ldrawthree(x + scale, y - scale, 1.0, 1.0f, 0.0f);
            Utils.ldrawthree(x - scale, y - scale, 1.0, 0.0f, 0.0f);
        }

        public static void setMap(Sprite icon, float x, float y, float imageSize) {
            float half = imageSize / 4.0f;
            Utils.ldrawthree(x - half, y + half, 1.0, icon.getMinU(), icon.getMaxV());
            Utils.ldrawthree(x + half, y + half, 1.0, icon.getMaxU(), icon.getMaxV());
            Utils.ldrawthree(x + half, y - half, 1.0, icon.getMaxU(), icon.getMinV());
            Utils.ldrawthree(x - half, y - half, 1.0, icon.getMinU(), icon.getMinV());
        }

        public static int tex(BufferedImage image) {
            int glId = TextureUtil.generateTextureId();
            int width = image.getWidth();
            int height = image.getHeight();
            int[] data = new int[width * height];
            image.getRGB(0, 0, width, height, data, 0, width);
            OpenGL.glBindTexture(3553, glId);
            DATA_BUFFER.clear();
            DATA_BUFFER.put(data, 0, width * height);
            DATA_BUFFER.position(0).limit(width * height);
            OpenGL.glTexParameteri(3553, 10241, 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
            OpenGL.glPixelStorei(3314, 0);
            OpenGL.glPixelStorei(3316, 0);
            OpenGL.glPixelStorei(3315, 0);
            OpenGL.glTexImage2D(3553, 0, 6408, width, height, 0, 32993, 33639, DATA_BUFFER);
            return glId;
        }

        public static void img2(String param) {
            Utils.img2(new class_2960(param));
        }

        public static void img(class_2960 param) {
            textureManager.method_22813(param);
        }

        public static void img2(class_2960 param) {
            RenderSystem.setShaderTexture((int)0, (class_2960)param);
        }

        public static void disp(int param) {
            OpenGL.glBindTexture(3553, param);
        }

        public static void disp2(int param) {
            RenderSystem.setShaderTexture((int)0, (int)param);
        }

        public static void register(class_2960 resource, class_1044 image) {
            textureManager.method_4616(resource, image);
        }

        @NotNull
        public static class_1011 nativeImageFromBufferedImage(BufferedImage image) {
            int glId = Utils.tex(image);
            class_1011 nativeImage = new class_1011(image.getWidth(), image.getHeight(), false);
            RenderSystem.bindTexture((int)glId);
            nativeImage.method_4327(0, false);
            return nativeImage;
        }

        public static void drawPre() {
            Utils.drawPre(class_290.field_1585);
        }

        public static void drawPre(class_293 format) {
            VERTEX_BUFFER.method_1328(class_293.class_5596.field_27382, format);
        }

        public static void drawPost() {
            TESSELLATOR.method_1350();
        }

        public static void glah(int g) {
            OpenGL.glDeleteTexture(g);
        }

        public static void ldrawone(int x, int y, double z, float u, float v) {
            VERTEX_BUFFER.method_22912((double)x, (double)y, z).method_22913(u, v).method_1344();
        }

        public static void ldrawthree(double x, double y, double z, float u, float v) {
            VERTEX_BUFFER.method_22912(x, y, z).method_22913(u, v).method_1344();
        }
    }
}

