/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;

public final class TextUtils {
    private static final Pattern CODE_SCRUBBING_PATTERN = Pattern.compile("(\u00a7.)");

    private TextUtils() {
    }

    public static String scrubCodes(String string) {
        return CODE_SCRUBBING_PATTERN.matcher(string).replaceAll("");
    }

    @NotNull
    public static String scrubName(String input) {
        if (input == null) {
            return "";
        }
        return input.replace(",", "~comma~").replace(":", "~colon~");
    }

    @NotNull
    public static String scrubNameRegex(String input) {
        if (input == null) {
            return "";
        }
        return input.replace(',', '\ufe50').replace('[', '\u27e6').replace(']', '\u27e7');
    }

    @NotNull
    public static String scrubNameFile(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("<", "~less~").replace(">", "~greater~").replace(":", "~colon~").replace("\"", "~quote~").replace("/", "~slash~").replace("\\", "~backslash~").replace("|", "~pipe~").replace("?", "~question~").replace("*", "~star~");
    }

    @NotNull
    public static String descrubName(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("~less~", "<").replace("~greater~", ">").replace("~colon~", ":").replace("~quote~", "\"").replace("~slash~", "/").replace("~backslash~", "\\").replace("~pipe~", "|").replace("~question~", "?").replace("~star~", "*").replace("~comma~", ",").replace("~colon~", ":").replace('\ufe50', ',').replace('\u27e6', '[').replace('\u27e7', ']');
    }

    @NotNull
    public static String prettify(String input) {
        if (input == null) {
            return "";
        }
        return Arrays.stream(input.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    @NotNull
    public static String asFormattedString(class_2561 text2) {
        StringBuilder stringBuilder = new StringBuilder();
        String lastStyleString = "";
        for (class_2561 text : TextUtils.stream(text2)) {
            String contentString = text.getString();
            if (contentString.isEmpty()) continue;
            String styleString = TextUtils.asString(text.method_10866());
            if (styleString.equals(lastStyleString)) {
                stringBuilder.append(styleString);
                continue;
            }
            if (!lastStyleString.isEmpty()) {
                stringBuilder.append(class_124.field_1070);
            }
            stringBuilder.append(styleString);
            lastStyleString = styleString;
            stringBuilder.append(contentString);
        }
        if (!lastStyleString.isEmpty()) {
            stringBuilder.append(class_124.field_1070);
        }
        return stringBuilder.toString();
    }

    @NotNull
    private static List<class_2561> stream(class_2561 text) {
        ArrayList<class_2561> stream = new ArrayList<class_2561>();
        stream.add(text);
        for (class_2561 sibling : text.method_10855()) {
            stream.addAll(TextUtils.stream(sibling));
        }
        return stream;
    }

    @NotNull
    private static String asString(class_2583 style) {
        class_124 colorFormat;
        if (style == null || style.method_10967()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (style.method_10973() != null && (colorFormat = class_124.method_533((String)style.method_10973().method_27721())) != null) {
            stringBuilder.append(colorFormat);
        }
        if (style.method_10984()) {
            stringBuilder.append(class_124.field_1067);
        }
        if (style.method_10966()) {
            stringBuilder.append(class_124.field_1056);
        }
        if (style.method_10965()) {
            stringBuilder.append(class_124.field_1073);
        }
        if (style.method_10987()) {
            stringBuilder.append(class_124.field_1051);
        }
        if (style.method_10986()) {
            stringBuilder.append(class_124.field_1055);
        }
        return stringBuilder.toString();
    }
}

