/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.common;

import com.aayushatharva.brotli4j.common.CommonJNI;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BrotliCommon {
    public static final int RFC_DICTIONARY_SIZE = 122784;
    private static final byte[] RFC_DICTIONARY_MD5 = new byte[]{-106, -50, -51, 46, -25, -90, 102, -43, -86, 54, 39, -41, 71, 53, -77, 42};
    private static final byte[] RFC_DICTIONARY_SHA_1 = new byte[]{114, -76, 16, 81, -53, 97, -87, 40, 27, -93, -60, 65, 76, 40, -99, -91, 13, -102, 118, 64};
    private static final byte[] RFC_DICTIONARY_SHA_256 = new byte[]{32, -28, 46, -79, -75, 17, -62, 24, 6, -44, -46, 39, -48, 126, 93, -48, 104, 119, -40, -50, 123, 58, -127, 127, 55, -113, 49, 54, 83, -13, 92, 112};
    private static boolean isDictionaryDataSet;
    private static final Object mutex;

    public static boolean checkDictionaryDataMd5(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_MD5, digest);
    }

    public static boolean checkDictionaryDataSha1(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_SHA_1, digest);
    }

    public static boolean checkDictionaryDataSha256(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_SHA_256, digest);
    }

    public static ByteBuffer makeNative(byte[] data2) {
        ByteBuffer result2 = ByteBuffer.allocateDirect(data2.length);
        result2.put(data2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(byte[] data2) {
        if (data2.length != 122784) {
            throw new IllegalArgumentException("invalid dictionary size");
        }
        Object object = mutex;
        synchronized (object) {
            if (isDictionaryDataSet) {
                return;
            }
            BrotliCommon.setDictionaryData(BrotliCommon.makeNative(data2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(InputStream src) throws IOException {
        Object object = mutex;
        synchronized (object) {
            int readBytes2;
            if (isDictionaryDataSet) {
                return;
            }
            ByteBuffer copy2 = ByteBuffer.allocateDirect(122784);
            byte[] buffer = new byte[4096];
            while ((readBytes2 = src.read(buffer)) != -1) {
                if (copy2.remaining() < readBytes2) {
                    throw new IllegalArgumentException("invalid dictionary size");
                }
                copy2.put(buffer, 0, readBytes2);
            }
            if (copy2.remaining() != 0) {
                throw new IllegalArgumentException("invalid dictionary size " + copy2.remaining());
            }
            BrotliCommon.setDictionaryData(copy2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(ByteBuffer data2) {
        if (!data2.isDirect()) {
            throw new IllegalArgumentException("direct byte buffer is expected");
        }
        if (data2.capacity() != 122784) {
            throw new IllegalArgumentException("invalid dictionary size");
        }
        Object object = mutex;
        synchronized (object) {
            if (isDictionaryDataSet) {
                return;
            }
            if (!CommonJNI.nativeSetDictionaryData(data2)) {
                throw new RuntimeException("setting dictionary failed");
            }
            isDictionaryDataSet = true;
        }
    }

    static {
        mutex = new Object();
    }
}

