/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.PreparedDictionary;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class PreparedDictionaryGenerator {
    private static final int MAGIC = -558043680;
    private static final long HASH_MULTIPLIER = 2297779722762296275L;

    private PreparedDictionaryGenerator() {
    }

    public static PreparedDictionary generate(ByteBuffer src) {
        return PreparedDictionaryGenerator.generate(src, 17, 3, 40, 5);
    }

    public static PreparedDictionary generate(ByteBuffer src, int bucketBits, int slotBits, int hashBits, int blockBits) {
        int i2;
        int i3;
        ((Buffer)src).clear();
        if (blockBits > 12) {
            throw new IllegalArgumentException("blockBits is too big");
        }
        if (bucketBits >= 24) {
            throw new IllegalArgumentException("bucketBits is too big");
        }
        if (bucketBits - slotBits >= 16) {
            throw new IllegalArgumentException("slotBits is too small");
        }
        int bucketLimit = 1 << blockBits;
        int numBuckets = 1 << bucketBits;
        int numSlots = 1 << slotBits;
        int slotMask = numSlots - 1;
        int hashShift = 64 - bucketBits;
        long hashMask = -1L >>> 64 - hashBits;
        int sourceSize = src.capacity();
        if (sourceSize < 8) {
            throw new IllegalArgumentException("src is too short");
        }
        short[] num = new short[numBuckets];
        int[] bucketHeads = new int[numBuckets];
        int[] nextBucket = new int[sourceSize];
        long accumulator = 0L;
        for (i3 = 0; i3 < 7; ++i3) {
            accumulator |= ((long)src.get(i3) & 0xFFL) << 8 * i3;
        }
        accumulator <<= 8;
        i3 = 0;
        while (i3 + 7 < sourceSize) {
            long h2 = ((accumulator = accumulator >>> 8 | ((long)src.get(i3 + 7) & 0xFFL) << 56) & hashMask) * 2297779722762296275L;
            int key2 = (int)(h2 >>> hashShift);
            int count2 = num[key2];
            nextBucket[i3] = count2 == 0 ? -1 : bucketHeads[key2];
            bucketHeads[key2] = i3;
            if (++count2 > bucketLimit) {
                count2 = bucketLimit;
            }
            num[key2] = (short)count2;
            ++i3;
        }
        int[] slotLimit = new int[numSlots];
        int[] slotSize = new int[numSlots];
        int totalItems = 0;
        block2: for (int i4 = 0; i4 < numSlots; ++i4) {
            boolean overflow = false;
            slotLimit[i4] = bucketLimit;
            while (true) {
                overflow = false;
                int limit = slotLimit[i4];
                int count3 = 0;
                for (int j = i4; j < numBuckets; j += numSlots) {
                    int size2 = num[j];
                    if (count3 >= 65535) {
                        overflow = true;
                        break;
                    }
                    if (size2 > limit) {
                        size2 = limit;
                    }
                    count3 += size2;
                }
                if (!overflow) {
                    slotSize[i4] = count3;
                    totalItems += count3;
                    continue block2;
                }
                int n = i4;
                slotLimit[n] = slotLimit[n] - 1;
            }
        }
        int part0 = 24;
        int part1 = numSlots * 4;
        int part2 = numBuckets * 2;
        int part3 = totalItems * 4;
        int allocSize = part0 + part1 + part2 + part3 + sourceSize;
        ByteBuffer flat = ByteBuffer.allocateDirect(allocSize);
        ByteBuffer pointer = flat.slice();
        pointer.order(ByteOrder.nativeOrder());
        IntBuffer struct = pointer.asIntBuffer();
        pointer.position(pointer.position() + part0);
        IntBuffer slotOffsets = pointer.asIntBuffer();
        pointer.position(pointer.position() + part1);
        ShortBuffer heads = pointer.asShortBuffer();
        pointer.position(pointer.position() + part2);
        IntBuffer items2 = pointer.asIntBuffer();
        pointer.position(pointer.position() + part3);
        ByteBuffer sourceCopy = pointer.slice();
        struct.put(0, -558043680);
        struct.put(1, totalItems);
        struct.put(2, sourceSize);
        struct.put(3, hashBits);
        struct.put(4, bucketBits);
        struct.put(5, slotBits);
        totalItems = 0;
        for (i2 = 0; i2 < numSlots; ++i2) {
            slotOffsets.put(i2, totalItems);
            totalItems += slotSize[i2];
            slotSize[i2] = 0;
        }
        for (i2 = 0; i2 < numBuckets; ++i2) {
            int count4 = num[i2];
            int slot = i2 & slotMask;
            if (count4 > slotLimit[slot]) {
                count4 = slotLimit[slot];
            }
            if (count4 == 0) {
                heads.put(i2, (short)-1);
                continue;
            }
            int cursor = slotSize[slot];
            heads.put(i2, (short)cursor);
            cursor += slotOffsets.get(slot);
            int n = slot;
            slotSize[n] = slotSize[n] + count4;
            int pos = bucketHeads[i2];
            for (int j = 0; j < count4; ++j) {
                items2.put(cursor++, pos);
                pos = nextBucket[pos];
            }
            items2.put(--cursor, items2.get(cursor) | Integer.MIN_VALUE);
        }
        sourceCopy.put(src);
        return new PreparedDictionaryImpl(flat);
    }

    private static class PreparedDictionaryImpl
    implements PreparedDictionary {
        private final ByteBuffer data;

        private PreparedDictionaryImpl(ByteBuffer data2) {
            this.data = data2;
        }

        @Override
        public ByteBuffer getData() {
            return this.data;
        }
    }
}

