/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements.formatting.impl;

import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.formatting.FormattingElement;
import dev.dediamondpro.minemark.style.Style;
import dev.dediamondpro.minemark.utils.ColorFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class CssStyleElement<S extends Style, R>
implements FormattingElement<S, R> {
    protected final List<String> supportedProperties = new ArrayList<String>(){
        {
            this.add("color");
            this.add("text-align");
            this.add("text-decoration");
            this.add("font-size");
        }
    };

    @Override
    public void applyStyle(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes2) {
        String[] parts;
        String inlineCss = attributes2.getValue("style");
        if (inlineCss == null) {
            return;
        }
        block30: for (String part2 : parts = inlineCss.split(";")) {
            String[] propertyValue = part2.split(":");
            if (propertyValue.length != 2) continue;
            String property2 = propertyValue[0].trim();
            String value = propertyValue[1].trim();
            switch (property2) {
                case "color": {
                    layoutStyle.setTextColor(ColorFactory.web(value));
                    continue block30;
                }
                case "text-align": {
                    switch (value.toLowerCase()) {
                        case "left": {
                            layoutStyle.setAlignment(LayoutStyle.Alignment.LEFT);
                            break;
                        }
                        case "center": {
                            layoutStyle.setAlignment(LayoutStyle.Alignment.CENTER);
                            break;
                        }
                        case "right": {
                            layoutStyle.setAlignment(LayoutStyle.Alignment.RIGHT);
                        }
                    }
                    continue block30;
                }
                case "text-decoration": {
                    String[] stringArray = value.split(" ");
                    int n = stringArray.length;
                    block31: for (int j = 0; j < n; ++j) {
                        String decoration;
                        switch (decoration = stringArray[j]) {
                            case "underline": {
                                layoutStyle.setUnderlined(true);
                                continue block31;
                            }
                            case "line-through": {
                                layoutStyle.setStrikethrough(true);
                            }
                        }
                    }
                    continue block30;
                }
                case "font-size": {
                    Float fontSize = null;
                    if (value.endsWith("px")) {
                        fontSize = Float.valueOf(style.getTextStyle().adaptFontSize(Float.parseFloat(value.substring(0, value.length() - 2))));
                    } else if (value.endsWith("%")) {
                        fontSize = Float.valueOf(layoutStyle.getFontSize() * (Float.parseFloat(value.substring(0, value.length() - 1)) / 100.0f));
                    }
                    if (fontSize == null) continue block30;
                    layoutStyle.setFontSize(fontSize.floatValue());
                }
            }
        }
    }

    @Override
    public boolean canBeInline(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes2) {
        return !attributes2.getValue("style").contains("text-align");
    }

    @Override
    public boolean appliesTo(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes2) {
        String styleCss = attributes2.getValue("style");
        if (styleCss == null) {
            return false;
        }
        for (String property2 : this.supportedProperties) {
            if (!styleCss.contains(property2)) continue;
            return true;
        }
        return false;
    }
}

