/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements.impl;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.BasicElement;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.Inline;
import dev.dediamondpro.minemark.providers.ImageProvider;
import dev.dediamondpro.minemark.style.Style;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class ImageElement<S extends Style, R, I>
extends BasicElement<S, R>
implements Inline {
    private static final Pattern pixelPattern = Pattern.compile("^\\d+(px)?$");
    protected float imageWidth = -1.0f;
    protected float imageHeight = -1.0f;
    protected float width;
    protected float height;
    protected final String src;
    protected I image = null;

    public ImageElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes2) {
        super(style, layoutStyle, parent, qName, attributes2);
        assert (attributes2 != null);
        this.src = attributes2.getValue("src");
        ImageProvider<?> imageProvider = style.getImageStyle().getImageProvider();
        imageProvider.getImage(this.src, this::onDimensionsReceived, this::onImageReceived);
    }

    protected void onDimensionsReceived(ImageProvider.Dimension dimension) {
        this.imageWidth = dimension.getWidth();
        this.imageHeight = dimension.getHeight();
        this.regenerateLayout();
    }

    protected void onImageReceived(I image) {
        this.image = image;
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        this.calculateDimensions(layoutData);
        super.generateLayout(layoutData, renderData);
    }

    @Override
    protected void drawElement(float x, float y, float width, float height, R renderData) {
        if (this.image == null) {
            return;
        }
        this.drawImage(this.image, x, y, width, height, renderData);
    }

    public abstract void drawImage(I var1, float var2, float var3, float var4, float var5, R var6);

    @Override
    protected float getWidth(LayoutData layoutData, R renderData) {
        return this.width;
    }

    @Override
    protected float getHeight(LayoutData layoutData, R renderData) {
        return this.height;
    }

    protected void calculateDimensions(LayoutData layoutData) {
        if (this.width > 0.0f && this.height > 0.0f) {
            return;
        }
        this.width = -1.0f;
        this.height = -1.0f;
        String desiredWidth = this.attributes.getValue("width");
        String desiredHeight = this.attributes.getValue("height");
        if (desiredHeight != null && pixelPattern.matcher(desiredHeight).matches()) {
            this.height = Float.parseFloat(desiredHeight.replaceAll("[^0-9]", ""));
        }
        if (desiredWidth != null) {
            if (pixelPattern.matcher(desiredWidth).matches()) {
                this.width = Float.parseFloat(desiredWidth.replaceAll("[^0-9]", ""));
            } else if (desiredWidth.endsWith("%")) {
                this.width = Float.parseFloat(desiredWidth.replaceAll("[^0-9]", "")) / 100.0f * layoutData.getMaxWidth();
            }
            if (this.width > layoutData.getMaxWidth()) {
                this.width = layoutData.getMaxWidth();
                this.height = -1.0f;
            }
        }
        if (this.width != -1.0f && this.height != -1.0f) {
            return;
        }
        if (this.imageWidth == -1.0f || this.imageHeight == -1.0f) {
            if (this.width == -1.0f) {
                this.width = 0.0f;
            }
            if (this.height == -1.0f) {
                this.height = 0.0f;
            }
            return;
        }
        if (this.width == -1.0f && this.height == -1.0f) {
            this.width = Math.min(this.imageWidth, layoutData.getMaxWidth());
        }
        if (this.width == -1.0f) {
            this.width = this.height * this.imageWidth / this.imageHeight;
        }
        if (this.height == -1.0f) {
            this.height = this.width * this.imageHeight / this.imageWidth;
        }
    }

    public String toString() {
        return "ImageElement {" + this.src + ", " + this.width + "x" + this.height + "}";
    }
}

