/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements.impl.list;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.ChildMovingElement;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.impl.list.ListHolderElement;
import dev.dediamondpro.minemark.style.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class ListElement<S extends Style, R>
extends ChildMovingElement<S, R> {
    protected final ListHolderElement.ListType listType;
    protected final int elementIndex;
    protected float actualMarkerWidth;

    public ListElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes2) {
        super(style, layoutStyle, parent, qName, attributes2);
        if (!(parent instanceof ListHolderElement)) {
            this.listType = ListHolderElement.ListType.UNORDERED;
            this.elementIndex = 0;
        } else {
            ListHolderElement holder = (ListHolderElement)parent;
            this.listType = holder.getListType();
            this.elementIndex = holder.getChildren().indexOf(this);
        }
    }

    @Override
    protected float getOutsidePadding(LayoutData layoutData, R renderData) {
        return this.style.getTextStyle().getPadding();
    }

    @Override
    protected ChildMovingElement.MarkerType getMarkerType() {
        return ChildMovingElement.MarkerType.ONE_LINE;
    }

    @Override
    protected final void drawMarker(float x, float y, float markerWidth, float totalHeight, R renderData) {
        this.drawMarker(x + markerWidth - this.actualMarkerWidth, y, renderData);
    }

    @Override
    protected final float getMarkerWidth(LayoutData layoutData, R renderData) {
        this.actualMarkerWidth = this.getListMarkerWidth(layoutData, renderData);
        return Math.max(this.actualMarkerWidth, this.style.getListStyle().getIndentation());
    }

    protected abstract void drawMarker(float var1, float var2, R var3);

    protected abstract float getListMarkerWidth(LayoutData var1, R var2);
}

