/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl;

import gg.skytils.asmhelper.dsl.code.InjectCodeBuilder;
import gg.skytils.asmhelper.dsl.instructions.InsnListBuilder;
import gg.skytils.asmhelper.printing.PrintingKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006JF\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0019\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\b\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lgg/skytils/asmhelper/dsl/AsmWriter;", "", "Lorg/objectweb/asm/tree/ClassNode;", "classNode", "", "transform", "(Lorg/objectweb/asm/tree/ClassNode;)V", "Lkotlin/Function1;", "Lgg/skytils/asmhelper/dsl/instructions/InsnListBuilder;", "Lkotlin/ExtensionFunctionType;", "insnListBuilder", "", "codeBlockClassName", "Lorg/objectweb/asm/tree/MethodNode;", "method", "Lorg/objectweb/asm/tree/InsnList;", "transformToInstructions", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lorg/objectweb/asm/tree/MethodNode;Lorg/objectweb/asm/tree/ClassNode;)Lorg/objectweb/asm/tree/InsnList;", "className", "Ljava/lang/String;", "getClassName", "()Ljava/lang/String;", "<init>", "(Ljava/lang/String;)V", "AsmWriterBuilder", "AsmHelper1.8.9"})
public abstract class AsmWriter {
    @NotNull
    private final String className;

    public AsmWriter(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className = className;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public abstract void transform(@NotNull ClassNode var1);

    @Nullable
    protected final InsnList transformToInstructions(@Nullable Function1<? super InsnListBuilder, Unit> insnListBuilder, @Nullable String codeBlockClassName, @NotNull MethodNode method2, @NotNull ClassNode classNode) {
        InsnList insnList;
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        if (insnListBuilder != null && codeBlockClassName != null) {
            PrintingKt.getLogger().error(this + " specifies both an insnList and a codeBlock, please pick one or the other.");
            insnList = null;
        } else if (insnListBuilder != null) {
            InsnListBuilder builder = new InsnListBuilder(method2);
            Function1<? super InsnListBuilder, Unit> function1 = insnListBuilder;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super InsnListBuilder, Unit> it = function1;
            boolean bl3 = false;
            it.invoke((Object)builder);
            insnList = builder.build();
        } else if (codeBlockClassName != null) {
            String clazzPath = Intrinsics.stringPlus((String)StringsKt.replace$default((String)codeBlockClassName, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)".class");
            InputStream clazzInputStream = this.getClass().getClassLoader().getResourceAsStream(clazzPath);
            ClassReader clazzReader = new ClassReader(clazzInputStream);
            ClassNode codeClassNode = new ClassNode();
            clazzReader.accept((ClassVisitor)codeClassNode, 4);
            InjectCodeBuilder codeBuilder = new InjectCodeBuilder(codeClassNode, classNode, method2);
            insnList = codeBuilder.transformToInstructions();
        } else {
            PrintingKt.getLogger().error(this + " does not have instructions to inject. You must specify an insnList or codeBlock.");
            insnList = null;
        }
        return insnList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u00028\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lgg/skytils/asmhelper/dsl/AsmWriter$AsmWriterBuilder;", "", "", "fullMcVersion", "I", "getFullMcVersion", "()I", "mcVersion", "getMcVersion", "<init>", "()V", "AsmHelper1.8.9"})
    public static abstract class AsmWriterBuilder {
        private final int fullMcVersion;
        private final int mcVersion;

        public AsmWriterBuilder() {
            this.fullMcVersion = 10809;
            this.mcVersion = 8;
        }

        public final int getFullMcVersion() {
            return this.fullMcVersion;
        }

        public final int getMcVersion() {
            return this.mcVersion;
        }
    }
}

