/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl.code.modifiers;

import gg.skytils.asmhelper.AsmHelper;
import gg.skytils.asmhelper.dsl.code.modifiers.Analyzer;
import gg.skytils.asmhelper.dsl.code.modifiers.ShadowedModifier;
import gg.skytils.asmhelper.printing.PrettyprintingKt;
import gg.skytils.asmhelper.printing.PrintingKt;
import java.util.Arrays;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0016\u001a\u00020\u0006\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lgg/skytils/asmhelper/dsl/code/modifiers/ShadowedMethodModifier;", "Lgg/skytils/asmhelper/dsl/code/modifiers/ShadowedModifier;", "Lorg/objectweb/asm/tree/InsnList;", "instructions", "Lorg/objectweb/asm/tree/FieldInsnNode;", "node", "", "shadowedName", "", "manipulateShadowedMethodCall", "(Lorg/objectweb/asm/tree/InsnList;Lorg/objectweb/asm/tree/FieldInsnNode;Ljava/lang/String;)V", "modifyFieldNode", "Lorg/objectweb/asm/tree/MethodNode;", "codeBlockMethod", "Lorg/objectweb/asm/tree/MethodNode;", "getCodeBlockMethod", "()Lorg/objectweb/asm/tree/MethodNode;", "Lorg/objectweb/asm/tree/ClassNode;", "targetClassNode", "Lorg/objectweb/asm/tree/ClassNode;", "getTargetClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "codeBlockClass", "<init>", "(Ljava/lang/String;Lorg/objectweb/asm/tree/ClassNode;Lorg/objectweb/asm/tree/MethodNode;)V", "AsmHelper1.8.9"})
public final class ShadowedMethodModifier
extends ShadowedModifier {
    @NotNull
    private final ClassNode targetClassNode;
    @NotNull
    private final MethodNode codeBlockMethod;

    public ShadowedMethodModifier(@NotNull String codeBlockClass, @NotNull ClassNode targetClassNode, @NotNull MethodNode codeBlockMethod) {
        Intrinsics.checkNotNullParameter((Object)codeBlockClass, (String)"codeBlockClass");
        Intrinsics.checkNotNullParameter((Object)targetClassNode, (String)"targetClassNode");
        Intrinsics.checkNotNullParameter((Object)codeBlockMethod, (String)"codeBlockMethod");
        super(codeBlockClass);
        this.targetClassNode = targetClassNode;
        this.codeBlockMethod = codeBlockMethod;
    }

    @NotNull
    public final ClassNode getTargetClassNode() {
        return this.targetClassNode;
    }

    @NotNull
    public final MethodNode getCodeBlockMethod() {
        return this.codeBlockMethod;
    }

    @Override
    public void modifyFieldNode(@NotNull InsnList instructions, @NotNull FieldInsnNode node, @NotNull String shadowedName) {
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)shadowedName, (String)"shadowedName");
        String string = node.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.desc");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"kotlin/jvm/functions/", (boolean)false, (int)2, null)) {
            this.manipulateShadowedMethodCall(instructions, node, shadowedName);
            return;
        }
    }

    private final void manipulateShadowedMethodCall(InsnList instructions, FieldInsnNode node, String shadowedName) {
        MethodInsnNode methodInsnNode;
        String mappedMethodName;
        String methodName;
        boolean bl;
        int n;
        String string;
        Type type;
        boolean bl2;
        String string2;
        PrintingKt.verbose(Intrinsics.stringPlus((String)PrettyprintingKt.prettyString((AbstractInsnNode)node), (Object)" looks to be a shadowed method. Transforming now..."));
        AbstractInsnNode searchNode = node.getNext();
        MethodInsnNode finalCall = null;
        while (true) {
            if (searchNode instanceof MethodInsnNode && ((MethodInsnNode)searchNode).itf && Intrinsics.areEqual((Object)((MethodInsnNode)searchNode).name, (Object)"invoke")) {
                string2 = node.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.desc");
                int n2 = 1;
                int n3 = node.desc.length() - 1;
                bl2 = false;
                String string3 = string2.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string3, (Object)((MethodInsnNode)searchNode).owner)) break;
            }
            if (searchNode instanceof MethodInsnNode) {
                string2 = ((MethodInsnNode)searchNode).owner;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"searchNode.owner");
                if (StringsKt.startsWith$default((String)string2, (String)"java/lang", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)((MethodInsnNode)searchNode).name, (Object)"valueOf")) {
                    PrintingKt.verbose("Found primitive -> wrapper call, likely an artifact from Kotlin's boxing, so let's toss it.");
                    string2 = searchNode;
                    PrintingKt.verbose(PrettyprintingKt.prettyString((AbstractInsnNode)string2));
                    AbstractInsnNode tmp = ((MethodInsnNode)searchNode).getNext();
                    instructions.remove(searchNode);
                    searchNode = tmp;
                    continue;
                }
            }
            searchNode = searchNode.getNext();
        }
        string2 = searchNode;
        finalCall = (MethodInsnNode)string2;
        int numberOfArguments = Type.getArgumentTypes((String)finalCall.desc).length;
        Analyzer analyzer = new Analyzer(instructions, this.codeBlockMethod);
        AbstractInsnNode abstractInsnNode = node.getNext();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"node.next");
        Deque<Type> analyzedFrame = analyzer.analyze(abstractInsnNode, (AbstractInsnNode)finalCall);
        Object[] argumentTypes = new Type[numberOfArguments];
        bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = numberOfArguments;
        while (n4 < n5) {
            int index = n4++;
            boolean bl3 = false;
            argumentTypes[index] = analyzedFrame.pop();
        }
        ArraysKt.reverse((Object[])argumentTypes);
        PrintingKt.verbose(Intrinsics.stringPlus((String)"Theoretically, the stack would look like this when the method is called: ", (Object)ArraysKt.toList((Object[])argumentTypes)));
        PrintingKt.verbose("We want the top " + numberOfArguments + " from it.");
        AbstractInsnNode returnTypeIndicator = finalCall.getNext();
        if (returnTypeIndicator instanceof TypeInsnNode) {
            Type rawType = Type.getObjectType((String)((TypeInsnNode)returnTypeIndicator).desc);
            Intrinsics.checkNotNullExpressionValue((Object)rawType, (String)"rawType");
            type = this.wrappedTypeToPrimitive(rawType);
        } else {
            type = Type.VOID_TYPE;
        }
        Type returnType = type;
        PrintingKt.verbose(Intrinsics.stringPlus((String)"The return type is believed to be ", (Object)returnType));
        String syntheticMethodDesc = Type.getMethodDescriptor((Type)returnType, (Type[])((Type[])Arrays.copyOf(argumentTypes, argumentTypes.length)));
        PrintingKt.verbose(Intrinsics.stringPlus((String)"Synthetic method description has been formed: ", (Object)syntheticMethodDesc));
        if (StringsKt.startsWith$default((String)shadowedName, (String)"super", (boolean)false, (int)2, null)) {
            String string4;
            string = shadowedName;
            n = 5;
            bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string = string6;
            n = 0;
            bl = false;
            String it = string;
            boolean bl4 = false;
            if (StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)) {
                String string7 = it;
                int n6 = 1;
                boolean bl5 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n6);
                string4 = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string4 = StringsKt.decapitalize((String)it);
            }
            methodName = string4;
            mappedMethodName = AsmHelper.INSTANCE.getRemapper().mapInvocation(methodName);
            methodInsnNode = new MethodInsnNode(183, this.targetClassNode.superName, mappedMethodName, syntheticMethodDesc, false);
        } else {
            String string10;
            if (StringsKt.startsWith$default((String)shadowedName, (String)"_super", (boolean)false, (int)2, null)) {
                mappedMethodName = shadowedName;
                n = 1;
                bl = false;
                String string11 = mappedMethodName;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(n);
                string10 = string12;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string10 = shadowedName;
            }
            methodName = string10;
            mappedMethodName = AsmHelper.INSTANCE.getRemapper().mapInvocation(methodName);
            methodInsnNode = new MethodInsnNode(182, this.targetClassNode.name, mappedMethodName, syntheticMethodDesc, false);
        }
        MethodInsnNode methodCall = methodInsnNode;
        PrintingKt.verbose(Intrinsics.stringPlus((String)"- ", (Object)PrettyprintingKt.prettyString((AbstractInsnNode)node)));
        instructions.remove((AbstractInsnNode)node);
        instructions.insertBefore((AbstractInsnNode)finalCall, (AbstractInsnNode)methodCall);
        instructions.remove((AbstractInsnNode)finalCall);
        PrintingKt.verbose(Intrinsics.stringPlus((String)"- ", (Object)PrettyprintingKt.prettyString((AbstractInsnNode)finalCall)));
        PrintingKt.verbose(Intrinsics.stringPlus((String)"+ ", (Object)PrettyprintingKt.prettyString((AbstractInsnNode)methodCall)));
        AbstractInsnNode possibleWrapperToPrim = returnTypeIndicator.getNext();
        Intrinsics.checkNotNullExpressionValue((Object)returnTypeIndicator, (String)"returnTypeIndicator");
        PrintingKt.verbose(Intrinsics.stringPlus((String)"- ", (Object)PrettyprintingKt.prettyString(returnTypeIndicator)));
        instructions.remove(returnTypeIndicator);
        if (possibleWrapperToPrim instanceof MethodInsnNode) {
            string = ((MethodInsnNode)possibleWrapperToPrim).owner;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"possibleWrapperToPrim.owner");
            if (StringsKt.startsWith$default((String)string, (String)"java/lang/", (boolean)false, (int)2, null)) {
                string = ((MethodInsnNode)possibleWrapperToPrim).name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"possibleWrapperToPrim.name");
                if (StringsKt.endsWith$default((String)string, (String)"Value", (boolean)false, (int)2, null)) {
                    string = ((MethodInsnNode)possibleWrapperToPrim).desc;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"possibleWrapperToPrim.desc");
                    if (StringsKt.startsWith$default((String)string, (String)"()", (boolean)false, (int)2, null)) {
                        PrintingKt.verbose(Intrinsics.stringPlus((String)"- ", (Object)PrettyprintingKt.prettyString(possibleWrapperToPrim)));
                        instructions.remove(possibleWrapperToPrim);
                    }
                }
            }
        }
    }
}

