/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.client.plugins;

import gg.skytils.ktor.client.plugins.HttpTimeout;
import gg.skytils.ktor.client.request.HttpRequestBuilder;
import gg.skytils.ktor.client.request.HttpRequestData;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bB\u0019\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\r\u00a8\u0006\u000e"}, d2={"Lgg/skytils/ktor/client/plugins/HttpRequestTimeoutException;", "Ljava/io/IOException;", "Lgg/skytils/ktor/utils/io/errors/IOException;", "Lgg/skytils/ktor/client/request/HttpRequestBuilder;", "request", "<init>", "(Lio/ktor/client/request/HttpRequestBuilder;)V", "Lgg/skytils/ktor/client/request/HttpRequestData;", "(Lio/ktor/client/request/HttpRequestData;)V", "", "url", "", "timeoutMillis", "(Ljava/lang/String;Ljava/lang/Long;)V", "ktor-client-core"})
public final class HttpRequestTimeoutException
extends IOException {
    public HttpRequestTimeoutException(@NotNull String url2, @Nullable Long timeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        StringBuilder stringBuilder = new StringBuilder().append("Request timeout has expired [url=").append(url2).append(", request_timeout=");
        Object object = timeoutMillis;
        if (object == null) {
            object = "unknown";
        }
        super(stringBuilder.append(object).append(" ms]").toString());
    }

    public HttpRequestTimeoutException(@NotNull HttpRequestBuilder request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        this(request2.getUrl().buildString(), httpTimeoutCapabilityConfiguration != null ? httpTimeoutCapabilityConfiguration.getRequestTimeoutMillis() : null);
    }

    public HttpRequestTimeoutException(@NotNull HttpRequestData request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)request2.getCapabilityOrNull(HttpTimeout.Plugin);
        this(request2.getUrl().toString(), httpTimeoutCapabilityConfiguration != null ? httpTimeoutCapabilityConfiguration.getRequestTimeoutMillis() : null);
    }
}

