/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.tls;

import gg.skytils.ktor.network.tls.CIOCipherSuites;
import gg.skytils.ktor.network.tls.CertificateAndKey;
import gg.skytils.ktor.network.tls.CipherSuite;
import gg.skytils.ktor.network.tls.TLSConfig;
import gg.skytils.ktor.network.tls.TLSConfigBuilderKt;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b'\u0010(J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR.\u0010!\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lgg/skytils/ktor/network/tls/TLSConfigBuilder;", "", "Lgg/skytils/ktor/network/tls/TLSConfig;", "build", "()Lgg/skytils/ktor/network/tls/TLSConfig;", "", "Lgg/skytils/ktor/network/tls/CertificateAndKey;", "certificates", "Ljava/util/List;", "getCertificates", "()Ljava/util/List;", "", "Lgg/skytils/ktor/network/tls/CipherSuite;", "cipherSuites", "getCipherSuites", "setCipherSuites", "(Ljava/util/List;)V", "Ljava/security/SecureRandom;", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "setRandom", "(Ljava/security/SecureRandom;)V", "", "serverName", "Ljava/lang/String;", "getServerName", "()Ljava/lang/String;", "setServerName", "(Ljava/lang/String;)V", "Ljavax/net/ssl/TrustManager;", "value", "trustManager", "Ljavax/net/ssl/TrustManager;", "getTrustManager", "()Ljavax/net/ssl/TrustManager;", "setTrustManager", "(Ljavax/net/ssl/TrustManager;)V", "<init>", "()V", "ktor-network-tls"})
public final class TLSConfigBuilder {
    @NotNull
    private final List<CertificateAndKey> certificates = new ArrayList();
    @Nullable
    private SecureRandom random;
    @Nullable
    private TrustManager trustManager;
    @NotNull
    private List<CipherSuite> cipherSuites = CIOCipherSuites.INSTANCE.getSupportedSuites();
    @Nullable
    private String serverName;

    @NotNull
    public final List<CertificateAndKey> getCertificates() {
        return this.certificates;
    }

    @Nullable
    public final SecureRandom getRandom() {
        return this.random;
    }

    public final void setRandom(@Nullable SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Nullable
    public final TrustManager getTrustManager() {
        return this.trustManager;
    }

    public final void setTrustManager(@Nullable TrustManager value) {
        TrustManager trustManager2 = value;
        if (trustManager2 != null) {
            TrustManager it = trustManager2;
            boolean bl = false;
            if (!(it instanceof X509TrustManager)) {
                boolean bl2 = false;
                String string = "Failed to set [trustManager]: " + value + ". Only [X509TrustManager] supported.";
                throw new IllegalStateException(string.toString());
            }
        }
        this.trustManager = value;
    }

    @NotNull
    public final List<CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    public final void setCipherSuites(@NotNull List<CipherSuite> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.cipherSuites = list;
    }

    @Nullable
    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(@Nullable String string) {
        this.serverName = string;
    }

    @NotNull
    public final TLSConfig build() {
        TrustManager trustManager2;
        X509TrustManager x509TrustManager;
        SecureRandom secureRandom = this.random;
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        if ((x509TrustManager = (trustManager2 = this.trustManager) instanceof X509TrustManager ? (X509TrustManager)trustManager2 : null) == null) {
            x509TrustManager = TLSConfigBuilderKt.access$findTrustManager();
        }
        return new TLSConfig(secureRandom, this.certificates, x509TrustManager, this.cipherSuites, this.serverName);
    }
}

