/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.plugins.contentnegotiation;

import gg.skytils.ktor.http.BadContentTypeFormatException;
import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.HeaderValue;
import gg.skytils.ktor.http.HttpHeaderValueParserKt;
import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.plugins.BadRequestException;
import gg.skytils.ktor.server.plugins.contentnegotiation.ContentTypeWithQuality;
import gg.skytils.ktor.server.request.ApplicationRequestPropertiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a'\u0010\u0006\u001a\u00020\u00052\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\u00020\bH\u0000\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"", "Lgg/skytils/ktor/server/plugins/contentnegotiation/ContentTypeWithQuality;", "acceptItems", "Lgg/skytils/ktor/http/ContentType;", "contentType", "", "checkAcceptHeader", "(Ljava/util/List;Lgg/skytils/ktor/http/ContentType;)Z", "Lgg/skytils/ktor/server/application/ApplicationCall;", "parseAcceptHeader", "(Lgg/skytils/ktor/server/application/ApplicationCall;)Ljava/util/List;", "ktor-server-content-negotiation"})
@SourceDebugExtension(value={"SMAP\nContentNegotiationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1549#2:38\n1620#2,3:39\n1747#2,3:42\n*S KotlinDebug\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n*L\n24#1:38\n24#1:39,3\n35#1:42,3\n*E\n"})
public final class ContentNegotiationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentTypeWithQuality> parseAcceptHeader(@NotNull ApplicationCall $this$parseAcceptHeader) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$parseAcceptHeader, (String)"<this>");
        String acceptHeaderContent = ApplicationRequestPropertiesKt.header($this$parseAcceptHeader.getRequest(), HttpHeaders.INSTANCE.getAccept());
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = HttpHeaderValueParserKt.parseHeaderValue(acceptHeaderContent);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HeaderValue headerValue = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ContentTypeWithQuality(ContentType.Companion.parse(it.getValue()), it.getQuality()));
            }
            list = (List)destination$iv$iv;
        }
        catch (BadContentTypeFormatException parseFailure) {
            throw new BadRequestException("Illegal Accept header format: " + acceptHeaderContent, parseFailure);
        }
        return list;
    }

    public static final boolean checkAcceptHeader(@NotNull List<ContentTypeWithQuality> acceptItems, @Nullable ContentType contentType2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(acceptItems, (String)"acceptItems");
            if (acceptItems.isEmpty() || contentType2 == null) {
                return true;
            }
            Iterable $this$any$iv = acceptItems;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ContentTypeWithQuality it = (ContentTypeWithQuality)element$iv;
                    boolean bl2 = false;
                    if (!contentType2.match(it.getContentType())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

