/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.sessions.DirectoryStorageKt;
import gg.skytils.ktor.server.sessions.SessionStorage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lgg/skytils/ktor/server/sessions/DirectoryStorage;", "Lgg/skytils/ktor/server/sessions/SessionStorage;", "Ljava/io/Closeable;", "", "close", "()V", "", "id", "Ljava/io/File;", "fileOf", "(Ljava/lang/String;)Ljava/io/File;", "invalidate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "requireId", "(Ljava/lang/String;)V", "Lkotlin/sequences/Sequence;", "split", "(Ljava/lang/String;)Lkotlin/sequences/Sequence;", "value", "write", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nDirectoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryStorage.kt\nio/ktor/server/sessions/DirectoryStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class DirectoryStorage
implements SessionStorage,
Closeable {
    @NotNull
    private final File dir;

    public DirectoryStorage(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        DirectoryStorageKt.access$mkdirsOrFail(this.dir);
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public Object write(@NotNull String id, @NotNull String value, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        File file2 = this.fileOf(id);
        File file3 = file2.getParentFile();
        if (file3 != null) {
            DirectoryStorageKt.access$mkdirsOrFail(file3);
        }
        FilesKt.writeText$default((File)file2, (String)value, null, (int)2, null);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object read(@NotNull String id, @NotNull Continuation<? super String> $completion) {
        this.requireId(id);
        try {
            String string;
            File file2 = this.fileOf(id);
            File file3 = file2.getParentFile();
            if (file3 != null) {
                DirectoryStorageKt.access$mkdirsOrFail(file3);
            }
            String it = string = FilesKt.readText$default((File)file2, null, (int)1, null);
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) {
                throw new IllegalStateException("Failed to read stored session from " + file2);
            }
            return string2;
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
    }

    @Override
    @Nullable
    public Object invalidate(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        try {
            File file2 = this.fileOf(id);
            file2.delete();
            File file3 = file2.getParentFile();
            if (file3 != null) {
                DirectoryStorageKt.access$deleteParentsWhileEmpty(file3, this.dir);
            }
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException("No session data found for id " + id);
        }
        return Unit.INSTANCE;
    }

    private final File fileOf(String id) {
        Sequence<String> sequence = this.split(id);
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return new File(this.dir, SequencesKt.joinToString$default(sequence, (CharSequence)string, null, (CharSequence)".dat", (int)0, null, null, (int)58, null));
    }

    private final Sequence<String> split(String id) {
        return StringsKt.windowedSequence((CharSequence)id, (int)2, (int)2, (boolean)true);
    }

    private final void requireId(String id) {
        if (((CharSequence)id).length() == 0) {
            throw new IllegalArgumentException("Session id is empty");
        }
        Object[] objectArray = new String[]{"..", "/", "\\", "!", "?", ">", "<", "\u0000"};
        if (StringsKt.indexOfAny$default((CharSequence)id, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (boolean)false, (int)6, null) != -1) {
            throw new IllegalArgumentException("Bad session id " + id);
        }
    }
}

