/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.utils.io.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u001a\u001f\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\u000b\u001a\u00020\n*\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a%\u0010\u000f\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a%\u0010\u0012\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0010\u001a%\u0010\u0015\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"", "name", "", "default", "getIOIntProperty", "(Ljava/lang/String;I)I", "Ljava/nio/ByteBuffer;", "sub", "indexOfPartial", "(Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;)I", "", "isEmpty", "(Ljava/nio/ByteBuffer;)Z", "src", "n", "putAtMost", "(Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;I)I", "limit", "putLimited", "prefix", "prefixSkip", "startsWith", "(Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;I)Z", "ktor-io"})
public final class UtilsKt {
    public static final boolean isEmpty(@NotNull ByteBuffer $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return !$this$isEmpty.hasRemaining();
    }

    public static final int getIOIntProperty(@NotNull String name, int n) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            object = System.getProperty("gg.skytils.ktor.utils.io." + name);
        }
        catch (SecurityException e) {
            object = null;
        }
        String string = object;
        return string != null && (object = StringsKt.toIntOrNull(string)) != null ? (Integer)object : n;
    }

    public static final int indexOfPartial(@NotNull ByteBuffer $this$indexOfPartial, @NotNull ByteBuffer sub) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfPartial, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        int subPosition = sub.position();
        int subSize = sub.remaining();
        byte first2 = sub.get(subPosition);
        int limit = $this$indexOfPartial.limit();
        block0: for (int idx = $this$indexOfPartial.position(); idx < limit; ++idx) {
            if ($this$indexOfPartial.get(idx) != first2) continue;
            for (int j = 1; j < subSize && idx + j != limit; ++j) {
                if ($this$indexOfPartial.get(idx + j) != sub.get(subPosition + j)) continue block0;
            }
            return idx - $this$indexOfPartial.position();
        }
        return -1;
    }

    public static final boolean startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull ByteBuffer prefix2, int prefixSkip) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        int size2 = Math.min($this$startsWith.remaining(), prefix2.remaining() - prefixSkip);
        if (size2 <= 0) {
            return false;
        }
        int position = $this$startsWith.position();
        int prefixPosition = prefix2.position() + prefixSkip;
        for (int i2 = 0; i2 < size2; ++i2) {
            if ($this$startsWith.get(position + i2) == prefix2.get(prefixPosition + i2)) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean startsWith$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return UtilsKt.startsWith(byteBuffer, byteBuffer2, n);
    }

    public static final int putAtMost(@NotNull ByteBuffer $this$putAtMost, @NotNull ByteBuffer src, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$putAtMost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int rem = $this$putAtMost.remaining();
        int srcRem = src.remaining();
        if (srcRem <= rem && srcRem <= n) {
            $this$putAtMost.put(src);
            n2 = srcRem;
        } else {
            int idx = 1;
            int size2 = Math.min(rem, Math.min(srcRem, n));
            if (idx <= size2) {
                while (true) {
                    $this$putAtMost.put(src.get());
                    if (idx == size2) break;
                    ++idx;
                }
            }
            n2 = size2;
        }
        return n2;
    }

    public static /* synthetic */ int putAtMost$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer2.remaining();
        }
        return UtilsKt.putAtMost(byteBuffer, byteBuffer2, n);
    }

    public static final int putLimited(@NotNull ByteBuffer $this$putLimited, @NotNull ByteBuffer src, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$putLimited, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return UtilsKt.putAtMost($this$putLimited, src, limit - src.position());
    }

    public static /* synthetic */ int putLimited$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer.limit();
        }
        return UtilsKt.putLimited(byteBuffer, byteBuffer2, n);
    }
}

