/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json;

import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.builtins.BuiltinSerializersKt;
import gg.skytils.ktx-serialization.descriptors.PrimitiveKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptorsKt;
import gg.skytils.ktx-serialization.encoding.Decoder;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.ktx-serialization.json.JsonElement;
import gg.skytils.ktx-serialization.json.JsonElementSerializersKt;
import gg.skytils.ktx-serialization.json.JsonLiteral;
import gg.skytils.ktx-serialization.json.internal.JsonExceptionsKt;
import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgg/skytils/ktx-serialization/json/JsonLiteralSerializer;", "Lgg/skytils/ktx-serialization/KSerializer;", "Lgg/skytils/ktx-serialization/json/JsonLiteral;", "Lgg/skytils/ktx-serialization/encoding/Decoder;", "decoder", "deserialize", "(Lgg/skytils/ktx-serialization/encoding/Decoder;)Lgg/skytils/ktx-serialization/json/JsonLiteral;", "Lgg/skytils/ktx-serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lgg/skytils/ktx-serialization/encoding/Encoder;Lgg/skytils/ktx-serialization/json/JsonLiteral;)V", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "()V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJsonElementSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonElementSerializers.kt\nkotlinx/serialization/json/JsonLiteralSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    @NotNull
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("gg.skytils.ktx-serialization.json.JsonLiteral", PrimitiveKind.STRING.INSTANCE);

    private JsonLiteralSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonLiteral value) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElementSerializersKt.access$verify(encoder2);
        if (value.isString()) {
            encoder2.encodeString(value.getContent());
            return;
        }
        if (value.getCoerceToInlineType$kotlinx_serialization_json() != null) {
            encoder2.encodeInline(value.getCoerceToInlineType$kotlinx_serialization_json()).encodeString(value.getContent());
            return;
        }
        Constable constable = StringsKt.toLongOrNull((String)value.getContent());
        if (constable != null) {
            long it = ((Number)((Object)constable)).longValue();
            boolean bl = false;
            encoder2.encodeLong(it);
            return;
        }
        constable = UStringsKt.toULongOrNull((String)value.getContent());
        if (constable != null) {
            long it = constable.unbox-impl();
            boolean bl = false;
            encoder2.encodeInline(BuiltinSerializersKt.serializer(ULong.Companion).getDescriptor()).encodeLong(it);
            return;
        }
        constable = StringsKt.toDoubleOrNull((String)value.getContent());
        if (constable != null) {
            double it = ((Number)((Object)constable)).doubleValue();
            boolean bl = false;
            encoder2.encodeDouble(it);
            return;
        }
        constable = StringsKt.toBooleanStrictOrNull((String)value.getContent());
        if (constable != null) {
            boolean it = (Boolean)constable;
            boolean bl = false;
            encoder2.encodeBoolean(it);
            return;
        }
        encoder2.encodeString(value.getContent());
    }

    @Override
    @NotNull
    public JsonLiteral deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonElement result2 = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (!(result2 instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(result2.getClass()), result2.toString());
        }
        return (JsonLiteral)result2;
    }
}

