/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.flow.postprocessing;

import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.flow.postprocessing.ArrayCreationInfo;
import gg.skytils.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import gg.skytils.mixinextras.expression.impl.utils.ExpressionASMUtils;
import gg.skytils.mixinextras.lib.apache.commons.tuple.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class NewArrayPostProcessor
implements FlowPostProcessor {
    private final Comparator<Pair<FlowValue, Integer>> insnIndexComparator = Comparator.comparingInt(o -> method2.instructions.indexOf(((FlowValue)o.getLeft()).getInsn()));

    public NewArrayPostProcessor(MethodNode method2) {
    }

    @Override
    public void process(FlowValue node, FlowPostProcessor.OutputSink sink) {
        AbstractInsnNode insn = node.getInsn();
        if (insn.getOpcode() == 189 || insn.getOpcode() == 188) {
            List<FlowValue> stores = this.getCreationStores(node);
            if (stores == null || stores.isEmpty()) {
                return;
            }
            sink.markAsSynthetic(node.getInput(0));
            for (FlowValue store2 : stores) {
                sink.markAsSynthetic(store2);
                sink.markAsSynthetic(store2.getInput(1));
            }
            node.decorate("mixinextras_persistent_arrayCreationInfo", new ArrayCreationInfo(stores.get(stores.size() - 1)));
            node.setParents((FlowValue[])stores.stream().map(it -> it.getInput(2)).toArray(FlowValue[]::new));
        }
    }

    private List<FlowValue> getCreationStores(FlowValue array) {
        Integer size2 = this.getIntConstant(array.getInput(0));
        if (size2 == null) {
            return null;
        }
        List sortedNext = array.getNext().stream().filter(it -> !((FlowValue)it.getLeft()).isComplex()).sorted(this.insnIndexComparator).map(Pair::getLeft).collect(Collectors.toList());
        if (sortedNext.size() < size2) {
            return null;
        }
        ArrayList<FlowValue> stores = new ArrayList<FlowValue>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            FlowValue store2 = (FlowValue)sortedNext.get(i2);
            if (!this.isStore(array, store2, i2)) {
                return null;
            }
            stores.add(store2);
        }
        return stores;
    }

    private Integer getIntConstant(FlowValue node) {
        if (node.isComplex()) {
            return null;
        }
        Object cst = ExpressionASMUtils.getConstant(node.getInsn());
        if (!(cst instanceof Integer)) {
            return null;
        }
        return (int)((Integer)cst);
    }

    private boolean isStore(FlowValue array, FlowValue store2, int index) {
        int opcode = store2.getInsn().getOpcode();
        if (opcode < 79 || opcode > 86) {
            return false;
        }
        if (store2.getInput(0) != array) {
            return false;
        }
        return Objects.equals(index, this.getIntConstant(store2.getInput(1)));
    }
}

