/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.sugar.impl.handlers;

import gg.skytils.mixinextras.injector.wrapoperation.WrapOperation;
import gg.skytils.mixinextras.service.MixinExtrasService;
import gg.skytils.mixinextras.sugar.impl.SugarParameter;
import gg.skytils.mixinextras.sugar.impl.handlers.HandlerInfo;
import gg.skytils.mixinextras.sugar.impl.handlers.HandlerTransformer;
import gg.skytils.mixinextras.sugar.impl.ref.LocalRefUtils;
import gg.skytils.mixinextras.utils.ASMUtils;
import gg.skytils.mixinextras.wrapper.factory.FactoryRedirectWrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;

class LocalHandlerTransformer
extends HandlerTransformer {
    private static final Set<String> TARGET_INJECTORS = new HashSet<String>(Arrays.asList(Type.getDescriptor(ModifyConstant.class), Type.getDescriptor(Redirect.class), Type.getDescriptor(FactoryRedirectWrapper.class)));

    LocalHandlerTransformer(IMixinInfo mixin, SugarParameter parameter) {
        super(mixin, parameter);
    }

    @Override
    public boolean isRequired(MethodNode handler2) {
        AnnotationNode annotation = InjectionInfo.getInjectorAnnotation((IMixinInfo)this.mixin, (MethodNode)handler2);
        return annotation != null && TARGET_INJECTORS.contains(annotation.desc) && LocalRefUtils.getTargetType(this.parameter.type, this.parameter.genericType) == this.parameter.type;
    }

    @Override
    public void transform(HandlerInfo info) {
        Type wrapperType = Type.getType(LocalRefUtils.getInterfaceFor(this.parameter.type));
        info.wrapParameter(this.parameter, wrapperType, ASMUtils.isPrimitive(this.parameter.type) ? null : this.parameter.type, (insns, load2) -> LocalRefUtils.generateUnwrapping(insns, this.parameter.type, load2));
    }

    static {
        for (String name : MixinExtrasService.getInstance().getAllClassNames(WrapOperation.class.getName())) {
            TARGET_INJECTORS.add('L' + name.replace('.', '/') + ';');
        }
    }
}

