/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map;

import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.CatlasConfig;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomData;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomState;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.RoomType;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.Tile;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.core.map.UniqueRoom;
import gg.skytils.skytilsmod.features.impl.dungeons.catlas.handlers.DungeonInfo;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u00102\u001a\u00020\u0002\u0012\u0006\u00104\u001a\u00020\u0002\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b6\u00107J'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010,\u001a\u0004\u0018\u00010+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u0010\u0012\u001a\u0004\b3\u0010\u0014R\u001a\u00104\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b4\u0010\u0012\u001a\u0004\b5\u0010\u0014\u00a8\u00068"}, d2={"Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Room;", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/Tile;", "", "row", "column", "", "roomName", "", "addToUnique", "(IILjava/lang/String;)V", "Lkotlin/Pair;", "getArrayPosition", "()Lkotlin/Pair;", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "color", "core", "I", "getCore", "()I", "setCore", "(I)V", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomData;", "data", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomData;", "getData", "()Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomData;", "setData", "(Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomData;)V", "", "isSeparator", "Z", "()Z", "setSeparator", "(Z)V", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomState;", "state", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomState;", "getState", "()Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomState;", "setState", "(Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomState;)V", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/UniqueRoom;", "uniqueRoom", "Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/UniqueRoom;", "getUniqueRoom", "()Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/UniqueRoom;", "setUniqueRoom", "(Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/UniqueRoom;)V", "x", "getX", "z", "getZ", "<init>", "(IILgg/skytils/skytilsmod/features/impl/dungeons/catlas/core/map/RoomData;)V", "SkytilsMod"})
public final class Room
implements Tile {
    private final int x;
    private final int z;
    @NotNull
    private RoomData data;
    private int core;
    private boolean isSeparator;
    @NotNull
    private RoomState state;
    @Nullable
    private UniqueRoom uniqueRoom;

    public Room(int x, int z, @NotNull RoomData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.x = x;
        this.z = z;
        this.data = data2;
        this.state = RoomState.UNDISCOVERED;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @NotNull
    public final RoomData getData() {
        return this.data;
    }

    public final void setData(@NotNull RoomData roomData) {
        Intrinsics.checkNotNullParameter((Object)roomData, (String)"<set-?>");
        this.data = roomData;
    }

    public final int getCore() {
        return this.core;
    }

    public final void setCore(int n) {
        this.core = n;
    }

    public final boolean isSeparator() {
        return this.isSeparator;
    }

    public final void setSeparator(boolean bl) {
        this.isSeparator = bl;
    }

    @Override
    @NotNull
    public RoomState getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull RoomState roomState) {
        Intrinsics.checkNotNullParameter((Object)((Object)roomState), (String)"<set-?>");
        this.state = roomState;
    }

    @Override
    @NotNull
    public Color getColor() {
        Color color;
        if (this.getState() == RoomState.UNOPENED) {
            color = CatlasConfig.INSTANCE.getColorUnopened();
        } else {
            Color color2;
            Color color3;
            switch (WhenMappings.$EnumSwitchMapping$0[this.data.getType().ordinal()]) {
                case 1: {
                    color3 = CatlasConfig.INSTANCE.getColorBlood();
                    break;
                }
                case 2: {
                    color3 = CatlasConfig.INSTANCE.getColorMiniboss();
                    break;
                }
                case 3: {
                    color3 = CatlasConfig.INSTANCE.getColorEntrance();
                    break;
                }
                case 4: {
                    color3 = CatlasConfig.INSTANCE.getColorFairy();
                    break;
                }
                case 5: {
                    color3 = CatlasConfig.INSTANCE.getColorPuzzle();
                    break;
                }
                case 6: {
                    color3 = CatlasConfig.INSTANCE.getColorRare();
                    break;
                }
                case 7: {
                    color3 = CatlasConfig.INSTANCE.getColorTrap();
                    break;
                }
                default: {
                    color3 = CatlasConfig.INSTANCE.getColorRoom();
                }
            }
            Color $this$_get_color__u24lambda_u240 = color2 = color3;
            boolean bl = false;
            if (this.getState() == RoomState.PREVISITED) {
                Color color4 = $this$_get_color__u24lambda_u240.darker();
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"darker(...)");
                return color4;
            }
            color = color2;
        }
        return color;
    }

    @Nullable
    public final UniqueRoom getUniqueRoom() {
        return this.uniqueRoom;
    }

    public final void setUniqueRoom(@Nullable UniqueRoom uniqueRoom) {
        this.uniqueRoom = uniqueRoom;
    }

    @NotNull
    public final Pair<Integer, Integer> getArrayPosition() {
        return new Pair((Object)((this.getX() - -185) / 16), (Object)((this.getZ() - -185) / 16));
    }

    public final void addToUnique(int row, int column, @NotNull String roomName) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        UniqueRoom unique = DungeonInfo.INSTANCE.getUniqueRooms().get(roomName);
        if (unique == null) {
            UniqueRoom it = new UniqueRoom(column, row, this);
            boolean bl = false;
            DungeonInfo.INSTANCE.getUniqueRooms().put(roomName, it);
            this.uniqueRoom = it;
        } else {
            unique.addTile(column, row, this);
            this.uniqueRoom = unique;
        }
    }

    public static /* synthetic */ void addToUnique$default(Room room, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string = room.data.getName();
        }
        room.addToUnique(n, n2, string);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomType.values().length];
            try {
                nArray[RoomType.BLOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.CHAMPION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.ENTRANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.FAIRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.PUZZLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.RARE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomType.TRAP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

