/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.graphics.colors;

import gg.skytils.skytilsmod.utils.graphics.colors.CustomColor;
import java.awt.Color;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 ,2\u00020\u0001:\u0001,B'\u0012\u0006\u0010'\u001a\u00020\n\u0012\u0006\u0010\u001b\u001a\u00020\n\u0012\u0006\u0010$\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0010\u0010\fJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u001fR\u0011\u0010#\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\"\u0010$\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u0016\u001a\u0004\b%\u0010\u0018\"\u0004\b&\u0010\u001aR\"\u0010'\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u001c\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u001f\u00a8\u0006-"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/RainbowColor;", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "applyColor", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toHSV", "()[F", "toInt", "", "toString", "()Ljava/lang/String;", "", "brightness", "F", "getBrightness", "()F", "setBrightness", "(F)V", "offset", "I", "getOffset", "setOffset", "(I)V", "Ljava/awt/Color;", "getRainbowColor", "()Ljava/awt/Color;", "rainbowColor", "saturation", "getSaturation", "setSaturation", "speed", "getSpeed", "setSpeed", "<init>", "(IIFF)V", "Companion", "SkytilsMod"})
public final class RainbowColor
extends CustomColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int speed;
    private int offset;
    private float saturation;
    private float brightness;

    public RainbowColor(int speed, int offset, float saturation, float brightness) {
        this.speed = speed;
        this.offset = offset;
        this.saturation = saturation;
        this.brightness = brightness;
    }

    public final int getSpeed() {
        return this.speed;
    }

    public final void setSpeed(int n) {
        this.speed = n;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float f) {
        this.saturation = f;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float f) {
        this.brightness = f;
    }

    @NotNull
    public final Color getRainbowColor() {
        float hue = (System.currentTimeMillis() + (long)this.offset) % (long)(this.speed == 0 ? 1 : this.speed);
        Color color = Color.getHSBColor(hue /= (float)(this.speed == 0 ? 1 : this.speed), this.saturation, this.brightness);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getHSBColor(...)");
        return color;
    }

    @Override
    public void applyColor() {
        Color color = this.getRainbowColor();
        GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getGreen() / 255.0f));
    }

    @Override
    @NotNull
    public float[] toHSV() {
        Color color = this.getRainbowColor();
        float r = color.getRed();
        float g2 = color.getBlue();
        float b = color.getBlue();
        float a = color.getAlpha();
        float hue = 0.0f;
        float saturation = 0.0f;
        float value = 0.0f;
        float cmax = RangesKt.coerceAtLeast((float)RangesKt.coerceAtLeast((float)r, (float)g2), (float)b);
        float cmin = Math.min(RangesKt.coerceAtMost((float)r, (float)g2), b);
        value = cmax;
        saturation = cmax == 0.0f ? 0.0f : (cmax - cmin) / cmax;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g2) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] fArray = new float[]{hue, saturation, value, a};
        return fArray;
    }

    @Override
    public int toInt() {
        return this.getRainbowColor().getRGB();
    }

    @Override
    @NotNull
    public String toString() {
        return "rainbow(" + this.speed + ',' + this.offset + ',' + this.saturation + ',' + this.brightness + ')';
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RainbowColor) {
            return this.speed == ((RainbowColor)other).speed && this.offset == ((RainbowColor)other).offset && this.saturation == ((RainbowColor)other).saturation && this.brightness == ((RainbowColor)other).brightness;
        }
        return false;
    }

    @Override
    public int hashCode() {
        float[] fArray = new float[]{this.speed, this.offset, this.saturation, this.brightness};
        return Arrays.hashCode(fArray);
    }

    @JvmStatic
    @NotNull
    public static final RainbowColor fromString(@Nullable String string) {
        return Companion.fromString(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/RainbowColor$Companion;", "", "", "string", "Lgg/skytils/skytilsmod/utils/graphics/colors/RainbowColor;", "fromString", "(Ljava/lang/String;)Lgg/skytils/skytilsmod/utils/graphics/colors/RainbowColor;", "<init>", "()V", "SkytilsMod"})
    @SourceDebugExtension(value={"SMAP\nRainbowColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RainbowColor.kt\ngg/skytils/skytilsmod/utils/graphics/colors/RainbowColor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RainbowColor fromString(@Nullable String string) {
            RainbowColor rainbowColor;
            if (string == null) {
                throw new NullPointerException("Argument cannot be null!");
            }
            if (!(StringsKt.startsWith$default((String)string, (String)"rainbow(", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)string, (String)")", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-RainbowColor$Companion$fromString$22 = false;
                String $i$a$-require-RainbowColor$Companion$fromString$22 = "Invalid rainbow color format";
                throw new IllegalArgumentException($i$a$-require-RainbowColor$Companion$fromString$22.toString());
            }
            try {
                int first2 = StringsKt.indexOf$default((CharSequence)string, (String)",", (int)0, (boolean)false, (int)6, null);
                int second2 = StringsKt.indexOf$default((CharSequence)string, (String)",", (int)(first2 + 1), (boolean)false, (int)4, null);
                int third = StringsKt.lastIndexOf$default((CharSequence)string, (String)",", (int)0, (boolean)false, (int)6, null);
                String string2 = string.substring(StringsKt.indexOf$default((CharSequence)string, (String)"(", (int)0, (boolean)false, (int)6, null) + 1, first2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int speed = Integer.parseInt(string2);
                String string3 = string.substring(first2 + 1, second2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                int offset = Integer.parseInt(string3);
                String string4 = string.substring(second2 + 1, third);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                float saturation = Float.parseFloat(string4);
                String string5 = string.substring(third + 1, StringsKt.indexOf$default((CharSequence)string, (String)")", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                float brightness = Float.parseFloat(string5);
                rainbowColor = new RainbowColor(speed, offset, saturation, brightness);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Invalid rainbow string");
            }
            return rainbowColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

